/*
 * Decompiled with CFR 0.152.
 */
package kilim;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import kilim.Event;
import kilim.EventPublisher;
import kilim.EventSubscriber;
import kilim.ExitMsg;
import kilim.Fiber;
import kilim.Mailbox;
import kilim.NotPausable;
import kilim.Pausable;
import kilim.PauseReason;
import kilim.Scheduler;
import kilim.State;
import kilim.TaskDoneReason;
import kilim.WorkerThread;
import kilim.YieldReason;

public abstract class Task
implements EventSubscriber {
    public volatile Thread currentThread = null;
    static PauseReason yieldReason = new YieldReason();
    public final int id = idSource.incrementAndGet();
    static final AtomicInteger idSource = new AtomicInteger();
    protected Fiber fiber = new Fiber(this);
    protected PauseReason pauseReason;
    protected boolean running = false;
    protected boolean done = false;
    volatile WorkerThread preferredResumeThread;
    int numActivePins;
    private LinkedList<Mailbox<ExitMsg>> exitMBs;
    protected Scheduler scheduler;
    public Object exitResult = "OK";
    public static final Timer timer = new Timer(true);
    public static final boolean $isWoven = true;

    public int id() {
        return this.id;
    }

    public synchronized Task setScheduler(Scheduler s) {
        this.scheduler = s;
        return this;
    }

    public synchronized Scheduler getScheduler() {
        return this.scheduler;
    }

    /*
     * WARNING - void declaration
     */
    public void resumeOnScheduler(Scheduler scheduler, Fiber fiber) throws Pausable {
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                break;
            }
            case 0: {
                void s;
                if (this.scheduler == s) {
                    return;
                }
                this.scheduler = s;
            }
        }
        Task.yield(fiber.down());
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    public void resumeOnScheduler(Scheduler scheduler) throws Pausable {
        Task.errNotWoven();
    }

    public Task start() {
        if (this.scheduler == null) {
            this.setScheduler(Scheduler.getDefaultScheduler());
        }
        this.resume();
        return this;
    }

    public int getStackDepth() {
        String DELIMIT_CALLER = "resumeExecution";
        StackTraceElement[] stes = new Exception().getStackTrace();
        int len = stes.length;
        for (int i = 0; i < len; ++i) {
            StackTraceElement ste = stes[i];
            if (!ste.getMethodName().equals("resumeExecution")) continue;
            return i - 1;
        }
        throw new AssertionError((Object)"Expected task to be run by WorkerThread");
    }

    @Override
    public void onEvent(EventPublisher ep, Event e) {
        this.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resume() {
        if (this.scheduler == null) {
            return false;
        }
        boolean doSchedule = false;
        Task task = this;
        synchronized (task) {
            if (this.done || this.running) {
                return false;
            }
            doSchedule = true;
            this.running = true;
        }
        if (doSchedule) {
            this.scheduler.schedule(this);
        }
        return doSchedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informOnExit(Mailbox<ExitMsg> exit) {
        if (this.isDone()) {
            exit.putnb(new ExitMsg(this, this.exitResult));
            return;
        }
        Task task = this;
        synchronized (task) {
            if (this.exitMBs == null) {
                this.exitMBs = new LinkedList();
            }
            this.exitMBs.add(exit);
        }
    }

    public static Task getCurrentTask(Fiber fiber) throws Pausable {
        Fiber fiber2 = fiber;
        return null;
    }

    public static Task getCurrentTask() throws Pausable {
        Task.errNotWoven();
        return null;
    }

    public static void exit(Object aExitValue) throws Pausable {
    }

    public static void exit(Object aExitValue, Fiber f) {
        assert (f.pc == 0) : "f.pc != 0";
        f.task.setPauseReason(new TaskDoneReason(aExitValue));
        f.togglePause();
    }

    public static void errorExit(Throwable ex) throws Pausable {
    }

    public static void errorExit(Throwable ex, Fiber f) {
        assert (f.pc == 0) : "fc.pc != 0";
        f.task.setPauseReason(new TaskDoneReason(ex));
        f.togglePause();
    }

    public static void errNotWoven() {
        System.err.println("############################################################");
        System.err.println("Task has either not been woven or the classpath is incorrect");
        System.err.println("############################################################");
        Thread.dumpStack();
        System.exit(0);
    }

    public static void errNotWoven(Task t) {
        System.err.println("############################################################");
        System.err.println("Task " + t.getClass() + " has either not been woven or the classpath is incorrect");
        System.err.println("############################################################");
        Thread.dumpStack();
        System.exit(0);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invoke(Method method, Object object, Object[] objectArray,  /* corrupt varargs signature?! */ FiberFiber fiber) throws Pausable, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object target;
        Object[] fargs;
        Method mthd;
        Fiber fiber2 = fiber;
        Fiber f = fiber2.task.fiber;
        if (f.pc == 0) {
            void args;
            mthd = Task.getWovenMethod(mthd);
            if (args == null) {
                fargs = new Object[1];
            } else {
                fargs = new Object[((void)args).length + 1];
                System.arraycopy(args, 0, fargs, 0, ((void)args).length);
            }
            fargs[fargs.length - 1] = f;
        } else {
            ArgState as = (ArgState)f.getState();
            mthd = (Method)as.mthd;
            target = as.obj;
            fargs = as.fargs;
        }
        f.down();
        Object ret = mthd.invoke(target, fargs);
        switch (f.up()) {
            case 0: 
            case 1: {
                return ret;
            }
            case 2: {
                ArgState as = new ArgState();
                as.fargs = fargs;
                as.pc = 1;
                as.mthd = mthd;
                f.setState(as);
                return null;
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalAccessException("Internal Error");
    }

    public static Object invoke(Method method, Object object, Object ... objectArray) throws Pausable, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Task.errNotWoven();
        return null;
    }

    private static Method getWovenMethod(Method m) {
        Class<?>[] ptypes = m.getParameterTypes();
        if (ptypes.length <= 0 || !ptypes[ptypes.length - 1].getName().equals("kilim.Fiber")) {
            boolean found = false;
            block0: for (Method wm : m.getDeclaringClass().getDeclaredMethods()) {
                Class<?>[] wptypes;
                if (wm == m || !wm.getName().equals(m.getName()) || (wptypes = wm.getParameterTypes()).length != ptypes.length + 1 || !wptypes[wptypes.length - 1].getName().equals("kilim.Fiber")) continue;
                for (int i = 0; i < ptypes.length; ++i) {
                    if (ptypes[i] != wptypes[i]) continue block0;
                }
                m = wm;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("Found no pausable method corresponding to supplied method: " + m);
            }
        }
        return m;
    }

    public static void sleep(long l, Fiber fiber) throws Pausable {
        Mailbox mailbox;
        Fiber fiber2 = fiber;
        switch (fiber2.pc) {
            default: {
                fiber2.wrongPC();
            }
            case 1: {
                fiber = null;
                mailbox = (Mailbox)fiber2.getCallee();
                break;
            }
            case 0: {
                long millis;
                final Mailbox sleepmb = new Mailbox(1);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        sleepmb.putnb(0);
                    }
                }, millis);
                mailbox = sleepmb;
            }
        }
        Object t = mailbox.get(fiber2.down());
        switch (fiber2.up()) {
            case 2: {
                State state = new State();
                state.pc = 1;
                fiber2.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    public static void sleep(long l) throws Pausable {
        Task.errNotWoven();
    }

    public static void yield() throws Pausable {
        Task.errNotWoven();
    }

    public static void yield(Fiber f) {
        if (f.pc == 0) {
            f.task.setPauseReason(yieldReason);
        } else {
            f.task.setPauseReason(null);
        }
        f.togglePause();
    }

    public static void pause(PauseReason pauseReason) throws Pausable {
        Task.errNotWoven();
    }

    public static void pause(PauseReason pauseReason, Fiber f) {
        if (f.pc == 0) {
            f.task.setPauseReason(pauseReason);
        } else {
            f.task.setPauseReason(null);
        }
        f.togglePause();
    }

    public void execute() throws Pausable, Exception {
        Task.errNotWoven(this);
    }

    public void execute(Fiber f) throws Exception {
        Task.errNotWoven(this);
    }

    public String toString() {
        return "" + this.id + "(running=" + this.running + ",pr=" + this.pauseReason + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        Task task = this;
        synchronized (task) {
            return "" + this.id + "(running=" + this.running + ", pr=" + this.pauseReason + ")";
        }
    }

    public void pinToThread() {
        ++this.numActivePins;
    }

    public void unpinFromThread() {
        --this.numActivePins;
    }

    protected final void setPauseReason(PauseReason pr) {
        this.pauseReason = pr;
    }

    public final PauseReason getPauseReason() {
        return this.pauseReason;
    }

    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _runExecute(WorkerThread thread) throws NotPausable {
        Fiber f = this.fiber;
        boolean isDone = false;
        try {
            this.currentThread = Thread.currentThread();
            assert (this.preferredResumeThread == null || this.preferredResumeThread == thread) : "Resumed " + this.id + " in incorrect thread. ";
            this.execute(f.begin());
            boolean bl = isDone = f.end() || this.pauseReason instanceof TaskDoneReason;
            assert (this.pauseReason == null && isDone || this.pauseReason != null && !isDone) : "pauseReason:" + this.pauseReason + ",isDone =" + isDone;
        }
        catch (Throwable th) {
            th.printStackTrace();
            this.setPauseReason(new TaskDoneReason(th));
            isDone = true;
        }
        if (isDone) {
            this.done = true;
            if (this.numActivePins > 0) {
                throw new AssertionError((Object)"Task ended but has active locks");
            }
            if (this.exitMBs != null) {
                if (this.pauseReason instanceof TaskDoneReason) {
                    this.exitResult = ((TaskDoneReason)this.pauseReason).exitObj;
                }
                ExitMsg msg = new ExitMsg(this, this.exitResult);
                for (Mailbox mailbox : this.exitMBs) {
                    mailbox.putnb(msg);
                }
            }
            this.preferredResumeThread = null;
        } else {
            if (thread != null) {
                if (this.numActivePins > 0) {
                    this.preferredResumeThread = thread;
                } else {
                    assert (this.numActivePins == 0) : "numActivePins == " + this.numActivePins;
                    this.preferredResumeThread = null;
                }
            }
            PauseReason pr = this.pauseReason;
            Task task = this;
            synchronized (task) {
                this.running = false;
                this.currentThread = null;
            }
            if (!pr.isValid(this)) {
                this.resume();
            }
        }
    }

    public boolean resumeExecution() throws NotPausable {
        Fiber f = this.fiber;
        boolean isDone = false;
        try {
            this.execute(f.begin());
            boolean bl = isDone = f.end() || this.pauseReason instanceof TaskDoneReason;
            assert (this.pauseReason == null && isDone || this.pauseReason != null && !isDone) : "pauseReason:" + this.pauseReason + ",isDone =" + isDone;
        }
        catch (Throwable th) {
            th.printStackTrace();
            this.setPauseReason(new TaskDoneReason(th));
            isDone = true;
        }
        if (isDone) {
            this.done = true;
            assert (this.numActivePins == 0) : "Task ended but has " + this.numActivePins + " active locks";
        } else assert (this.numActivePins == 0) : "Task suspended but has " + this.numActivePins + " active locks";
        return isDone;
    }

    public ExitMsg joinb() {
        Mailbox<ExitMsg> mb = new Mailbox<ExitMsg>();
        this.informOnExit(mb);
        return mb.getb();
    }

    public ExitMsg join(Fiber fiber) throws Pausable {
        Mailbox<ExitMsg> mailbox;
        Fiber fiber2 = fiber;
        switch (fiber2.pc) {
            default: {
                fiber2.wrongPC();
            }
            case 1: {
                fiber = null;
                mailbox = (Mailbox<ExitMsg>)fiber2.getCallee();
                break;
            }
            case 0: {
                Mailbox<ExitMsg> mb = new Mailbox<ExitMsg>();
                this.informOnExit(mb);
                mailbox = mb;
            }
        }
        switch (fiber2.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber2.setState(state);
                return null;
            }
            case 3: {
                return null;
            }
        }
        return mailbox.get(fiber2.down());
    }

    public ExitMsg join() throws Pausable {
        Task.errNotWoven();
        return null;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.id;
    }

    static class ArgState
    extends State {
        Object mthd;
        Object obj;
        Object[] fargs;

        ArgState() {
        }
    }
}

