/*
 * Decompiled with CFR 0.152.
 */
package kilim;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kilim.KilimClassLoader;
import kilim.analysis.ClassInfo;
import kilim.analysis.FileLister;
import kilim.tools.Weaver;

public class WeavingClassLoader
extends KilimClassLoader {
    public static final String KILIM_CLASSPATH = "kilim.class.path";
    ArrayList<FileLister> fileContainers;
    Weaver weaver;

    public WeavingClassLoader(ClassLoader parent) {
        super(parent);
        String classPath = System.getProperty(KILIM_CLASSPATH, "");
        String[] classPaths = classPath.split(":");
        this.fileContainers = new ArrayList(classPaths.length);
        for (String name : classPaths) {
            if ((name = name.trim()).equals("")) continue;
            try {
                this.fileContainers.add(new FileLister(name));
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        this.weaver = new Weaver(this);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> ret = null;
        for (FileLister container : this.fileContainers) {
            try {
                String classFileName = name.replace('.', File.separatorChar) + ".class";
                FileLister.Entry fe = container.open(classFileName);
                if (fe == null) continue;
                byte[] code = WeavingClassLoader.readFully(fe);
                List<ClassInfo> cis = this.weaver.weave(new ClassInfo(name, code));
                for (ClassInfo ci : cis) {
                    if (this.findLoadedClass(ci.className) != null) continue;
                    Class<?> c = super.defineClass(ci.className, ci.bytes, 0, ci.bytes.length);
                    if (ci.className.equals(name)) {
                        ret = c;
                        continue;
                    }
                    if (!ci.className.startsWith("kilim.S")) continue;
                    super.resolveClass(c);
                }
                if (ret != null) continue;
                ret = super.defineClass(name, code, 0, code.length);
            }
            catch (IOException ignore) {
                System.err.println(ignore.getMessage());
            }
        }
        if (ret == null) {
            throw new ClassNotFoundException(name);
        }
        return ret;
    }

    private static byte[] readFully(FileLister.Entry fe) throws IOException {
        DataInputStream in = new DataInputStream(fe.getInputStream());
        byte[] contents = new byte[(int)fe.getSize()];
        in.readFully(contents);
        in.close();
        return contents;
    }
}

