/*
 * Decompiled with CFR 0.152.
 */
package kilim;

import java.util.concurrent.atomic.AtomicInteger;
import kilim.RingQueue;
import kilim.Scheduler;
import kilim.ShutdownException;
import kilim.Task;

public class WorkerThread
extends Thread {
    volatile Task runningTask;
    RingQueue<Task> tasks = new RingQueue(10);
    Scheduler scheduler;
    static AtomicInteger gid = new AtomicInteger();
    public int numResumes = 0;

    WorkerThread(Scheduler ascheduler) {
        super("KilimWorker-" + gid.incrementAndGet());
        throw new IllegalStateException("Unexpected use of kilim worker threads");
    }

    @Override
    public void run() {
        try {
            while (true) {
                Task t;
                this.runningTask = t = this.getNextTask(this);
                t._runExecute(this);
                this.runningTask = null;
            }
        }
        catch (ShutdownException se) {
        }
        catch (OutOfMemoryError ex) {
            System.err.println("Out of memory");
            System.exit(1);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            System.err.println(this.runningTask);
        }
        this.runningTask = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Task getNextTask(WorkerThread workerThread) throws ShutdownException {
        Task t = null;
        while (true) {
            if (this.scheduler.isShutdown()) {
                throw new ShutdownException();
            }
            t = this.getNextTask();
            if (t != null) break;
            this.scheduler.loadNextTask(this);
            WorkerThread workerThread2 = this;
            synchronized (workerThread2) {
                t = this.tasks.get();
                if (t != null) {
                    break;
                }
                this.scheduler.addWaitingThread(this);
                try {
                    this.wait();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
        }
        assert (t != null) : "Returning null task";
        return t;
    }

    public Task getCurrentTask() {
        return this.runningTask;
    }

    public synchronized void addRunnableTask(Task t) {
        assert (t.preferredResumeThread == null || t.preferredResumeThread == this) : "Task given to wrong thread";
        this.tasks.put(t);
        this.notify();
    }

    public synchronized boolean hasTasks() {
        return this.tasks.size() > 0;
    }

    public synchronized Task getNextTask() {
        return this.tasks.get();
    }

    public synchronized void waitForMsgOrSignal() {
        try {
            if (this.tasks.size() == 0) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

