/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import kilim.KilimException;
import kilim.analysis.MethodFlow;
import kilim.analysis.TypeDesc;
import kilim.mirrors.Detector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class ClassFlow
extends ClassNode {
    ArrayList<MethodFlow> methodFlows;
    ClassReader cr;
    String classDesc;
    private boolean isPausable;
    public boolean isWoven = false;
    private Detector detector;

    public ClassFlow(InputStream is, Detector detector) throws IOException {
        this.cr = new ClassReader(is);
        this.detector = detector;
    }

    public ClassFlow(String aClassName, Detector detector) throws IOException {
        this.cr = new ClassReader(aClassName);
        this.detector = detector;
    }

    public ClassFlow(byte[] data, Detector detector) {
        this.cr = new ClassReader(data);
        this.detector = detector;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodFlow mn = new MethodFlow(this, access, name, desc, signature, exceptions, this.detector);
        this.methods.add(mn);
        return mn;
    }

    public ArrayList<MethodFlow> getMethodFlows() {
        assert (this.methodFlows != null) : "ClassFlow.analyze not called";
        return this.methodFlows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MethodFlow> analyze(boolean forceAnalysis) throws KilimException {
        Detector save = Detector.setDetector(this.detector);
        try {
            this.cr.accept(this, 0);
            for (Object o : this.fields) {
                FieldNode fn = (FieldNode)o;
                if (!fn.name.equals("$isWoven")) continue;
                this.isWoven = true;
                break;
            }
            if (this.isWoven && !forceAnalysis) {
                ArrayList i$ = new ArrayList();
                return i$;
            }
            this.cr = null;
            this.classDesc = TypeDesc.getInterned("L" + this.name + ';');
            ArrayList<MethodFlow> flows = new ArrayList<MethodFlow>(this.methods.size());
            String msg = "";
            for (Object o : this.methods) {
                try {
                    MethodFlow mmf;
                    MethodFlow mf = (MethodFlow)o;
                    if (mf.isBridge() && (mmf = this.getOrigWithSameSig(mf)) != null) {
                        mf.setPausable(mmf.isPausable());
                    }
                    mf.verifyPausables();
                    if (mf.isPausable()) {
                        this.isPausable = true;
                    }
                    if ((mf.isPausable() || forceAnalysis) && !mf.isAbstract()) {
                        mf.analyze();
                    }
                    flows.add(mf);
                }
                catch (KilimException ke) {
                    msg = msg + ke.getMessage() + "\n-------------------------------------------------\n";
                }
            }
            if (msg.length() > 0) {
                throw new KilimException(msg);
            }
            this.methodFlows = flows;
            ArrayList<MethodFlow> arrayList = flows;
            return arrayList;
        }
        finally {
            Detector.setDetector(save);
        }
    }

    private MethodFlow getOrigWithSameSig(MethodFlow bridgeMethod) {
        for (Object o : this.methods) {
            String bmArgs;
            String mfArgs;
            MethodFlow mf = (MethodFlow)o;
            if (mf == bridgeMethod || !mf.name.equals(bridgeMethod.name) || !(mfArgs = mf.desc.substring(0, mf.desc.indexOf(41))).equals(bmArgs = bridgeMethod.desc.substring(0, bridgeMethod.desc.indexOf(41)))) continue;
            return mf;
        }
        return null;
    }

    public String getClassDescriptor() {
        return this.classDesc;
    }

    public String getClassName() {
        return this.name.replace('/', '.');
    }

    public boolean isPausable() {
        this.getMethodFlows();
        return this.isPausable;
    }

    boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public Detector detector() {
        return this.detector;
    }
}

