/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import kilim.analysis.FileContainer;
import kilim.analysis.FileLister;

class DirIterator
extends FileContainer {
    final File root;
    Stack<File> stack = new Stack();

    DirIterator(File f) {
        this.root = f;
        this.stack.push(f);
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    @Override
    public FileLister.Entry next() {
        File ret = this.stack.pop();
        if (ret.isDirectory()) {
            File ff;
            int i;
            File[] files = ret.listFiles();
            for (i = files.length - 1; i >= 0; --i) {
                ff = files[i];
                if (!ff.isDirectory()) continue;
                this.stack.push(ff);
            }
            for (i = files.length - 1; i >= 0; --i) {
                ff = files[i];
                if (ff.isDirectory()) continue;
                this.stack.push(ff);
            }
        }
        return new DirEntry(ret);
    }

    @Override
    public void remove() {
        throw new RuntimeException("FileLister does not remove files");
    }

    @Override
    FileLister.Entry open(String fileName) throws IOException {
        File ret = new File(this.root.getAbsolutePath() + File.separatorChar + fileName);
        if (ret.exists() && ret.isFile()) {
            return new DirEntry(ret);
        }
        return null;
    }

    private static class DirEntry
    extends FileLister.Entry {
        final File file;

        DirEntry(File f) {
            this.file = f;
        }

        @Override
        public long getSize() {
            return this.file.length();
        }

        @Override
        public String getFileName() {
            try {
                return this.file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
    }
}

