/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.jar.JarFile;
import kilim.analysis.DirIterator;
import kilim.analysis.FileContainer;
import kilim.analysis.JarIterator;

public class FileLister
implements Iterable<Entry> {
    volatile WeakReference<FileContainer> containerRef;
    String name;

    public FileLister(String dirOrJarName) throws IOException {
        this.name = dirOrJarName;
    }

    public Entry open(String relativeFileName) throws IOException {
        return this.getContainer().open(relativeFileName);
    }

    private FileContainer getContainer() throws IOException {
        FileContainer container = null;
        if (this.containerRef != null && (container = (FileContainer)this.containerRef.get()) != null) {
            return container;
        }
        if (this.name.endsWith(".jar")) {
            container = this.openJar(this.name);
        } else {
            File f = new File(this.name);
            if (f.exists() && f.isDirectory()) {
                container = new DirIterator(f);
            } else {
                throw new IOException("Expected jar file or directory name");
            }
        }
        this.containerRef = new WeakReference<FileContainer>(container);
        return container;
    }

    private FileContainer openJar(String jarFile) throws IOException {
        return new JarIterator(new JarFile(jarFile));
    }

    @Override
    public Iterator<Entry> iterator() {
        try {
            return this.getContainer();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static abstract class Entry {
        public abstract String getFileName();

        public abstract long getSize();

        public abstract InputStream getInputStream() throws IOException;
    }
}

