/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import kilim.analysis.TypeDesc;
import kilim.analysis.Usage;
import kilim.analysis.Value;
import org.objectweb.asm.tree.MethodNode;

public class Frame {
    Value[] locals;
    Value[] stack;
    int numMonitorsActive = 0;
    int stacklen = 0;

    private Frame(int nLocals, int nStack, boolean init) {
        this.locals = new Value[nLocals];
        if (init) {
            for (int i = 0; i < nLocals; ++i) {
                this.locals[i] = Value.V_UNDEFINED;
            }
        }
        this.stack = new Value[nStack];
    }

    public Frame(int nLocals, int nStack) {
        this(nLocals, nStack, true);
    }

    public Frame merge(Frame inframe, boolean localsOnly, Usage usage) {
        int slen = this.stacklen;
        Value[] nst = null;
        if (!localsOnly) {
            Value[] st = this.stack;
            Value[] ist = inframe.stack;
            for (int i = 0; i < slen; ++i) {
                Value newval;
                Value va = st[i];
                Value vb = ist[i];
                if (va == vb || va.equals(vb) || (newval = va.merge(vb)) == va) continue;
                if (nst == null) {
                    nst = Frame.dupArray(st);
                }
                nst[i] = newval;
            }
        }
        Value[] lo = this.locals;
        Value[] ilo = inframe.locals;
        Value[] nlo = null;
        for (int i = 0; i < lo.length; ++i) {
            Value newval;
            Value vb;
            Value va;
            if (!usage.isLiveIn(i) || (va = lo[i]) == (vb = ilo[i]) || va.equals(vb) || (newval = va.merge(vb)) == va) continue;
            if (nlo == null) {
                nlo = Frame.dupArray(lo);
            }
            nlo[i] = newval;
        }
        if (nst == null && nlo == null) {
            return this;
        }
        if (nst == null) {
            nst = Frame.dupArray(this.stack);
        }
        if (nlo == null) {
            nlo = Frame.dupArray(this.locals);
        }
        return new Frame(nlo, nst, slen, this.numMonitorsActive);
    }

    public static Value[] dupArray(Value[] a) {
        Value[] ret = new Value[a.length];
        System.arraycopy(a, 0, ret, 0, a.length);
        return ret;
    }

    private Frame(Value[] alocals, Value[] astack, int astacklen, int aNumMonitorsActive) {
        this.locals = alocals;
        this.stack = astack;
        this.stacklen = astacklen;
        this.numMonitorsActive = aNumMonitorsActive;
    }

    public Frame dup() {
        return new Frame(Frame.dupArray(this.locals), Frame.dupArray(this.stack), this.stacklen, this.numMonitorsActive);
    }

    public Frame(String classDesc, MethodNode method) {
        this(method.maxLocals, method.maxStack, false);
        String[] argTypeDescs = TypeDesc.getArgumentTypes(method.desc);
        for (int i = 0; i < method.maxLocals; ++i) {
            this.setLocal(i, Value.V_UNDEFINED);
        }
        int local = 0;
        int paramPos = 100000;
        if ((method.access & 8) == 0) {
            this.setLocal(local++, Value.make(paramPos++, classDesc));
        }
        for (int i = 0; i < argTypeDescs.length; ++i) {
            local += this.setLocal(local, Value.make(paramPos++, argTypeDescs[i]));
        }
        if ((method.access & 0x20) != 0) {
            this.numMonitorsActive = 1;
        }
    }

    private boolean checkType(String desc) {
        if (desc.equals("Ljava/lang/Object;") && desc != "Ljava/lang/Object;") {
            return false;
        }
        switch (desc.charAt(0)) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'L': 
            case 'N': 
            case 'S': 
            case 'U': 
            case 'Z': 
            case '[': {
                return true;
            }
        }
        return false;
    }

    public int setLocal(int local, Value v) {
        assert (this.checkType(v.getTypeDesc())) : "Invalid type: " + v.getTypeDesc();
        this.locals[local] = v;
        if (v.isCategory2()) {
            this.locals[local + 1] = v;
            return 2;
        }
        return 1;
    }

    public Value getLocal(int local, int opcode) {
        Value v = this.locals[local];
        String desc = v.getTypeDesc();
        String expected = null;
        switch (opcode) {
            case 21: {
                if (TypeDesc.isIntType(desc)) {
                    return v;
                }
                expected = "int";
                break;
            }
            case 22: {
                if (desc == "J") {
                    return v;
                }
                expected = "long";
                break;
            }
            case 24: {
                if (desc == "D") {
                    return v;
                }
                expected = "double";
                break;
            }
            case 23: {
                if (desc == "F") {
                    return v;
                }
                expected = "float";
                break;
            }
            case 25: {
                if (TypeDesc.isRefType(desc)) {
                    return v;
                }
                expected = "ref";
            }
        }
        throw new AssertionError((Object)("Expected " + expected + " in local# " + local + ", got " + desc));
    }

    public Value getLocal(int local) {
        return this.locals[local];
    }

    public Value getStack(int pos) {
        return this.stack[pos];
    }

    public Value push(Value v) {
        assert (v != Value.V_UNDEFINED) : "UNDEFINED type pushed";
        assert (this.checkType(v.getTypeDesc())) : "Invalid type: " + v.getTypeDesc();
        this.stack[this.stacklen++] = v;
        return v;
    }

    public Value pop() {
        try {
            return this.stack[--this.stacklen];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("Verify error. Expected word in stack, but stack is empty");
        }
    }

    public Value popWord() {
        Value v = this.pop();
        assert (v.isCategory1()) : "double word present where single expected";
        return v;
    }

    public void popn(int n) {
        this.stacklen -= n;
    }

    void clearStack() {
        this.stacklen = 0;
    }

    public boolean equals(Object other) {
        int i;
        Frame that = (Frame)other;
        for (i = 0; i < this.locals.length; ++i) {
            if (this.locals[i].equals(that.locals[i])) continue;
            return false;
        }
        for (i = 0; i < this.stacklen; ++i) {
            if (this.stack[i].equals(that.stack[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i;
        int hash = 0;
        for (i = 0; i < this.locals.length; ++i) {
            hash ^= this.locals[i].hashCode();
        }
        for (i = 0; i < this.stacklen; ++i) {
            hash ^= this.locals[i].hashCode();
        }
        return hash;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer(100);
        int numDefined = 0;
        sb.append("): ");
        for (i = 0; i < this.locals.length; ++i) {
            Value v = this.locals[i];
            if (v == Value.V_UNDEFINED) continue;
            ++numDefined;
            sb.append(i).append(':').append(this.locals[i]).append(" ");
        }
        sb.insert(0, numDefined);
        sb.insert(0, "Locals(");
        sb.append("\n").append("Stack(").append(this.stacklen).append("): ");
        for (i = 0; i < this.stacklen; ++i) {
            sb.append(this.stack[i]).append(" ");
        }
        return sb.toString();
    }

    public int getMaxLocals() {
        return this.locals.length;
    }

    public int getStackLen() {
        return this.stacklen;
    }
}

