/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.util.ArrayList;
import java.util.Collections;
import kilim.analysis.BasicBlock;

public class Handler
implements Comparable<Handler> {
    public int from;
    public int to;
    public String type;
    public BasicBlock catchBB;

    public Handler(int aFrom, int aTo, String aType, BasicBlock aCatchBB) {
        this.from = aFrom;
        this.to = aTo;
        if (aType == null) {
            aType = "java/lang/Throwable";
        }
        this.type = aType;
        this.catchBB = aCatchBB;
    }

    @Override
    public int compareTo(Handler h) {
        int c = this.type.compareTo(h.type);
        if (c != 0) {
            return c;
        }
        c = this.catchBB.compareTo(h.catchBB);
        if (c != 0) {
            return c;
        }
        return this.from < h.from ? -1 : (this.from == h.from ? 0 : 1);
    }

    public static ArrayList<Handler> consolidate(ArrayList<Handler> list) {
        Collections.sort(list);
        ArrayList<Handler> newList = new ArrayList<Handler>(list.size());
        Handler cur = null;
        for (Handler h : list) {
            if (cur == null) {
                cur = h;
                newList.add(cur);
                continue;
            }
            if (cur.type.equals(h.type) && cur.catchBB == h.catchBB && h.from == cur.to + 1) {
                cur.to = h.to;
                continue;
            }
            cur = h;
            newList.add(cur);
        }
        return newList;
    }
}

