/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import kilim.KilimException;
import kilim.analysis.BBComparator;
import kilim.analysis.BBList;
import kilim.analysis.BasicBlock;
import kilim.analysis.ClassFlow;
import kilim.analysis.Frame;
import kilim.analysis.Handler;
import kilim.analysis.TypeDesc;
import kilim.mirrors.Detector;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class MethodFlow
extends MethodNode {
    ClassFlow classFlow;
    private ArrayList<Label> posToLabelMap;
    private HashMap<Label, Integer> labelToPosMap;
    private HashMap<Label, BasicBlock> labelToBBMap;
    private BBList basicBlocks;
    private PriorityQueue<BasicBlock> workset;
    private boolean hasPausableAnnotation;
    private boolean suppressPausableCheck;
    private List<MethodInsnNode> pausableMethods = new LinkedList<MethodInsnNode>();
    private final Detector detector;

    public MethodFlow(ClassFlow classFlow, int access, String name, String desc, String signature, String[] exceptions, Detector detector) {
        super(access, name, desc, signature, exceptions);
        this.classFlow = classFlow;
        this.detector = detector;
        int numInstructions = this.instructions.size();
        this.posToLabelMap = new ArrayList(numInstructions);
        for (int i = numInstructions - 1; i >= 0; --i) {
            this.posToLabelMap.add(null);
        }
        this.labelToPosMap = new HashMap(numInstructions * 2);
        this.labelToBBMap = new HashMap(numInstructions);
        if (exceptions != null && exceptions.length > 0) {
            for (String e : exceptions) {
                if (e.equals("kilim/Pausable")) {
                    this.hasPausableAnnotation = true;
                    break;
                }
                if (!e.equals("kilim/NotPausable")) continue;
                this.suppressPausableCheck = true;
            }
        }
    }

    public void analyze() throws KilimException {
        this.buildBasicBlocks();
        if (this.basicBlocks.size() == 0) {
            return;
        }
        this.consolidateBasicBlocks();
        this.assignCatchHandlers();
        this.inlineSubroutines();
        this.doLiveVarAnalysis();
        this.dataFlow();
        this.labelToBBMap = null;
    }

    public void verifyPausables() throws KilimException {
        if (this.classFlow.isWoven || this.suppressPausableCheck) {
            return;
        }
        if (!this.hasPausableAnnotation && !this.pausableMethods.isEmpty()) {
            String name = this.toString(this.classFlow.getClassName(), this.name, this.desc);
            String msg = this.name.endsWith("init>") ? "Constructor " + name + " calls pausable methods:\n" : name + " should be marked pausable. It calls pausable methods\n";
            for (MethodInsnNode min : this.pausableMethods) {
                msg = msg + this.toString(min.owner, min.name, min.desc) + '\n';
            }
            throw new KilimException(msg);
        }
        if (this.classFlow.superName != null) {
            this.checkStatus(this.classFlow.superName, this.name, this.desc);
        }
        if (this.classFlow.interfaces != null) {
            for (Object ifc : this.classFlow.interfaces) {
                this.checkStatus((String)ifc, this.name, this.desc);
            }
        }
    }

    private void checkStatus(String superClassName, String methodName, String desc) throws KilimException {
        int status = this.detector.getPausableStatus(superClassName, methodName, desc);
        if (status == 1 && !this.hasPausableAnnotation) {
            throw new KilimException("Base class method is pausable, derived class is not: \nBase class = " + superClassName + "\nDerived class = " + this.classFlow.name + "\nMethod = " + methodName + desc);
        }
        if (status == 2 && this.hasPausableAnnotation) {
            throw new KilimException("Base class method is not pausable, but derived class is: \nBase class = " + superClassName + "\nDerived class = " + this.classFlow.name + "\nMethod = " + methodName + desc);
        }
    }

    private String toString(String className, String methName, String desc) {
        return className.replace('/', '.') + '.' + methName + desc;
    }

    @Override
    public void visitLabel(Label label) {
        this.setLabel(this.instructions.size(), label);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        int methodStatus;
        super.visitMethodInsn(opcode, owner, name, desc);
        if (!this.classFlow.isWoven && (methodStatus = this.detector.getPausableStatus(owner, name, desc)) == 1) {
            MethodInsnNode min = (MethodInsnNode)this.instructions.get(this.instructions.size() - 1);
            this.pausableMethods.add(min);
        }
    }

    private void inlineSubroutines() throws KilimException {
        this.markPausableJSRs();
        block0: while (true) {
            ArrayList<BasicBlock> newBBs = null;
            for (BasicBlock bb : this.basicBlocks) {
                if (bb.hasFlag(128)) continue;
                bb.setFlag(128);
                if (bb.lastInstruction() != 168 || (newBBs = bb.inline()) == null) continue;
                break;
            }
            if (newBBs == null) break;
            int id = this.basicBlocks.size();
            Iterator i$ = newBBs.iterator();
            while (true) {
                if (!i$.hasNext()) continue block0;
                BasicBlock bb = (BasicBlock)i$.next();
                bb.setId(id++);
                this.basicBlocks.add(bb);
            }
            break;
        }
        for (BasicBlock bb : this.basicBlocks) {
            bb.changeJSR_RET_toGOTOs();
        }
    }

    private void markPausableJSRs() throws KilimException {
        for (BasicBlock bb : this.basicBlocks) {
            bb.checkPausableJSR();
        }
    }

    boolean isPausableMethodInsn(MethodInsnNode min) {
        return this.pausableMethods.contains(min);
    }

    public String toString() {
        BBList ret = this.getBasicBlocks();
        Collections.sort(ret);
        return ret.toString();
    }

    public BBList getBasicBlocks() {
        return this.basicBlocks;
    }

    private void assignCatchHandlers() {
        ArrayList tcbs = (ArrayList)this.tryCatchBlocks;
        if (tcbs.size() == 0) {
            return;
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>(tcbs.size());
        for (int i = 0; i < tcbs.size(); ++i) {
            TryCatchBlockNode tcb = (TryCatchBlockNode)tcbs.get(i);
            handlers.add(new Handler(this.getLabelPosition(tcb.start), this.getLabelPosition(tcb.end) - 1, tcb.type, this.getOrCreateBasicBlock(tcb.handler.getLabel())));
        }
        for (BasicBlock bb : this.basicBlocks) {
            bb.chooseCatchHandlers(handlers);
        }
    }

    void buildBasicBlocks() {
        int numInstructions = this.instructions.size();
        this.basicBlocks = new BBList();
        for (int i = 0; i < numInstructions; ++i) {
            Label l = this.getOrCreateLabelAtPos(i);
            BasicBlock bb = this.getOrCreateBasicBlock(l);
            i = bb.initialize(i);
            this.basicBlocks.add(bb);
        }
    }

    private void doLiveVarAnalysis() {
        boolean changed;
        BBList bbs = this.getBasicBlocks();
        Collections.sort(bbs);
        do {
            changed = false;
            for (int i = bbs.size() - 1; i >= 0; --i) {
                changed = ((BasicBlock)bbs.get(i)).flowVarUsage() || changed;
            }
        } while (changed);
    }

    private void consolidateBasicBlocks() {
        BBList newBBs = new BBList(this.basicBlocks.size());
        int pos = 0;
        for (BasicBlock bb : this.basicBlocks) {
            if (bb.hasFlag(4)) continue;
            bb.coalesceTrivialFollowers();
            bb.setId(pos++);
            newBBs.add(bb);
        }
        this.basicBlocks = newBBs;
        assert (this.checkNoBasicBlockLeftBehind());
    }

    private boolean checkNoBasicBlockLeftBehind() {
        BBList bbs = this.basicBlocks;
        HashSet<BasicBlock> hs = new HashSet<BasicBlock>(bbs.size() * 2);
        hs.addAll(bbs);
        int prevBBend = -1;
        for (BasicBlock bb : bbs) {
            assert (bb.isInitialized()) : "BB not inited: " + bb;
            assert (bb.startPos == prevBBend + 1);
            for (BasicBlock succ : bb.successors) {
                assert (succ.isInitialized()) : "Basic block not inited. Succ of " + bb;
                assert (hs.contains(succ)) : "BB not found:\n" + succ;
            }
            prevBBend = bb.endPos;
        }
        assert (((BasicBlock)bbs.get((int)(bbs.size() - 1))).endPos == this.instructions.size() - 1);
        return true;
    }

    private void dataFlow() {
        this.workset = new PriorityQueue<BasicBlock>(this.instructions.size(), new BBComparator());
        BasicBlock startBB = (BasicBlock)this.getBasicBlocks().get(0);
        assert (startBB != null) : "Null starting block in flowTypes()";
        startBB.startFrame = new Frame(this.classFlow.getClassDescriptor(), this);
        this.enqueue(startBB);
        while (!this.workset.isEmpty()) {
            BasicBlock bb = this.dequeue();
            bb.interpret();
        }
    }

    void setLabel(int pos, Label l) {
        for (int i = pos - this.posToLabelMap.size() + 1; i >= 0; --i) {
            this.posToLabelMap.add(null);
        }
        assert (this.posToLabelMap.get(pos) == null);
        this.posToLabelMap.set(pos, l);
        this.labelToPosMap.put(l, pos);
    }

    Label getOrCreateLabelAtPos(int pos) {
        Label ret = null;
        if (pos < this.posToLabelMap.size()) {
            ret = this.posToLabelMap.get(pos);
        }
        if (ret == null) {
            ret = new Label();
            this.setLabel(pos, ret);
        }
        return ret;
    }

    @Override
    public LabelNode getLabelNode(Label l) {
        return super.getLabelNode(l);
    }

    int getLabelPosition(LabelNode l) {
        return this.labelToPosMap.get(l.getLabel());
    }

    BasicBlock getOrCreateBasicBlock(Label l) {
        BasicBlock ret = this.labelToBBMap.get(l);
        if (ret == null) {
            ret = new BasicBlock(this, l);
            BasicBlock oldVal = this.labelToBBMap.put(l, ret);
            assert (oldVal == null) : "Duplicate BB created at label";
        }
        return ret;
    }

    BasicBlock getBasicBlock(Label l) {
        return this.labelToBBMap.get(l);
    }

    private BasicBlock dequeue() {
        BasicBlock bb = this.workset.poll();
        bb.unsetFlag(1);
        return bb;
    }

    void enqueue(BasicBlock bb) {
        assert (bb.startFrame != null) : "Enqueued null start frame";
        if (!bb.hasFlag(1)) {
            this.workset.add(bb);
            bb.setFlag(1);
        }
    }

    public Label getLabelAt(int pos) {
        return pos < this.posToLabelMap.size() ? this.posToLabelMap.get(pos) : null;
    }

    void addInlinedBlock(BasicBlock bb) {
        bb.setId(this.basicBlocks.size());
        this.basicBlocks.add(bb);
    }

    @Override
    public void accept(MethodVisitor mv) {
        AnnotationNode an;
        int j;
        Object l;
        AnnotationNode an2;
        int i;
        if (this.annotationDefault != null) {
            AnnotationVisitor av = mv.visitAnnotationDefault();
            MethodFlow.acceptAnnotation(av, null, this.annotationDefault);
            av.visitEnd();
        }
        int n = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an2 = (AnnotationNode)this.visibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, true));
        }
        n = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an2 = (AnnotationNode)this.invisibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, false));
        }
        n = this.visibleParameterAnnotations == null ? 0 : this.visibleParameterAnnotations.length;
        for (i = 0; i < n; ++i) {
            l = this.visibleParameterAnnotations[i];
            if (l == null) continue;
            for (j = 0; j < l.size(); ++j) {
                an = (AnnotationNode)l.get(j);
                an.accept(mv.visitParameterAnnotation(i, an.desc, true));
            }
        }
        n = this.invisibleParameterAnnotations == null ? 0 : this.invisibleParameterAnnotations.length;
        for (i = 0; i < n; ++i) {
            l = this.invisibleParameterAnnotations[i];
            if (l == null) continue;
            for (j = 0; j < l.size(); ++j) {
                an = (AnnotationNode)l.get(j);
                an.accept(mv.visitParameterAnnotation(i, an.desc, false));
            }
        }
        n = this.attrs == null ? 0 : this.attrs.size();
        for (i = 0; i < n; ++i) {
            mv.visitAttribute((Attribute)this.attrs.get(i));
        }
        if (this.instructions.size() > 0) {
            mv.visitCode();
            for (i = 0; i < this.tryCatchBlocks.size(); ++i) {
                ((TryCatchBlockNode)this.tryCatchBlocks.get(i)).accept(mv);
            }
            for (i = 0; i < this.instructions.size(); ++i) {
                l = this.getLabelAt(i);
                if (l != null) {
                    mv.visitLabel((Label)l);
                }
                this.instructions.get(i).accept(mv);
            }
            l = this.getLabelAt(this.instructions.size());
            if (l != null) {
                mv.visitLabel((Label)l);
            }
            n = this.localVariables == null ? 0 : this.localVariables.size();
            for (i = 0; i < n; ++i) {
                ((LocalVariableNode)this.localVariables.get(i)).accept(mv);
            }
            mv.visitMaxs(this.maxStack, this.maxLocals);
        }
        mv.visitEnd();
    }

    public int getNumArgs() {
        int ret = TypeDesc.getNumArgumentTypes(this.desc);
        if (!this.isStatic()) {
            ++ret;
        }
        return ret;
    }

    public boolean isPausable() {
        return this.hasPausableAnnotation;
    }

    public void setPausable(boolean isPausable) {
        this.hasPausableAnnotation = isPausable;
    }

    public static void acceptAnnotation(AnnotationVisitor av, String name, Object value) {
        if (value instanceof String[]) {
            String[] typeconst = (String[])value;
            av.visitEnum(name, typeconst[0], typeconst[1]);
        } else if (value instanceof AnnotationNode) {
            AnnotationNode an = (AnnotationNode)value;
            an.accept(av.visitAnnotation(name, an.desc));
        } else if (value instanceof List) {
            AnnotationVisitor v = av.visitArray(name);
            List array = (List)value;
            for (int j = 0; j < array.size(); ++j) {
                MethodFlow.acceptAnnotation(v, null, array.get(j));
            }
            v.visitEnd();
        } else {
            av.visit(name, value);
        }
    }

    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    public boolean isBridge() {
        return (this.access & 0x40) != 0;
    }

    public Detector detector() {
        return this.classFlow.detector();
    }
}

