/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.util.ArrayList;
import java.util.List;
import kilim.analysis.BBList;
import kilim.analysis.BasicBlock;
import kilim.analysis.CallWeaver;
import kilim.analysis.ClassWeaver;
import kilim.analysis.Handler;
import kilim.analysis.MethodFlow;
import kilim.analysis.TypeDesc;
import kilim.analysis.VMType;
import kilim.analysis.ValInfoList;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.LocalVariableNode;

public class MethodWeaver {
    private ClassWeaver classWeaver;
    private MethodFlow methodFlow;
    private boolean isPausable;
    private int maxVars;
    private int maxStack;
    private int fiberVar;
    private int numWordsInSig;
    private ArrayList<CallWeaver> callWeavers = new ArrayList(5);

    MethodWeaver(ClassWeaver cw, MethodFlow mf) {
        this.classWeaver = cw;
        this.methodFlow = mf;
        this.isPausable = mf.isPausable();
        this.fiberVar = this.methodFlow.maxLocals;
        this.maxVars = this.fiberVar + 1;
        this.maxStack = this.methodFlow.maxStack + 1;
        if (!mf.isAbstract()) {
            this.createCallWeavers();
        }
    }

    public void accept(ClassVisitor cv) {
        MethodFlow mf = this.methodFlow;
        String[] exceptions = ClassWeaver.toStringArray(mf.exceptions);
        String desc = mf.desc;
        String sig = mf.signature;
        if (mf.isPausable()) {
            desc = desc.replace(")", "Lkilim/Fiber;)");
            if (sig != null) {
                sig = sig.replace(")", "Lkilim/Fiber;)");
            }
        }
        MethodVisitor mv = cv.visitMethod(mf.access, mf.name, desc, sig, exceptions);
        if (!mf.isAbstract()) {
            if (mf.isPausable()) {
                this.accept(mv);
            } else {
                mf.accept(mv);
            }
        }
    }

    void accept(MethodVisitor mv) {
        this.visitAttrs(mv);
        this.visitCode(mv);
        mv.visitEnd();
    }

    private void visitAttrs(MethodVisitor mv) {
        AnnotationNode an;
        int j;
        List l;
        AnnotationNode an2;
        int i;
        MethodFlow mf = this.methodFlow;
        if (mf.annotationDefault != null) {
            AnnotationVisitor av = mv.visitAnnotationDefault();
            MethodFlow.acceptAnnotation(av, null, mf.annotationDefault);
            av.visitEnd();
        }
        int n = mf.visibleAnnotations == null ? 0 : mf.visibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an2 = (AnnotationNode)mf.visibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, true));
        }
        n = mf.invisibleAnnotations == null ? 0 : mf.invisibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an2 = (AnnotationNode)mf.invisibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, false));
        }
        n = mf.visibleParameterAnnotations == null ? 0 : mf.visibleParameterAnnotations.length;
        for (i = 0; i < n; ++i) {
            l = mf.visibleParameterAnnotations[i];
            if (l == null) continue;
            for (j = 0; j < l.size(); ++j) {
                an = (AnnotationNode)l.get(j);
                an.accept(mv.visitParameterAnnotation(i, an.desc, true));
            }
        }
        n = mf.invisibleParameterAnnotations == null ? 0 : mf.invisibleParameterAnnotations.length;
        for (i = 0; i < n; ++i) {
            l = mf.invisibleParameterAnnotations[i];
            if (l == null) continue;
            for (j = 0; j < l.size(); ++j) {
                an = (AnnotationNode)l.get(j);
                an.accept(mv.visitParameterAnnotation(i, an.desc, false));
            }
        }
        n = mf.attrs == null ? 0 : mf.attrs.size();
        for (i = 0; i < n; ++i) {
            mv.visitAttribute((Attribute)mf.attrs.get(i));
        }
    }

    private void visitCode(MethodVisitor mv) {
        mv.visitCode();
        this.visitTryCatchBlocks(mv);
        this.visitInstructions(mv);
        this.visitLocals(mv);
        mv.visitMaxs(this.maxStack, this.maxVars);
    }

    private void visitLocals(MethodVisitor mv) {
        for (Object l : this.methodFlow.localVariables) {
            ((LocalVariableNode)l).accept(mv);
        }
    }

    private void visitInstructions(MethodVisitor mv) {
        Label l;
        this.genPrelude(mv);
        MethodFlow mf = this.methodFlow;
        BasicBlock lastBB = null;
        for (BasicBlock bb : mf.getBasicBlocks()) {
            List<CallWeaver> cwList;
            int from = bb.startPos;
            if (bb.isPausable() && bb.startFrame != null) {
                this.genPausableMethod(mv, bb);
                from = bb.startPos + 1;
            } else if (bb.isCatchHandler() && (cwList = this.getCallsUnderCatchBlock(bb)) != null) {
                this.genException(mv, bb, cwList);
                from = bb.startPos + 1;
            }
            int to = bb.endPos;
            for (int i = from; i <= to; ++i) {
                Label l2 = mf.getLabelAt(i);
                if (l2 != null) {
                    mv.visitLabel(l2);
                }
                bb.getInstruction(i).accept(mv);
            }
            lastBB = bb;
        }
        if (lastBB != null && (l = this.methodFlow.getLabelAt(lastBB.endPos + 1)) != null) {
            mv.visitLabel(l);
        }
    }

    private List<CallWeaver> getCallsUnderCatchBlock(BasicBlock catchBB) {
        ArrayList<CallWeaver> cwList = null;
        for (CallWeaver cw : this.callWeavers) {
            for (Handler h : cw.bb.handlers) {
                if (h.catchBB != catchBB) continue;
                if (cwList == null) {
                    cwList = new ArrayList<CallWeaver>(this.callWeavers.size());
                }
                if (cwList.contains(cw)) continue;
                cwList.add(cw);
            }
        }
        return cwList;
    }

    private void genPausableMethod(MethodVisitor mv, BasicBlock bb) {
        CallWeaver caw = null;
        if (bb.isGetCurrentTask()) {
            this.genGetCurrentTask(mv, bb);
            return;
        }
        for (CallWeaver cw : this.callWeavers) {
            if (cw.getBasicBlock() != bb) continue;
            caw = cw;
            break;
        }
        caw.genCall(mv);
        caw.genPostCall(mv);
    }

    void genGetCurrentTask(MethodVisitor mv, BasicBlock bb) {
        mv.visitLabel(bb.startLabel);
        VMType.loadVar(mv, 0, this.getFiberVar());
        mv.visitFieldInsn(180, "kilim/Fiber", "task", "Lkilim/Task;");
    }

    private void createCallWeavers() {
        MethodFlow mf = this.methodFlow;
        for (BasicBlock bb : mf.getBasicBlocks()) {
            if (!bb.isPausable() || bb.startFrame == null || bb.isGetCurrentTask()) continue;
            CallWeaver cw = new CallWeaver(this, bb);
            this.callWeavers.add(cw);
        }
    }

    private void genPrelude(MethodVisitor mv) {
        assert (this.isPausable) : "MethodWeaver.genPrelude called for nonPausable method";
        MethodFlow mf = this.methodFlow;
        int lastVar = this.getFiberArgVar();
        mv.visitVarInsn(25, lastVar);
        if (lastVar < this.fiberVar) {
            if (this.callWeavers.size() > 0) {
                mv.visitInsn(89);
            }
            mv.visitVarInsn(58, this.getFiberVar());
        }
        if (this.callWeavers.size() == 0) {
            return;
        }
        mv.visitFieldInsn(180, "kilim/Fiber", "pc", "I");
        this.ensureMaxStack(2);
        Label startLabel = mf.getOrCreateLabelAtPos(0);
        Label errLabel = new Label();
        Label[] labels = new Label[this.callWeavers.size() + 1];
        labels[0] = startLabel;
        for (int i = 0; i < this.callWeavers.size(); ++i) {
            labels[i + 1] = new Label();
        }
        mv.visitTableSwitchInsn(0, this.callWeavers.size(), errLabel, labels);
        mv.visitLabel(errLabel);
        VMType.loadVar(mv, 0, this.getFiberVar());
        mv.visitMethodInsn(182, "kilim/Fiber", "wrongPC", "()V");
        int last = this.callWeavers.size() - 1;
        for (int i = 0; i <= last; ++i) {
            CallWeaver cw = this.callWeavers.get(i);
            mv.visitLabel(labels[i + 1]);
            cw.genRewind(mv);
        }
        mv.visitLabel(startLabel);
    }

    boolean isStatic() {
        return this.methodFlow.isStatic();
    }

    int getFiberArgVar() {
        int lastVar = this.getNumWordsInSig();
        if (!this.isStatic()) {
            ++lastVar;
        }
        return lastVar;
    }

    int getNumWordsInSig() {
        if (this.numWordsInSig != -1) {
            String[] args = TypeDesc.getArgumentTypes(this.methodFlow.desc);
            int size = 0;
            for (int i = 0; i < args.length; ++i) {
                size += TypeDesc.isDoubleWord(args[i]) ? 2 : 1;
            }
            this.numWordsInSig = size;
        }
        return this.numWordsInSig;
    }

    private void genException(MethodVisitor mv, BasicBlock bb, List<CallWeaver> cwList) {
        int i;
        mv.visitLabel(bb.startLabel);
        Label resumeLabel = new Label();
        VMType.loadVar(mv, 0, this.getFiberVar());
        mv.visitMethodInsn(182, "kilim/Fiber", "upEx", "()I");
        Label[] labels = new Label[cwList.size()];
        int[] keys = new int[cwList.size()];
        for (i = 0; i < cwList.size(); ++i) {
            labels[i] = new Label();
            keys[i] = this.callWeavers.indexOf(cwList.get(i)) + 1;
        }
        mv.visitLookupSwitchInsn(resumeLabel, keys, labels);
        i = 0;
        for (CallWeaver cw : cwList) {
            if (i > 0) {
                mv.visitJumpInsn(167, resumeLabel);
            }
            mv.visitLabel(labels[i]);
            cw.genRestoreEx(mv, labels[i]);
            ++i;
        }
        mv.visitLabel(resumeLabel);
        bb.getInstruction(bb.startPos).accept(mv);
    }

    int getFiberVar() {
        return this.fiberVar;
    }

    void visitTryCatchBlocks(MethodVisitor mv) {
        MethodFlow mf = this.methodFlow;
        BBList bbs = mf.getBasicBlocks();
        ArrayList<Handler> allHandlers = new ArrayList<Handler>(bbs.size() * 2);
        for (BasicBlock bb : bbs) {
            allHandlers.addAll(bb.handlers);
        }
        allHandlers = Handler.consolidate(allHandlers);
        for (Handler h : allHandlers) {
            mv.visitTryCatchBlock(mf.getLabelAt(h.from), mf.getOrCreateLabelAtPos(h.to + 1), h.catchBB.startLabel, h.type);
        }
    }

    void ensureMaxVars(int numVars) {
        if (numVars > this.maxVars) {
            this.maxVars = numVars;
        }
    }

    void ensureMaxStack(int numStack) {
        if (numStack > this.maxStack) {
            this.maxStack = numStack;
        }
    }

    int getPC(CallWeaver weaver) {
        for (int i = 0; i < this.callWeavers.size(); ++i) {
            if (this.callWeavers.get(i) != weaver) continue;
            return i + 1;
        }
        assert (false) : " No weaver found";
        return 0;
    }

    public String createStateClass(ValInfoList valInfoList) {
        return this.classWeaver.createStateClass(valInfoList);
    }

    void makeNotWovenMethod(ClassVisitor cv, MethodFlow mf) {
        int numlocals;
        if (this.classWeaver.isInterface()) {
            return;
        }
        int access = mf.access;
        MethodVisitor mv = cv.visitMethod(access &= 0xFFFFFBFF, mf.name, mf.desc, mf.signature, ClassWeaver.toStringArray(mf.exceptions));
        mv.visitCode();
        this.visitAttrs(mv);
        mv.visitMethodInsn(184, "kilim/Task", "errNotWoven", "()V");
        String rdesc = TypeDesc.getReturnTypeDesc(mf.desc);
        int stacksize = 0;
        if (rdesc != "V") {
            stacksize = TypeDesc.isDoubleWord(rdesc) ? 2 : 1;
            int vmt = VMType.toVmType(rdesc);
            mv.visitInsn(VMType.constInsn[vmt]);
            mv.visitInsn(VMType.retInsn[vmt]);
        } else {
            mv.visitInsn(177);
        }
        if ((mf.access & 0x400) != 0) {
            numlocals = this.getNumWordsInSig() + 1;
            if (!mf.isStatic()) {
                ++numlocals;
            }
        } else {
            numlocals = mf.maxLocals + 1;
        }
        mv.visitMaxs(stacksize, numlocals);
        mv.visitEnd();
    }
}

