/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.lang.reflect.Field;
import java.util.HashMap;
import kilim.Constants;
import kilim.analysis.IncompatibleTypesException;
import kilim.mirrors.ClassMirrorNotFoundException;
import kilim.mirrors.Detector;
import org.objectweb.asm.Type;

public class TypeDesc {
    static final HashMap<String, String> knownTypes = new HashMap(30);
    static String JAVA_LANG_OBJECT;

    static boolean isDoubleWord(String desc) {
        return desc == "D" || desc == "J";
    }

    public static String getInterned(String desc) {
        String ret = knownTypes.get(desc);
        if (ret == null) {
            switch (desc.charAt(0)) {
                case 'L': 
                case '[': {
                    return desc;
                }
            }
            return "L" + desc + ';';
        }
        return ret;
    }

    public static String getReturnTypeDesc(String desc) {
        return TypeDesc.getInterned(desc.substring(desc.indexOf(")") + 1));
    }

    static boolean isSingleWord(String desc) {
        return !TypeDesc.isDoubleWord(desc);
    }

    public static String getComponentType(String t) {
        if (t.charAt(0) != '[') {
            throw new InternalError("Can't get component type of " + t);
        }
        return TypeDesc.getInterned(t.substring(1));
    }

    public static String getTypeDesc(Object object) {
        if (object instanceof Integer) {
            return "I";
        }
        if (object instanceof Long) {
            return "J";
        }
        if (object instanceof Float) {
            return "F";
        }
        if (object instanceof Double) {
            return "D";
        }
        if (object instanceof String) {
            return "Ljava/lang/String;";
        }
        if (object instanceof Boolean) {
            return "Z";
        }
        if (object instanceof Type) {
            return TypeDesc.getInterned(((Type)object).getDescriptor());
        }
        throw new InternalError("Unrecognized ldc constant: " + object);
    }

    private static int typelen(char[] buf, int off) {
        int start = off;
        switch (buf[off]) {
            case 'L': {
                while (buf[off++] != ';') {
                }
                return off - start;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return 1;
            }
            case '[': {
                return TypeDesc.typelen(buf, off + 1) + 1;
            }
        }
        throw new InternalError("Unknown descriptor type");
    }

    public static String[] getArgumentTypes(String methodDescriptor) {
        char[] buf = methodDescriptor.toCharArray();
        int size = TypeDesc.getNumArgumentTypes(buf);
        String[] args = new String[size];
        size = 0;
        int off = 1;
        while (buf[off] != ')') {
            int len = TypeDesc.typelen(buf, off);
            args[size] = TypeDesc.getInterned(new String(buf, off, len));
            off += len;
            ++size;
        }
        return args;
    }

    public static int getNumArgumentTypes(String desc) {
        return TypeDesc.getNumArgumentTypes(desc.toCharArray());
    }

    public static int getNumArgumentTypes(char[] buf) {
        int off = 1;
        int size = 0;
        while (buf[off] != ')') {
            off += TypeDesc.typelen(buf, off);
            ++size;
        }
        return size;
    }

    public static String mergeType(String a, String b) throws IncompatibleTypesException {
        if (a == "UNDEFINED") {
            return b;
        }
        if (b == "UNDEFINED") {
            return a;
        }
        char ac = a.charAt(0);
        char bc = b.charAt(0);
        if (a == "NULL") {
            assert (b == "NULL" || bc == 'L' || bc == '[') : "merging NULL type with non ref type: " + b;
            return b;
        }
        if (b == "NULL") {
            assert (b == "NULL" || bc == 'L' || bc == '[') : "merging NULL type with non ref type: " + a;
            return a;
        }
        if (a == b || a.equals(b)) {
            return a;
        }
        switch (ac) {
            case 'N': {
                if (bc != 'L') break;
                return b;
            }
            case 'L': {
                if (bc == 'L') {
                    return TypeDesc.commonSuperType(a, b);
                }
                if (bc == 'N') {
                    return a;
                }
                if (bc != '[') break;
                return "Ljava/lang/Object;";
            }
            case '[': {
                if (bc == '[') {
                    try {
                        return "[" + TypeDesc.mergeType(TypeDesc.getComponentType(a), TypeDesc.getComponentType(b));
                    }
                    catch (IncompatibleTypesException ite) {
                        return "Ljava/lang/Object;";
                    }
                }
                if (bc != 'L') break;
                return "Ljava/lang/Object;";
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                switch (bc) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        return "I";
                    }
                }
            }
        }
        throw new IncompatibleTypesException("" + a + "," + b);
    }

    public static String commonSuperType(String oa, String ob) {
        try {
            if (oa == "Ljava/lang/Object;" || ob == "Ljava/lang/Object;") {
                return "Ljava/lang/Object;";
            }
            if (oa.equals(ob)) {
                return oa;
            }
            String lub = Detector.getDetector().commonSuperType(oa, ob);
            return lub;
        }
        catch (ClassMirrorNotFoundException cnfe) {
            throw new InternalError(cnfe.getMessage());
        }
    }

    public static boolean isIntType(String typeDesc) {
        return typeDesc == "I" || typeDesc == "C" || typeDesc == "S" || typeDesc == "B" || typeDesc == "Z";
    }

    public static boolean isRefType(String typeDesc) {
        char c = typeDesc.charAt(0);
        return typeDesc == "NULL" || c == '[' || c == 'L';
    }

    public static String getInternalName(String desc) {
        if (desc.charAt(0) == 'L') {
            return desc.substring(1, desc.length() - 1);
        }
        assert (desc.charAt(0) == '[') : "Unexpected internal name " + desc;
        return desc;
    }

    static {
        Field[] fields = Constants.class.getFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                if (!f.getName().startsWith("D_")) continue;
                String val = (String)f.get(null);
                knownTypes.put(val, val);
            }
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        knownTypes.put("java/lang/Object", "Ljava/lang/Object;");
        knownTypes.put("java/lang/String", "Ljava/lang/String;");
        JAVA_LANG_OBJECT = "java.lang.Object";
    }
}

