/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.util.ArrayList;
import java.util.BitSet;

public class Usage {
    private int nLocals;
    private BitSet in;
    private BitSet use;
    private BitSet def;

    public Usage(int numLocals) {
        this.nLocals = numLocals;
        this.in = new BitSet(numLocals);
        this.use = new BitSet(numLocals);
        this.def = new BitSet(numLocals);
    }

    public void read(int var) {
        assert (var < this.nLocals) : "local var num=" + var + " exceeds nLocals = " + this.nLocals;
        if (!this.def.get(var)) {
            this.use.set(var);
        }
    }

    public void write(int var) {
        assert (var < this.nLocals) : "local var num=" + var + " exceeds nLocals = " + this.nLocals;
        this.def.set(var);
    }

    public boolean isLiveIn(int var) {
        return this.in.get(var);
    }

    public boolean evalLiveIn(ArrayList<Usage> succUsage) {
        BitSet out = new BitSet(this.nLocals);
        BitSet old_in = (BitSet)this.in.clone();
        if (succUsage.size() == 0) {
            this.in = this.use;
        } else {
            out = (BitSet)succUsage.get((int)0).in.clone();
            for (int i = 1; i < succUsage.size(); ++i) {
                out.or(succUsage.get((int)i).in);
            }
            BitSet def1 = (BitSet)this.def.clone();
            def1.flip(0, this.nLocals);
            out.and(def1);
            out.or(this.use);
            this.in = out;
        }
        return !this.in.equals(old_in);
    }

    void absorb(Usage succ) {
        BitSet b = (BitSet)this.def.clone();
        b.flip(0, this.nLocals);
        b.and(succ.use);
        this.use.or(b);
        this.def.or(succ.def);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("use");
        this.printBits(sb, this.use);
        sb.append("def");
        this.printBits(sb, this.def);
        sb.append("in");
        this.printBits(sb, this.in);
        return sb.toString();
    }

    private void printBits(StringBuffer sb, BitSet b) {
        int i;
        int numDefined = 0;
        for (i = 0; i < this.nLocals; ++i) {
            if (!b.get(i)) continue;
            ++numDefined;
        }
        sb.append('(').append(numDefined).append("): ");
        for (i = 0; i < this.nLocals; ++i) {
            if (!b.get(i)) continue;
            sb.append(i).append(' ');
        }
        sb.append('\n');
    }

    public void setLiveIn(int var) {
        this.in.set(var);
    }

    Usage copy() {
        Usage ret = new Usage(this.nLocals);
        ret.use = this.use;
        ret.def = this.def;
        return ret;
    }
}

