/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import org.objectweb.asm.MethodVisitor;

class VMType {
    static final int TOBJECT = 0;
    static final int TINT = 1;
    static final int TLONG = 2;
    static final int TDOUBLE = 3;
    static final int TFLOAT = 4;
    static final int[] constInsn = new int[]{1, 3, 9, 14, 11};
    static final int[] loadInsn = new int[]{25, 21, 22, 24, 23};
    static final int[] retInsn = new int[]{176, 172, 173, 175, 174};
    static final int[] ldInsn = new int[]{42, 26, 30, 38, 34};
    static final int[] stInsn = new int[]{75, 59, 63, 71, 67};
    static final int[] storeInsn = new int[]{58, 54, 55, 57, 56};
    static final String[] fieldDesc = new String[]{"Ljava/lang/Object;", "I", "J", "D", "F"};
    static final String[] abbrev = new String[]{"O", "I", "L", "D", "F"};
    static final int[] category = new int[]{1, 1, 2, 2, 1};

    VMType() {
    }

    static int toVmType(String type) {
        switch (type.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 1;
            }
            case 'D': {
                return 3;
            }
            case 'F': {
                return 4;
            }
            case 'J': {
                return 2;
            }
            case 'A': 
            case 'L': 
            case 'N': 
            case '[': {
                return 0;
            }
        }
        assert (false) : "Type " + type + " not handled";
        return 32;
    }

    static void loadVar(MethodVisitor mv, int vmt, int var) {
        assert (var >= 0) : "Got var = " + var;
        if (var < 4) {
            mv.visitInsn(ldInsn[vmt] + var);
        } else {
            mv.visitVarInsn(loadInsn[vmt], var);
        }
    }

    static void storeVar(MethodVisitor mv, int vmt, int var) {
        assert (var >= 0);
        if (var < 4) {
            mv.visitInsn(stInsn[vmt] + var);
        } else {
            mv.visitVarInsn(storeInsn[vmt], var);
        }
    }
}

