/*
 * Decompiled with CFR 0.152.
 */
package kilim.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import kilim.Fiber;
import kilim.Pausable;
import kilim.S_O;
import kilim.State;
import kilim.Task;
import kilim.http.HttpMsg;
import kilim.nio.EndPoint;
import kilim.nio.ExposedBaos;

public class HttpResponse
extends HttpMsg {
    public static final byte[] ST_CONTINUE = "100 Continue\r\n".getBytes();
    public static final byte[] ST_SWITCHING_PROTOCOLS = "101 Switching Protocols\r\n".getBytes();
    public static final byte[] ST_OK = "200 OK\r\n".getBytes();
    public static final byte[] ST_CREATED = "201 Created\r\n".getBytes();
    public static final byte[] ST_ACCEPTED = "202 Accepted\r\n".getBytes();
    public static final byte[] ST_NON_AUTHORITATIVE = "203 Non-Authoritative Information\r\n".getBytes();
    public static final byte[] ST_NO_CONTENT = "204 No Content\r\n".getBytes();
    public static final byte[] ST_RESET_CONTENT = "205 Reset Content\r\n".getBytes();
    public static final byte[] ST_PARTIAL_CONTENT = "206 Partial Content\r\n".getBytes();
    public static final byte[] ST_MULTIPLE_CHOICES = "300 Multiple Choices\r\n".getBytes();
    public static final byte[] ST_MOVED_PERMANENTLY = "301 Moved Permanently\r\n".getBytes();
    public static final byte[] ST_FOUND = "302 Found\r\n".getBytes();
    public static final byte[] ST_SEE_OTHER = "303 See Other\r\n".getBytes();
    public static final byte[] ST_NOT_MODIFIED = "304 Not Modified\r\n".getBytes();
    public static final byte[] ST_USE_PROXY = "305 Use Proxy\r\n".getBytes();
    public static final byte[] ST_TEMPORARY_REDIRECT = "307 Temporary Redirect\r\n".getBytes();
    public static final byte[] ST_BAD_REQUEST = "400 Bad Request\r\n".getBytes();
    public static final byte[] ST_UNAUTHORIZED = "401 Unauthorized\r\n".getBytes();
    public static final byte[] ST_PAYMENT_REQUIRED = "402 Payment Required\r\n".getBytes();
    public static final byte[] ST_FORBIDDEN = "403 Forbidden\r\n".getBytes();
    public static final byte[] ST_NOT_FOUND = "404 Not Found\r\n".getBytes();
    public static final byte[] ST_METHOD_NOT_ALLOWED = "405 Method Not Allowed\r\n".getBytes();
    public static final byte[] ST_NOT_ACCEPTABLE = "406 Not Acceptable\r\n".getBytes();
    public static final byte[] ST_PROXY_AUTHENTICATION_REQUIRED = "407 Proxy Authentication Required\r\n".getBytes();
    public static final byte[] ST_REQUEST_TIMEOUT = "408 Request Time-out\r\n".getBytes();
    public static final byte[] ST_CONFLICT = "409 Conflict\r\n".getBytes();
    public static final byte[] ST_GONE = "410 Gone\r\n".getBytes();
    public static final byte[] ST_LENGTH_REQUIRED = "411 Length Required\r\n".getBytes();
    public static final byte[] ST_PRECONDITION_FAILED = "412 Precondition Failed\r\n".getBytes();
    public static final byte[] ST_REQUEST_ENTITY_TOO_LARGE = "413 Request Entity Too Large\r\n".getBytes();
    public static final byte[] ST_REQUEST_URI_TOO_LONG = "414 Request-URI Too Large\r\n".getBytes();
    public static final byte[] ST_UNSUPPORTED_MEDIA_TYPE = "415 Unsupported Media Type\r\n".getBytes();
    public static final byte[] ST_REQUEST_RANGE_NOT_SATISFIABLE = "416 Requested range not satisfiable\r\n".getBytes();
    public static final byte[] ST_EXPECTATION_FAILED = "417 Expectation Failed\r\n".getBytes();
    public static final byte[] ST_INTERNAL_SERVER_ERROR = "500 Internal Server Error\r\n".getBytes();
    public static final byte[] ST_NOT_IMPLEMENTED = "501 Not Implemented\r\n".getBytes();
    public static final byte[] ST_BAD_GATEWAY = "502 Bad Gateway\r\n".getBytes();
    public static final byte[] ST_SERVICE_UNAVAILABLE = "503 Service Unavailable\r\n".getBytes();
    public static final byte[] ST_GATEWAY_TIMEOUT = "504 Gateway Time-out\r\n".getBytes();
    public static final byte[] ST_HTTP_VERSION_NOT_SUPPORTED = "505 HTTP Version not supported\r\n".getBytes();
    public static final byte[] PROTOCOL = "HTTP/1.1 ".getBytes();
    public static final byte[] F_SERVER = "Server: kilim 0.7.3\r\n".getBytes();
    public static final byte[] F_DATE = "Date: ".getBytes();
    public static final byte[] CRLF = "\r\n".getBytes();
    public static final byte[] FIELD_SEP = ": ".getBytes();
    public static ConcurrentHashMap<String, byte[]> byteCache = new ConcurrentHashMap();
    public byte[] status;
    public ArrayList<String> keys = new ArrayList();
    public ArrayList<String> values = new ArrayList();
    public ExposedBaos bodyStream;
    public static final SimpleDateFormat gmtdf = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss");
    public static final boolean $isWoven = true;

    public HttpResponse() {
        this(ST_OK);
    }

    public HttpResponse(byte[] statusb) {
        this.status = statusb;
    }

    public void reuse() {
        this.status = ST_OK;
        this.keys.clear();
        this.values.clear();
        if (this.bodyStream != null) {
            this.bodyStream.reset();
        }
        if (this.buffer != null) {
            this.buffer.clear();
        }
    }

    public void setStatus(String statusMsg) {
        if (!statusMsg.endsWith("\r\n")) {
            statusMsg = statusMsg + "\r\n";
        }
        this.status = statusMsg.getBytes();
    }

    public HttpResponse(String statusMsg) {
        this();
        this.setStatus(statusMsg);
    }

    public HttpResponse addField(String key, String value) {
        this.keys.add(key);
        this.values.add(value);
        return this;
    }

    public void writeHeader(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.write(PROTOCOL);
        dos.write(this.status);
        dos.write(F_DATE);
        byte[] date = gmtdf.format(new Date()).getBytes();
        dos.write(date);
        dos.write(CRLF);
        dos.write(F_SERVER);
        if (this.bodyStream != null) {
            this.setContentLength(this.bodyStream.size());
        }
        int nfields = this.keys.size();
        for (int i = 0; i < nfields; ++i) {
            String key = this.keys.get(i);
            byte[] keyb = byteCache.get(key);
            if (keyb == null) {
                keyb = key.getBytes();
                byteCache.put(key, keyb);
            }
            dos.write(keyb);
            dos.write(FIELD_SEP);
            dos.write(this.values.get(i).getBytes());
            dos.write(CRLF);
        }
        dos.write(CRLF);
    }

    public OutputStream getOutputStream() {
        if (this.bodyStream == null) {
            this.bodyStream = new ExposedBaos(2048);
        }
        return this.bodyStream;
    }

    public void writeTo(EndPoint endPoint, Fiber fiber) throws IOException, Pausable {
        block17: {
            State state;
            ByteBuffer byteBuffer;
            EndPoint endPoint2;
            Fiber fiber2;
            block16: {
                EndPoint endpoint;
                ByteBuffer bb;
                ByteBuffer byteBuffer2;
                EndPoint endPoint3;
                fiber2 = fiber;
                switch (fiber2.pc) {
                    default: {
                        fiber2.wrongPC();
                    }
                    case 1: {
                        fiber = null;
                        Object var3_4 = null;
                        endPoint3 = (EndPoint)fiber2.getCallee();
                        byteBuffer2 = null;
                        break;
                    }
                    case 2: {
                        fiber = null;
                        Object var3_5 = null;
                        endPoint2 = (EndPoint)fiber2.getCallee();
                        byteBuffer = null;
                        break block16;
                    }
                    case 0: {
                        ExposedBaos headerStream = new ExposedBaos();
                        this.writeHeader(headerStream);
                        bb = headerStream.toByteBuffer();
                        endPoint3 = endpoint;
                        byteBuffer2 = bb;
                    }
                }
                endPoint3.write(byteBuffer2, fiber2.down());
                switch (fiber2.up()) {
                    case 2: {
                        S_O s_O = new S_O();
                        s_O.self = this;
                        s_O.pc = 1;
                        s_O.f0 = endpoint;
                        fiber2.setState(s_O);
                        return;
                    }
                    case 3: {
                        return;
                    }
                    case 1: {
                        state = (S_O)fiber2.curState;
                        endpoint = (EndPoint)state.f0;
                    }
                }
                if (this.bodyStream == null || this.bodyStream.size() <= 0) break block17;
                bb = this.bodyStream.toByteBuffer();
                endPoint2 = endpoint;
                byteBuffer = bb;
            }
            endPoint2.write(byteBuffer, fiber2.down());
            switch (fiber2.up()) {
                case 2: {
                    state = new State();
                    state.self = this;
                    state.pc = 2;
                    fiber2.setState(state);
                    return;
                }
                case 3: {
                    return;
                }
            }
        }
    }

    public void writeTo(EndPoint endPoint) throws IOException, Pausable {
        Task.errNotWoven();
    }

    public void setContentLength(long length) {
        this.addField("Content-Length", Long.toString(length));
    }

    public void setContentType(String contentType) {
        this.addField("Content-Type", contentType);
    }

    static {
        gmtdf.setTimeZone(TimeZone.getTimeZone("GMT:00"));
    }
}

