/*
 * Decompiled with CFR 0.152.
 */
package kilim.http;

import kilim.http.Utils;

public class KeyValues {
    public String[] keys;
    public String[] values;
    public int count;

    public KeyValues() {
        this(5);
    }

    public KeyValues(int size) {
        this.keys = new String[size];
        this.values = new String[size];
    }

    public String get(String key) {
        int i = this.indexOf(key);
        return i == -1 ? "" : this.values[i];
    }

    public int indexOf(String key) {
        int len = this.count;
        for (int i = 0; i < len; ++i) {
            if (!this.keys[i].equals(key)) continue;
            return i;
        }
        return -1;
    }

    public void put(String key, String value) {
        int i = this.indexOf(key);
        if (i == -1) {
            if (this.count == this.keys.length) {
                this.keys = (String[])Utils.growArray(this.keys, this.count * 2);
                this.values = (String[])Utils.growArray(this.values, this.count * 2);
            }
            this.keys[this.count] = key;
            this.values[this.count] = value;
            ++this.count;
        } else {
            this.values[i] = value;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.count; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.keys[i]).append(':').append(this.values[i]);
        }
        sb.append(']');
        return sb.toString();
    }
}

