/*
 * Decompiled with CFR 0.152.
 */
package kilim.mirrors;

import java.util.ArrayList;
import java.util.List;
import kilim.mirrors.CachedClassMirrors;
import kilim.mirrors.CachedMethodMirror;
import kilim.mirrors.ClassMirror;
import kilim.mirrors.ClassMirrorNotFoundException;
import kilim.mirrors.Detector;
import kilim.mirrors.MethodMirror;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

class CachedClassMirror
extends ClassMirror
implements ClassVisitor {
    String name;
    boolean isInterface;
    MethodMirror[] declaredMethods;
    String[] interfaceNames;
    String superName;
    private List<CachedMethodMirror> tmpMethodList;

    public CachedClassMirror(byte[] bytecode) {
        ClassReader cr = new ClassReader(bytecode);
        cr.accept(this, 2);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CachedClassMirror) {
            CachedClassMirror mirr = (CachedClassMirror)obj;
            return mirr.name == this.name && mirr.isInterface == this.isInterface;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public MethodMirror[] getDeclaredMethods() {
        return this.declaredMethods;
    }

    @Override
    public String[] getInterfaces() throws ClassMirrorNotFoundException {
        return this.interfaceNames;
    }

    @Override
    public String getSuperclass() throws ClassMirrorNotFoundException {
        return this.superName;
    }

    @Override
    public boolean isAssignableFrom(ClassMirror c) throws ClassMirrorNotFoundException {
        Detector d = Detector.getDetector();
        if (this.equals(c)) {
            return true;
        }
        ClassMirror supcl = d.classForName(c.getSuperclass());
        if (this.isAssignableFrom(supcl)) {
            return true;
        }
        for (String icl : c.getInterfaces()) {
            supcl = d.classForName(icl);
            if (!this.isAssignableFrom(supcl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.name = name;
        this.superName = superName;
        this.interfaceNames = interfaces == null ? CachedClassMirrors.EMPTY_SET : interfaces;
        this.isInterface = (access & 0x200) > 0;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.tmpMethodList == null) {
            this.tmpMethodList = new ArrayList<CachedMethodMirror>();
        }
        this.tmpMethodList.add(new CachedMethodMirror(access, name, desc, exceptions));
        return null;
    }

    @Override
    public void visitEnd() {
        if (this.tmpMethodList != null) {
            this.declaredMethods = new MethodMirror[this.tmpMethodList.size()];
            int i = 0;
            for (CachedMethodMirror mm : this.tmpMethodList) {
                this.declaredMethods[i++] = mm;
            }
            this.tmpMethodList = null;
        }
    }

    @Override
    public void visitSource(String source, String debug) {
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return DummyAnnotationVisitor.singleton;
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    static class DummyAnnotationVisitor
    implements AnnotationVisitor {
        static DummyAnnotationVisitor singleton = new DummyAnnotationVisitor();

        DummyAnnotationVisitor() {
        }

        @Override
        public void visit(String name, Object value) {
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this;
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return singleton;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
        }
    }
}

