/*
 * Decompiled with CFR 0.152.
 */
package kilim.mirrors;

import java.util.concurrent.ConcurrentHashMap;
import kilim.mirrors.CachedClassMirror;
import kilim.mirrors.ClassMirror;
import kilim.mirrors.ClassMirrorNotFoundException;
import kilim.mirrors.Mirrors;
import kilim.mirrors.RuntimeClassMirrors;

public class CachedClassMirrors
extends Mirrors {
    static final String[] EMPTY_SET = new String[0];
    final RuntimeClassMirrors delegate;
    ConcurrentHashMap<String, ClassMirror> cachedClasses = new ConcurrentHashMap();

    public CachedClassMirrors(ClassLoader cl) {
        this.delegate = new RuntimeClassMirrors(cl);
    }

    @Override
    public ClassMirror classForName(String className) throws ClassMirrorNotFoundException {
        ClassMirror ret = this.cachedClasses.get(className);
        if (ret == null) {
            ret = this.delegate.classForName(className);
        }
        if (ret == null) {
            throw new ClassMirrorNotFoundException(className);
        }
        return ret;
    }

    @Override
    public ClassMirror mirror(Class<?> clazz) {
        return this.delegate.mirror(clazz);
    }

    @Override
    public ClassMirror mirror(String className, byte[] bytecode) {
        CachedClassMirror ret = null;
        if (!this.delegate.isLoaded(className)) {
            ret = new CachedClassMirror(bytecode);
            String name = ((ClassMirror)ret).getName().replace('/', '.');
            this.cachedClasses.put(name, ret);
        }
        return ret;
    }
}

