/*
 * Decompiled with CFR 0.152.
 */
package kilim.mirrors;

import java.util.ArrayList;
import kilim.NotPausable;
import kilim.Pausable;
import kilim.analysis.AsmDetector;
import kilim.mirrors.ClassMirror;
import kilim.mirrors.ClassMirrorNotFoundException;
import kilim.mirrors.MethodMirror;
import kilim.mirrors.Mirrors;
import kilim.mirrors.RuntimeClassMirrors;

public class Detector {
    public static final int METHOD_NOT_FOUND_OR_PAUSABLE = 0;
    public static final int PAUSABLE_METHOD_FOUND = 1;
    public static final int METHOD_NOT_PAUSABLE = 2;
    static final String[] STANDARD_DONT_CHECK_LIST = new String[]{"java.", "javax."};
    public static final Detector DEFAULT = new Detector(new RuntimeClassMirrors());
    public final Mirrors mirrors;
    ClassMirror NOT_PAUSABLE;
    ClassMirror PAUSABLE;
    ClassMirror OBJECT;
    public static String D_FIBER_ = "Lkilim/Fiber;)";
    private static final ThreadLocal<Detector> DETECTOR = new ThreadLocal();
    private static final ArrayList<String> EMPTY_STRINGS = new ArrayList(0);
    static String JAVA_LANG_OBJECT = "java.lang.Object";

    public Detector(Mirrors mirrors) {
        this.mirrors = mirrors;
        this.NOT_PAUSABLE = mirrors.mirror(NotPausable.class);
        this.PAUSABLE = mirrors.mirror(Pausable.class);
        this.OBJECT = mirrors.mirror(Object.class);
    }

    public boolean isPausable(String className, String methodName, String desc) {
        return this.getPausableStatus(className, methodName, desc) == 1;
    }

    static boolean isNonPausableClass(String className) {
        return className == null || className.charAt(0) == '[' || className.startsWith("java.") || className.startsWith("javax.");
    }

    static boolean isNonPausableMethod(String methodName) {
        return methodName.endsWith("init>");
    }

    public int getPausableStatus(String className, String methodName, String desc) {
        int ret = 0;
        if (Detector.isNonPausableClass(className) || Detector.isNonPausableMethod(methodName)) {
            return 0;
        }
        className = className.replace('/', '.');
        try {
            MethodMirror m = this.findPausableMethod(className, methodName, desc);
            if (m != null) {
                for (String ex : m.getExceptionTypes()) {
                    if (Detector.isNonPausableClass(ex)) continue;
                    ClassMirror c = this.classForName(ex);
                    if (this.NOT_PAUSABLE.isAssignableFrom(c)) {
                        return 2;
                    }
                    if (!this.PAUSABLE.isAssignableFrom(c)) continue;
                    return 1;
                }
                return 2;
            }
        }
        catch (ClassMirrorNotFoundException ignore) {
        }
        catch (VerifyError ve) {
            return AsmDetector.getPausableStatus(className, methodName, desc, this);
        }
        return ret;
    }

    public ClassMirror classForName(String className) throws ClassMirrorNotFoundException {
        className = className.replace('/', '.');
        return this.mirrors.classForName(className);
    }

    public ClassMirror[] classForNames(String[] classNames) throws ClassMirrorNotFoundException {
        if (classNames == null) {
            return new ClassMirror[0];
        }
        ClassMirror[] ret = new ClassMirror[classNames.length];
        int i = 0;
        for (String cn : classNames) {
            ret[i++] = this.classForName(cn);
        }
        return ret;
    }

    private MethodMirror findPausableMethod(String className, String methodName, String desc) throws ClassMirrorNotFoundException {
        if (Detector.isNonPausableClass(className) || Detector.isNonPausableMethod(methodName)) {
            return null;
        }
        ClassMirror cl = this.classForName(className);
        if (cl == null) {
            return null;
        }
        for (MethodMirror om : cl.getDeclaredMethods()) {
            if (!om.getName().equals(methodName) || !om.getMethodDescriptor().equals(desc) || om.isBridge()) continue;
            return om;
        }
        if (this.OBJECT.equals(cl)) {
            return null;
        }
        MethodMirror m = this.findPausableMethod(cl.getSuperclass(), methodName, desc);
        if (m != null) {
            return m;
        }
        for (String ifname : cl.getInterfaces()) {
            if (Detector.isNonPausableClass(ifname) || (m = this.findPausableMethod(ifname, methodName, desc)) == null) continue;
            return m;
        }
        return null;
    }

    private static String statusToStr(int st) {
        switch (st) {
            case 0: {
                return "not found or pausable";
            }
            case 1: {
                return "pausable";
            }
            case 2: {
                return "not pausable";
            }
        }
        throw new AssertionError((Object)"Unknown status");
    }

    public static Detector getDetector() {
        Detector d = DETECTOR.get();
        if (d == null) {
            return DEFAULT;
        }
        return d;
    }

    public static Detector setDetector(Detector d) {
        Detector res = DETECTOR.get();
        DETECTOR.set(d);
        return res;
    }

    public String commonSuperType(String oa, String ob) throws ClassMirrorNotFoundException {
        String a = Detector.toClassName(oa);
        String b = Detector.toClassName(ob);
        try {
            ClassMirror ca = this.classForName(a);
            ClassMirror cb = this.classForName(b);
            if (ca.isAssignableFrom(cb)) {
                return oa;
            }
            if (cb.isAssignableFrom(ca)) {
                return ob;
            }
            if (ca.isInterface() && cb.isInterface()) {
                return "Ljava/lang/Object;";
            }
        }
        catch (ClassMirrorNotFoundException e) {
            // empty catch block
        }
        ArrayList<String> sca = this.getSuperClasses(a);
        ArrayList<String> scb = this.getSuperClasses(b);
        int lasta = sca.size() - 1;
        int lastb = scb.size() - 1;
        while (sca.get(lasta).equals(scb.get(lastb)) && --lasta >= 0 && --lastb >= 0) {
        }
        return Detector.toDesc(sca.get(lasta + 1));
    }

    public ArrayList<String> getSuperClasses(String name) throws ClassMirrorNotFoundException {
        if (name == null) {
            return EMPTY_STRINGS;
        }
        ArrayList<String> ret = new ArrayList<String>(3);
        while (name != null) {
            ret.add(name);
            ClassMirror c = this.classForName(name);
            name = c.getSuperclass();
        }
        return ret;
    }

    private static String toDesc(String name) {
        return name.equals(JAVA_LANG_OBJECT) ? "Ljava/lang/Object;" : "L" + name.replace('.', '/') + ';';
    }

    private static String toClassName(String s) {
        return s.replace('/', '.').substring(1, s.length() - 1);
    }
}

