/*
 * Decompiled with CFR 0.152.
 */
package kilim.mirrors;

import java.lang.reflect.Method;
import kilim.mirrors.ClassMirror;
import kilim.mirrors.MethodMirror;
import kilim.mirrors.RuntimeMethodMirror;

class RuntimeClassMirror
extends ClassMirror {
    private final Class<?> clazz;
    private MethodMirror[] methods;

    public RuntimeClassMirror(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassMirror) {
            return ((ClassMirror)obj).getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    @Override
    public MethodMirror[] getDeclaredMethods() {
        if (this.methods == null) {
            Method[] declaredMethods = this.clazz.getDeclaredMethods();
            this.methods = new MethodMirror[declaredMethods.length];
            for (int i = 0; i < declaredMethods.length; ++i) {
                this.methods[i] = new RuntimeMethodMirror(declaredMethods[i]);
            }
        }
        return this.methods;
    }

    @Override
    public String[] getInterfaces() {
        Class<?>[] ifs = this.clazz.getInterfaces();
        String[] result = new String[ifs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ifs[i].getName();
        }
        return result;
    }

    @Override
    public String getSuperclass() {
        Class<?> supcl = this.clazz.getSuperclass();
        return supcl != null ? supcl.getName() : null;
    }

    @Override
    public boolean isAssignableFrom(ClassMirror c) {
        if (c instanceof RuntimeClassMirror) {
            RuntimeClassMirror cc = (RuntimeClassMirror)c;
            return this.clazz.isAssignableFrom(cc.clazz);
        }
        return false;
    }
}

