/*
 * Decompiled with CFR 0.152.
 */
package kilim.mirrors;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import kilim.KilimClassLoader;
import kilim.mirrors.ClassMirror;
import kilim.mirrors.ClassMirrorNotFoundException;
import kilim.mirrors.Mirrors;
import kilim.mirrors.RuntimeClassMirror;

class RuntimeClassMirrors
extends Mirrors {
    Map<String, RuntimeClassMirror> cachedClasses = Collections.synchronizedMap(new WeakHashMap());
    public final KilimClassLoader classLoader;

    public RuntimeClassMirrors() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public RuntimeClassMirrors(ClassLoader cl) {
        if (!(cl instanceof KilimClassLoader)) {
            cl = new KilimClassLoader(cl);
        }
        this.classLoader = (KilimClassLoader)cl;
    }

    @Override
    public ClassMirror classForName(String className) throws ClassMirrorNotFoundException {
        try {
            RuntimeClassMirror ret = this.cachedClasses.get(className);
            if (ret == null) {
                ret = this.make(this.classLoader.loadClass(className));
            }
            return ret;
        }
        catch (ClassNotFoundException e) {
            throw new ClassMirrorNotFoundException(e);
        }
    }

    @Override
    public ClassMirror mirror(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return this.make(clazz);
    }

    @Override
    public ClassMirror mirror(String className, byte[] bytecode) {
        try {
            return this.classForName(className);
        }
        catch (ClassMirrorNotFoundException classMirrorNotFoundException) {
            return null;
        }
    }

    public ClassMirror loadedClassForName(String className) {
        Class<?> c = this.classLoader.getLoadedClass(className);
        return c == null ? null : this.make(c);
    }

    public Class<?> getLoadedClass(String className) {
        return this.classLoader.getLoadedClass(className);
    }

    public boolean isLoaded(String className) {
        return this.classLoader.isLoaded(className);
    }

    private RuntimeClassMirror make(Class<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        RuntimeClassMirror ret = new RuntimeClassMirror(c);
        this.cachedClasses.put(c.getName(), ret);
        return ret;
    }
}

