/*
 * Decompiled with CFR 0.152.
 */
package kilim.tools;

import java.util.Formatter;
import java.util.HashMap;
import kilim.analysis.TypeDesc;
import kilim.analysis.Utils;
import kilim.tools.DummyAnnotationVisitor;
import kilim.tools.DumpClass;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

class DumpMethodVisitor
implements Opcodes,
MethodVisitor {
    static String[] os = new String[]{"nop", "aconst_null", "iconst_m1", "iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4", "iconst_5", "lconst_0", "lconst_1", "fconst_0", "fconst_1", "fconst_2", "dconst_0", "dconst_1", "bipush", "sipush", "ldc", "ldc_w", "ldc_w", "iload", "lload", "fload", "dload", "aload", "iload_0", "iload_1", "iload_2", "iload_3", "lload_0", "lload_1", "lload_2", "lload_3", "fload_0", "fload_1", "fload_2", "fload_3", "dload_0", "dload_1", "dload_2", "dload_3", "aload_0", "aload_1", "aload_2", "aload_3", "iaload", "laload", "faload", "daload", "aaload", "baload", "caload", "saload", "istore", "lstore", "fstore", "dstore", "astore", "istore_0", "istore_1", "istore_2", "istore_3", "lstore_0", "lstore_1", "lstore_2", "lstore_3", "fstore_0", "fstore_1", "fstore_2", "fstore_3", "dstore_0", "dstore_1", "dstore_2", "dstore_3", "astore_0", "astore_1", "astore_2", "astore_3", "iastore", "lastore", "fastore", "dastore", "aastore", "bastore", "castore", "sastore", "pop", "pop2", "dup", "dup_x1", "dup_x2", "dup2", "dup2_x1", "dup2_x2", "swap", "iadd", "ladd", "fadd", "dadd", "isub", "lsub", "fsub", "dsub", "imul", "lmul", "fmul", "dmul", "idiv", "ldiv", "fdiv", "ddiv", "irem", "lrem", "frem", "drem", "ineg", "lneg", "fneg", "dneg", "ishl", "lshl", "ishr", "lshr", "iushr", "lushr", "iand", "land", "ior", "lor", "ixor", "lxor", "iinc", "i2l", "i2f", "i2d", "l2i", "l2f", "l2d", "f2i", "f2l", "f2d", "d2i", "d2l", "d2f", "i2b", "i2c", "i2s", "lcmp", "fcmpl", "fcmpg", "dcmpl", "dcmpg", "ifeq", "ifne", "iflt", "ifge", "ifgt", "ifle", "if_icmpeq", "if_icmpne", "if_icmplt", "if_icmpge", "if_icmpgt", "if_icmple", "if_acmpeq", "if_acmpne", "goto", "jsr", "ret", "tableswitch", "lookupswitch", "ireturn", "lreturn", "freturn", "dreturn", "areturn", "return", "getstatic", "putstatic", "getfield", "putfield", "invokevirtual", "invokespecial", "invokestatic", "invokeinterface", "unused", "new", "newarray", "anewarray", "arraylength", "athrow", "checkcast", "instanceof", "monitorenter", "monitorexit", "wide", "multianewarray", "ifnull", "ifnonnull", "goto_w", "jsr_w"};
    int line = 0;
    static StringBuilder fsb = new StringBuilder(100);
    static Formatter formatter = new Formatter(fsb);
    HashMap<Label, String> labels = new HashMap();
    int labCount = 1;

    public void ppn(String s) {
        if (DumpClass.lineNumbers) {
            fsb.setLength(0);
            formatter.format("%-70s ; %d", s, this.line++);
            Utils.pn(fsb.toString());
        } else {
            Utils.pn(s);
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.ppn(os[opcode] + " " + owner + "/" + name + " " + desc);
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        Utils.pn("; VISIT FRAME");
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.ppn("iinc " + var + " " + increment);
    }

    @Override
    public void visitInsn(int opcode) {
        this.ppn(os[opcode]);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (opcode == 188) {
            String t = "UNDEFINED";
            switch (operand) {
                case 4: {
                    t = " boolean";
                    break;
                }
                case 5: {
                    t = " char";
                    break;
                }
                case 6: {
                    t = " float";
                    break;
                }
                case 7: {
                    t = " double";
                    break;
                }
                case 8: {
                    t = " byte";
                    break;
                }
                case 9: {
                    t = " short";
                    break;
                }
                case 10: {
                    t = " int";
                    break;
                }
                case 11: {
                    t = " long";
                }
            }
            this.ppn(os[opcode] + t);
        } else {
            this.ppn(os[opcode] + " " + operand);
        }
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.ppn(os[opcode] + " " + this.lab(label));
    }

    @Override
    public void visitLabel(Label label) {
        Utils.dedent(2);
        Utils.pn(this.lab(label) + ":");
        Utils.indent(2);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        String op = cst instanceof Double || cst instanceof Long ? "ldc2_w " : "ldc ";
        String type = cst instanceof String ? "\"" + DumpMethodVisitor.esc((String)cst) + "\"" : cst.toString();
        this.ppn(op + type);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        Utils.pn(".line " + line);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        Utils.pn(".var " + index + " is " + name + " " + desc + " from " + this.lab(start) + " to " + this.lab(end));
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.ppn("lookupswitch");
        Utils.indent(4);
        for (int i = 0; i < keys.length; ++i) {
            Utils.pn(keys[i] + ": " + this.lab(labels[i]));
        }
        Utils.pn("default: " + this.lab(dflt));
        Utils.dedent(4);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        String str = os[opcode] + " " + owner + "/" + name + desc;
        if (opcode == 185) {
            this.ppn(str + ", " + (TypeDesc.getNumArgumentTypes(desc) + 1));
        } else {
            this.ppn(str);
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.ppn("multinewarray " + desc + " " + dims);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.ppn("tableswitch  " + min);
        Utils.indent(4);
        for (int i = min; i <= max; ++i) {
            Utils.pn(this.lab(labels[i - min]));
        }
        Utils.pn("default: " + this.lab(dflt));
        Utils.dedent(4);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        Utils.pn(".catch " + type + " from " + this.lab(start) + " to " + this.lab(end) + " using " + this.lab(handler));
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        this.ppn(os[opcode] + " " + desc);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.ppn(os[opcode] + " " + var);
    }

    private String lab(Label label) {
        String ret = this.labels.get(label);
        if (ret == null) {
            ret = "L" + this.labCount++;
            this.labels.put(label, ret);
        }
        return ret;
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return new DummyAnnotationVisitor();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Utils.pn(".annotation " + (visible ? "visible " : "") + desc);
        Utils.pn(".end annotation");
        return new DummyAnnotationVisitor();
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return new DummyAnnotationVisitor();
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitCode() {
        Utils.indent(4);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        Utils.pn(".limit stack " + maxStack);
        Utils.pn(".limit locals " + maxLocals);
    }

    @Override
    public void visitEnd() {
        Utils.resetIndentation();
        Utils.pn(".end method");
    }

    private static String esc(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n");
    }
}

