/*
 * Decompiled with CFR 0.152.
 */
package kilim.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import kilim.analysis.BBList;
import kilim.analysis.BasicBlock;
import kilim.analysis.ClassFlow;
import kilim.analysis.Frame;
import kilim.analysis.MethodFlow;
import kilim.analysis.TypeDesc;
import kilim.analysis.Usage;
import kilim.analysis.Utils;
import kilim.analysis.Value;
import kilim.mirrors.Detector;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class FlowAnalyzer {
    public static void main(String[] args) throws Exception {
        String name;
        if (args.length == 0) {
            System.err.println("Usage <class name | jar file name> [methodName]");
            System.exit(1);
        }
        if ((name = args[0]).endsWith(".jar")) {
            FlowAnalyzer.analyzeJar(name, Detector.DEFAULT);
        } else {
            FlowAnalyzer.analyzeClass(name, Detector.DEFAULT);
        }
    }

    private static void analyzeClass(String className, Detector detector) {
        try {
            Utils.pn("-------------------------------------------------");
            Utils.pn("Class: " + className);
            System.out.flush();
            ArrayList<MethodFlow> flows = new ClassFlow(className, detector).analyze(true);
            for (MethodFlow flow : flows) {
                FlowAnalyzer.reportFlow(flow, className);
            }
        }
        catch (IOException e) {
            Utils.pn("##################################################");
            FlowAnalyzer.stackTrace(e);
        }
        catch (Throwable ie) {
            Utils.pn("##################################################");
            FlowAnalyzer.stackTrace(ie);
        }
    }

    private static void stackTrace(Throwable t) {
        PrintStream ps = new PrintStream(System.out);
        t.printStackTrace(ps);
    }

    private static void reportFlow(MethodFlow method, String className) {
        Utils.resetIndentation();
        Utils.pn("Method : " + className + '.' + method.name);
        Utils.pn("MaxStack: " + method.maxStack);
        Utils.pn("MaxLocals: " + method.maxLocals);
        BBList bbs = method.getBasicBlocks();
        Collections.sort(bbs);
        Utils.indent(2);
        for (BasicBlock bb : bbs) {
            AbstractInsnNode ainode = bb.getInstruction(bb.startPos);
            if (!(ainode instanceof MethodInsnNode)) continue;
            MethodInsnNode m = (MethodInsnNode)ainode;
            int n = FlowAnalyzer.getNumArgs(m);
            Utils.pn("Call(" + n + "): " + m.owner + "." + m.name + m.desc);
            Utils.indent(2);
            Utils.pn("Inframe: ");
            Utils.indent(2);
            Frame f = bb.startFrame;
            Utils.pn(f.toString());
            Utils.dedent(2);
            Utils.pn("Live locals:");
            Utils.indent(2);
            Usage u = bb.getVarUsage();
            Utils.pn(u.toString());
            Utils.dedent(2);
            Utils.pn("Actual usage: " + FlowAnalyzer.uniqueItems(bb, f, u, n));
            Utils.dedent(2);
        }
        Utils.dedent(2);
    }

    private static String uniqueItems(BasicBlock bb, Frame f, Usage u, int nStack) {
        Value v;
        int i;
        StringBuffer sb = new StringBuffer(80);
        int numNonConstants = 0;
        int numLive = 0;
        ArrayList<Value> set = new ArrayList<Value>(10);
        for (i = 0; i < f.getMaxLocals(); ++i) {
            if (!u.isLiveIn(i)) continue;
            ++numLive;
            v = f.getLocal(i);
            if (set.contains(v)) continue;
            set.add(v);
        }
        nStack = f.getStackLen() - nStack;
        for (i = 0; i < nStack; ++i) {
            v = f.getStack(i);
            if (set.contains(v)) continue;
            set.add(v);
        }
        char[] sig = new char[set.size()];
        for (int i2 = 0; i2 < set.size(); ++i2) {
            Value v2 = (Value)set.get(i2);
            int c = v2.getTypeDesc().charAt(0);
            switch (c) {
                case 76: 
                case 78: 
                case 91: {
                    c = 79;
                    break;
                }
                case 66: 
                case 67: 
                case 73: 
                case 83: 
                case 90: {
                    c = 73;
                    break;
                }
                case 74: {
                    c = 74;
                    break;
                }
                case 70: {
                    c = 70;
                    break;
                }
                default: {
                    c = 85;
                    System.err.println("***************************************");
                    System.err.println("Undefined/unrecognized value " + v2);
                    System.err.println("BasicBlock:\n" + bb);
                }
            }
            sig[i2] = c;
            if (v2.getConstVal() != Value.NO_VAL) continue;
            ++numNonConstants;
        }
        Arrays.sort(sig);
        sb.append("avail: ").append(nStack + f.getMaxLocals());
        sb.append(", live: " + (numLive += nStack));
        sb.append(", unique: ").append(set.size());
        sb.append(", unique non-const: ").append(numNonConstants);
        sb.append("\nState signature: ").append(set.size() == 0 ? "None" : new String(sig));
        return sb.toString();
    }

    private static int getNumArgs(MethodInsnNode m) {
        int ret = TypeDesc.getNumArgumentTypes(m.desc);
        if (m.getOpcode() != 184) {
            ++ret;
        }
        return ret;
    }

    public static void analyzeJar(String jarFile, Detector detector) {
        try {
            Enumeration<JarEntry> e = new JarFile(jarFile).entries();
            while (e.hasMoreElements()) {
                ZipEntry en = e.nextElement();
                String n = en.getName();
                if (!n.endsWith(".class")) continue;
                n = n.substring(0, n.length() - 6).replace('/', '.');
                FlowAnalyzer.analyzeClass(n, detector);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

