/*
 * Decompiled with CFR 0.152.
 */
package kilim.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import kilim.analysis.ClassInfo;

public class Javac {
    static Pattern publicClassNameRegexp = Pattern.compile("public +(?:class|interface) +(\\w+)");
    static Pattern classNameRegexp = Pattern.compile("(?:class|interface) +(\\w+)");

    public static List<ClassInfo> compile(List<String> srcCodes) throws IOException {
        List<SourceInfo> srcInfos = Javac.getSourceInfos(srcCodes);
        File rootDir = Javac.getTmpDir();
        File classDir = new File(rootDir.getAbsolutePath() + File.separatorChar + "classes");
        classDir.mkdir();
        String[] options = new String[]{"-d", classDir.getAbsolutePath()};
        String[] args = new String[options.length + srcCodes.size()];
        System.arraycopy(options, 0, args, 0, options.length);
        int i = options.length;
        for (SourceInfo srci : srcInfos) {
            String name = rootDir.getAbsolutePath() + File.separatorChar + srci.className + ".java";
            Javac.writeFile(new File(name), srci.srcCode.getBytes());
            args[i++] = name;
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        compiler.run(null, null, null, args);
        ArrayList<ClassInfo> ret = new ArrayList<ClassInfo>();
        Javac.addClasses(ret, "", classDir);
        Javac.deleteDir(rootDir);
        return ret;
    }

    private static List<SourceInfo> getSourceInfos(List<String> srcCodes) {
        ArrayList<SourceInfo> srcInfos = new ArrayList<SourceInfo>(srcCodes.size());
        for (String srcCode : srcCodes) {
            srcInfos.add(Javac.getSourceInfo(srcCode));
        }
        return srcInfos;
    }

    private static SourceInfo getSourceInfo(String srcCode) {
        Matcher m = publicClassNameRegexp.matcher(srcCode);
        if (m.find()) {
            return new SourceInfo(m.group(1), srcCode);
        }
        m = classNameRegexp.matcher(srcCode);
        if (m.find()) {
            return new SourceInfo(m.group(1), srcCode);
        }
        throw new IllegalArgumentException("No class or interface definition found in src: \n'" + srcCode + "'");
    }

    private static File getTmpDir() throws IOException {
        String tmpDirName = System.getProperty("java.io.tmpdir");
        tmpDirName = tmpDirName == null ? "" : tmpDirName + File.separator;
        Random r = new Random();
        String name = tmpDirName + "kilim$" + r.nextLong();
        File rootDir = new File(name);
        if (!rootDir.mkdir()) {
            throw new IOException("Unable to make tmp directory " + rootDir.getAbsolutePath());
        }
        return rootDir;
    }

    private static void deleteDir(File rootDir) {
        for (File f : rootDir.listFiles()) {
            if (f.isDirectory()) {
                Javac.deleteDir(f);
                continue;
            }
            if (f.delete()) continue;
            System.err.println("Unable to delete " + f.getAbsolutePath());
        }
        if (!rootDir.delete()) {
            System.err.println("Unable to delete " + rootDir.getAbsolutePath());
        }
    }

    private static void addClasses(List<ClassInfo> ret, String pkgName, File dir) throws IOException {
        for (File f : dir.listFiles()) {
            String qname;
            String fname = f.getName();
            if (f.isDirectory()) {
                qname = pkgName + fname + ".";
                Javac.addClasses(ret, qname, f);
                continue;
            }
            if (fname.endsWith(".class")) {
                qname = pkgName + fname.substring(0, fname.length() - 6);
                ret.add(new ClassInfo(qname, Javac.readFile(f)));
                continue;
            }
            System.err.println("Unexpected file : " + f.getAbsolutePath());
        }
    }

    private static byte[] readFile(File f) throws IOException {
        int n;
        int len;
        byte[] buf = new byte[len];
        FileInputStream fis = new FileInputStream(f);
        int off = 0;
        for (len = (int)f.length(); len > 0; len -= n) {
            n = fis.read(buf, off, len);
            if (n == -1) {
                throw new IOException("Unexpected EOF reading " + f.getAbsolutePath());
            }
            off += n;
        }
        return buf;
    }

    private static void writeFile(File f, byte[] srcCode) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        fos.write(srcCode);
        fos.close();
    }

    private static class SourceInfo {
        public String className;
        public String srcCode;

        public SourceInfo(String nm, String code) {
            this.className = nm;
            this.srcCode = code;
        }
    }
}

