/*
 * Decompiled with CFR 0.152.
 */
package kilim.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import kilim.KilimException;
import kilim.analysis.ClassInfo;
import kilim.analysis.ClassWeaver;
import kilim.analysis.FileLister;
import kilim.mirrors.CachedClassMirrors;
import kilim.mirrors.Detector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;

public class Weaver {
    public static String outputDir = null;
    public static boolean verbose = true;
    public static Pattern excludePattern = null;
    static int err = 0;
    private Detector detector;
    private CachedClassMirrors mirrors;

    public static void main(String[] args) throws IOException {
        int err = Weaver.performWeave(args);
        if (err != 0) {
            System.exit(err);
        }
    }

    public static boolean verify(File inputFile) {
        if (verbose) {
            System.out.println("[KILIM]: verifying " + inputFile.getAbsolutePath());
        }
        StringWriter sw = new StringWriter();
        try {
            FileInputStream is = new FileInputStream(inputFile);
            ClassReader cr = new ClassReader(is);
            ClassWriter cw = new ClassWriter(cr, 1);
            CheckClassAdapter cv = new CheckClassAdapter(cw);
            cr.accept(cv, 0);
            PrintWriter pw = new PrintWriter(sw);
            CheckClassAdapter.verify(new ClassReader(cw.toByteArray()), false, pw);
        }
        catch (Exception ex) {
            sw.append(ex.getMessage());
            ex.printStackTrace(System.err);
        }
        if (sw.toString().length() == 0) {
            if (verbose) {
                System.out.println("[KILIM]: Verification of " + inputFile.getAbsolutePath() + " succeeded!");
            }
            return true;
        }
        if (verbose) {
            System.out.println("[KILIM]: Verification of " + inputFile.getAbsolutePath() + " failed! " + sw.toString());
        }
        return false;
    }

    public static int performWeave(String[] args) throws IOException {
        Detector detector = Detector.DEFAULT;
        String currentName = null;
        for (String name : Weaver.parseArgs(args)) {
            try {
                if (name.endsWith(".class")) {
                    if (Weaver.exclude(name)) continue;
                    currentName = name;
                    Weaver.weaveFile(name, new BufferedInputStream(new FileInputStream(name)), detector);
                    continue;
                }
                if (name.endsWith(".jar")) {
                    for (FileLister.Entry fe : new FileLister(name)) {
                        currentName = fe.getFileName();
                        if (!currentName.endsWith(".class") || Weaver.exclude(currentName = currentName.substring(0, currentName.length() - 6).replace('/', '.'))) continue;
                        Weaver.weaveFile(currentName, fe.getInputStream(), detector);
                    }
                    continue;
                }
                if (new File(name).isDirectory()) {
                    for (FileLister.Entry fe : new FileLister(name)) {
                        currentName = fe.getFileName();
                        if (!currentName.endsWith(".class") || Weaver.exclude(currentName)) continue;
                        Weaver.weaveFile(currentName, fe.getInputStream(), detector);
                    }
                    continue;
                }
                Weaver.weaveClass(name, detector);
            }
            catch (KilimException ke) {
                System.err.println("Error weaving " + currentName + ". " + ke.getMessage());
                err = 1;
                break;
            }
            catch (IOException ioe) {
                System.err.println("Unable to find/process '" + currentName + "'");
                err = 1;
                break;
            }
            catch (Throwable t) {
                System.err.println("Error weaving " + currentName);
                err = 1;
                break;
            }
        }
        return err;
    }

    static boolean exclude(String name) {
        return excludePattern == null ? false : excludePattern.matcher(name).find();
    }

    static void weaveFile(String name, InputStream is, Detector detector) throws IOException {
        try {
            ClassWeaver cw = new ClassWeaver(is, detector);
            cw.weave();
            Weaver.writeClasses(cw);
        }
        catch (KilimException ke) {
            System.err.println("***** Error weaving " + name + ". " + ke.getMessage());
            err = 1;
        }
        catch (RuntimeException re) {
            System.err.println("***** Error weaving " + name + ". " + re.getMessage());
            re.printStackTrace();
            err = 1;
        }
        catch (IOException ioe) {
            err = 1;
            System.err.println("***** Unable to find/process '" + name + "'\n" + ioe.getMessage());
        }
    }

    static void weaveClass(String name, Detector detector) {
        try {
            ClassWeaver cw = new ClassWeaver(name, detector);
            Weaver.writeClasses(cw);
        }
        catch (KilimException ke) {
            err = 1;
            System.err.println("***** Error weaving " + name + ". " + ke.getMessage());
        }
        catch (IOException ioe) {
            err = 1;
            System.err.println("***** Unable to find/process '" + name + "'\n" + ioe.getMessage());
        }
    }

    public static void weaveClass2(String name, Detector detector) throws IOException {
        try {
            ClassWeaver cw = new ClassWeaver(name, detector);
            cw.weave();
            Weaver.writeClasses(cw);
        }
        catch (KilimException ke) {
            err = 1;
            System.err.println("***** Error weaving " + name + ". " + ke.getMessage());
            throw ke;
        }
        catch (IOException ioe) {
            err = 1;
            System.err.println("***** Unable to find/process '" + name + "'\n" + ioe.getMessage());
            throw ioe;
        }
    }

    static void writeClasses(ClassWeaver cw) throws IOException {
        List<ClassInfo> cis = cw.getClassInfos();
        if (cis.size() > 0) {
            for (ClassInfo ci : cis) {
                Weaver.writeClass(ci);
            }
        }
    }

    static void writeClass(ClassInfo ci) throws IOException {
        String className = ci.className.replace('.', File.separatorChar);
        String dir = outputDir + File.separatorChar + Weaver.getDirName(className);
        Weaver.mkdir(dir);
        className = outputDir + File.separatorChar + className + ".class";
        if (ci.className.startsWith("kilim.S_") && new File(className).exists()) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(className);
        fos.write(ci.bytes);
        fos.close();
        if (verbose) {
            System.out.println("Wrote: " + className);
        }
    }

    static void mkdir(String dir) throws IOException {
        File f = new File(dir);
        if (!f.exists() && !f.mkdirs()) {
            throw new IOException("Unable to create directory: " + dir);
        }
    }

    static String getDirName(String className) {
        int end = className.lastIndexOf(File.separatorChar);
        return end == -1 ? "" : className.substring(0, end);
    }

    static void help() {
        System.err.println("java kilim.tools.Weaver opts -d <outputDir> (class/directory/jar)+");
        System.err.println("   where opts are   -q : quiet");
        System.err.println("                    -x <regex> : exclude all classes matching regex");
        System.exit(1);
    }

    static ArrayList<String> parseArgs(String[] args) throws IOException {
        if (args.length == 0) {
            Weaver.help();
        }
        ArrayList<String> ret = new ArrayList<String>(args.length);
        String regex = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-d")) {
                outputDir = args[++i];
                continue;
            }
            if (arg.equals("-q")) {
                verbose = false;
                continue;
            }
            if (arg.equals("-h")) {
                Weaver.help();
                continue;
            }
            if (arg.equals("-x")) {
                regex = args[++i];
                excludePattern = Pattern.compile(regex);
                continue;
            }
            ret.add(arg);
        }
        if (outputDir == null) {
            System.err.println("Specify output directory with -d option");
            System.exit(1);
        }
        Weaver.mkdir(outputDir);
        return ret;
    }

    public Weaver() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public Weaver(ClassLoader cl) {
        this.mirrors = new CachedClassMirrors(cl);
        this.detector = new Detector(this.mirrors);
    }

    public List<ClassInfo> weave(ClassInfo cl) throws KilimException {
        List<ClassInfo> ret = new ArrayList<ClassInfo>(1);
        ret.add(cl);
        ret = this.weave(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClassInfo> weave(List<ClassInfo> classes) throws KilimException {
        ArrayList<ClassInfo> ret = new ArrayList<ClassInfo>(classes.size());
        Detector origDetector = Detector.getDetector();
        Detector.setDetector(this.detector);
        try {
            for (ClassInfo cl : classes) {
                this.detector.mirrors.mirror(cl.className, cl.bytes);
            }
            for (ClassInfo cl : classes) {
                ClassWeaver cw = new ClassWeaver(cl.bytes, this.detector);
                cw.weave();
                ret.addAll(cw.getClassInfos());
            }
            ArrayList<ClassInfo> arrayList = ret;
            return arrayList;
        }
        finally {
            Detector.setDetector(origDetector);
        }
    }
}

