/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.constr.C_Field;
import polyglot.ext.hj.types.constr.C_Lit;
import polyglot.ext.hj.types.constr.C_Local;
import polyglot.ext.hj.types.constr.C_Var;
import soot.ArrayType;
import soot.CompilationDeathException;
import soot.HjToJimple.LocalGenerator;
import soot.HjToJimple.jimple.HjAbstractArrayOper;
import soot.HjToJimple.jimple.HjArrayOper;
import soot.HjToJimple.jimple.factory.HjMethodFactory;
import soot.HjToJimple.jimple.utils.ArrayViewUtils;
import soot.HjToJimple.util.HjValueBox;
import soot.HjToJimple.util.Point;
import soot.IntType;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjArrayAccess
extends HjAbstractArrayOper
implements HjArrayOper {
    protected ValueBox arrayLocalBox;
    protected ValueBox arrayValueBox;
    protected Point point;
    protected boolean isOptimizable;

    public HjArrayAccess(Local arrayLocal, Point point) {
        this.arrayLocalBox = new HjValueBox(arrayLocal);
        this.point = point;
    }

    public boolean isOptimizable() {
        HjParsedClassType hjType = ((RefType)this.arrayLocalBox.getValue().getType()).getHjType();
        return this.point.isPrimitiveIndex() && hjType.isBased();
    }

    public Local getArrayRef() {
        return (Local)this.arrayLocalBox.getValue();
    }

    public void setArrayRef(Local arrayLocal) {
        this.arrayLocalBox.setValue(arrayLocal);
    }

    public Point getArrayIndex() {
        return this.point;
    }

    public void setArrayIndex(Point point) {
        this.point = point;
    }

    public Value getArrayValue() {
        if (this.arrayValueBox != null) {
            return this.arrayValueBox.getValue();
        }
        return null;
    }

    public void setArrayValue(Value value) {
        if (this.arrayValueBox != null) {
            this.arrayValueBox.setValue(value);
        } else {
            this.arrayValueBox = new HjValueBox(value);
        }
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>();
        useBoxes.add(this.arrayLocalBox);
        useBoxes.addAll(this.point.getUseBoxes());
        if (this.arrayValueBox != null) {
            List valueBoxes = this.arrayValueBox.getValue().getUseBoxes();
            if (valueBoxes.size() != 0) {
                useBoxes.addAll(valueBoxes);
            } else {
                useBoxes.add(this.arrayValueBox);
            }
        }
        return useBoxes;
    }

    @Override
    public List<Stmt> generateStmts(LocalGenerator lg) {
        return this.genArraySet(lg);
    }

    @Override
    public List<Stmt> generateStmts(Value retValue, LocalGenerator lg) {
        return this.genArrayGet(retValue, lg);
    }

    public List<Stmt> genArrayGet(Value retValue, LocalGenerator lg) {
        Local arrayLocal;
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        if (retValue == null) {
            return stmts;
        }
        Value arrayValue = this.arrayLocalBox.getValue();
        if (arrayValue instanceof Local) {
            arrayLocal = (Local)arrayValue;
        } else {
            arrayLocal = lg.generateLocal(arrayValue.getType());
            stmts.add(Jimple.v().newAssignStmt(arrayLocal, arrayValue));
        }
        if (this.isOptimizable()) {
            Value index = this.generateIndex(arrayLocal, this.point, stmts, lg);
            Local baseArray = this.generateArrayAccess(arrayLocal, stmts, lg);
            ArrayRef arrRef = Jimple.v().newArrayRef(baseArray, index);
            stmts.add(Jimple.v().newAssignStmt(retValue, arrRef));
        } else {
            InvokeExpr invokeExpr = HjMethodFactory.getArrayValueMth(arrayLocal, this.point);
            AssignStmt assignStmt = Jimple.v().newAssignStmt(retValue, invokeExpr);
            stmts.add(assignStmt);
        }
        return stmts;
    }

    public List<Stmt> genArraySet(LocalGenerator lg) {
        Local valLocal;
        Local arrayLocal;
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        Value arrayValue = this.arrayLocalBox.getValue();
        if (arrayValue instanceof Local) {
            arrayLocal = (Local)arrayValue;
        } else {
            arrayLocal = lg.generateLocal(arrayValue.getType());
            stmts.add(Jimple.v().newAssignStmt(arrayLocal, arrayValue));
        }
        arrayValue = this.arrayValueBox.getValue();
        if (arrayValue instanceof Local) {
            valLocal = (Local)arrayValue;
        } else {
            valLocal = lg.generateLocal(arrayValue.getType());
            stmts.add(Jimple.v().newAssignStmt(valLocal, arrayValue));
        }
        if (this.isOptimizable()) {
            Value index = this.generateIndex(arrayLocal, this.point, stmts, lg);
            Local baseArray = this.generateArrayAccess(arrayLocal, stmts, lg);
            ArrayRef arrRef = Jimple.v().newArrayRef(baseArray, index);
            stmts.add(Jimple.v().newAssignStmt(arrRef, valLocal));
        } else {
            InvokeExpr invokeExpr = HjMethodFactory.setArrayValueMth(arrayLocal, valLocal, this.point, valLocal.getType());
            stmts.add(Jimple.v().newInvokeStmt(invokeExpr));
        }
        return stmts;
    }

    private Local generateArrayAccess(Local arrayLocal, List<Stmt> stmts, LocalGenerator lg) {
        Type primitiveBaseType = ArrayViewUtils.getHjArrayViewPrimitiveType(arrayLocal.getType());
        ArrayType baseArrayType = ArrayType.v(ArrayViewUtils.getHjArrayViewRuntimeBaseType(arrayLocal.getType()), 1);
        SootClass runtimeArrayViewClass = ArrayViewUtils.getHjArrayViewRuntimeClass(primitiveBaseType);
        Local baseArrayLocal = lg.generateLocal(baseArrayType);
        SootFieldRef fieldRef = Scene.v().makeFieldRef(runtimeArrayViewClass, "baseArray", baseArrayType, false);
        stmts.add(Jimple.v().newAssignStmt(baseArrayLocal, Jimple.v().newInstanceFieldRef(arrayLocal, fieldRef)));
        return baseArrayLocal;
    }

    private Value generateIndex(Local arrayViewLocal, Point p, List<Stmt> stmts, LocalGenerator lg) {
        int i;
        Integer i2;
        C_Lit lit;
        C_Var var;
        Iterator<Value> indexIter = p.getIndexList().iterator();
        SootClass arrayViewClass = Scene.v().getSootClass("hj.lang.ArrayView");
        int numDims = p.getRank();
        assert (numDims > 0);
        Local uniqueBaseLocal = null;
        Local offsetLocal = null;
        Value[] baseLocal = new Value[numDims];
        Value[] indexRankLocal = new Value[numDims];
        HjParsedClassType ct = ((RefType)arrayViewLocal.getType()).getHjType();
        if (ct.isBased()) {
            var = ct.base();
            this.isSupportedDepTypeClause(var);
            uniqueBaseLocal = lg.generateLocal(IntType.v());
            lit = (C_Lit)var;
            i2 = (Integer)lit.val();
            stmts.add(Jimple.v().newAssignStmt(uniqueBaseLocal, IntConstant.v(i2)));
            if (ArrayViewUtils.isComplexArrayView(arrayViewLocal.getType())) {
                stmts.add(Jimple.v().newAssignStmt(uniqueBaseLocal, Jimple.v().newMulExpr(uniqueBaseLocal, IntConstant.v(2))));
            }
        }
        if (ct.isOffsetSet() && !ct.isZeroOffset()) {
            var = ct.offset();
            this.isSupportedDepTypeClause(var);
            offsetLocal = lg.generateLocal(IntType.v());
            lit = (C_Lit)var;
            i2 = (Integer)lit.val();
            stmts.add(Jimple.v().newAssignStmt(offsetLocal, IntConstant.v(i2)));
            if (ArrayViewUtils.isComplexArrayView(arrayViewLocal.getType())) {
                stmts.add(Jimple.v().newAssignStmt(offsetLocal, Jimple.v().newMulExpr(offsetLocal, IntConstant.v(2))));
            }
        }
        int i3 = 0;
        while (indexIter.hasNext()) {
            indexRankLocal[i3] = lg.generateLocal(IntType.v());
            stmts.add(Jimple.v().newAssignStmt(indexRankLocal[i3], indexIter.next()));
            ++i3;
        }
        Value[] dimSizeLocals = new Value[numDims];
        ArrayList<IntConstant> paramList = new ArrayList<IntConstant>(1);
        for (i = 0; i < numDims; ++i) {
            dimSizeLocals[i] = lg.generateLocal(IntType.v());
            paramList.add(IntConstant.v(i + 1));
            stmts.add(Jimple.v().newAssignStmt(dimSizeLocals[i], Jimple.v().newVirtualInvokeExpr(arrayViewLocal, this.getDimSizeMethod().makeRef(), paramList)));
            paramList.clear();
        }
        Value[] dimOffsetTo1DLocals = new Value[numDims];
        for (i = numDims - 1; i > -1; --i) {
            dimOffsetTo1DLocals[i] = lg.generateLocal(IntType.v());
            if (i == numDims - 1) {
                stmts.add(Jimple.v().newAssignStmt(dimOffsetTo1DLocals[i], IntConstant.v(1)));
                continue;
            }
            stmts.add(Jimple.v().newAssignStmt(dimOffsetTo1DLocals[i], Jimple.v().newMulExpr(dimOffsetTo1DLocals[i + 1], dimSizeLocals[i + 1])));
        }
        if (!ct.isZeroBased()) {
            for (i = 0; i < numDims; ++i) {
                if (ct.isBased()) {
                    stmts.add(Jimple.v().newAssignStmt(indexRankLocal[i], Jimple.v().newSubExpr(indexRankLocal[i], uniqueBaseLocal)));
                    continue;
                }
                baseLocal[i] = lg.generateLocal(IntType.v());
                stmts.add(Jimple.v().newAssignStmt(indexRankLocal[i], Jimple.v().newSubExpr(indexRankLocal[i], baseLocal[i])));
            }
        }
        for (i = 0; i < numDims; ++i) {
            stmts.add(Jimple.v().newAssignStmt(indexRankLocal[i], Jimple.v().newMulExpr(indexRankLocal[i], dimOffsetTo1DLocals[i])));
        }
        for (i = 0; i < numDims - 1; ++i) {
            stmts.add(Jimple.v().newAssignStmt(indexRankLocal[0], Jimple.v().newAddExpr(indexRankLocal[0], indexRankLocal[i + 1])));
        }
        if (!ct.isOffsetSet() || !ct.isZeroOffset()) {
            if (offsetLocal == null) {
                offsetLocal = lg.generateLocal(IntType.v());
                SootFieldRef fieldRef = Scene.v().makeFieldRef(arrayViewClass, "offset", IntType.v(), false);
                stmts.add(Jimple.v().newAssignStmt(offsetLocal, Jimple.v().newInstanceFieldRef(arrayViewLocal, fieldRef)));
            }
            stmts.add(Jimple.v().newAssignStmt(indexRankLocal[0], Jimple.v().newAddExpr(indexRankLocal[0], offsetLocal)));
        }
        return indexRankLocal[0];
    }

    private boolean isSupportedDepTypeClause(C_Var var) {
        if (var instanceof C_Lit) {
            return true;
        }
        if (var instanceof C_Local || var instanceof C_Field) {
            throw new CompilationDeathException(0, "Limitation, final variable in arrayview depclause are not yet supported ");
        }
        throw new CompilationDeathException(0, "Error, can't get value of deptype property 'base' " + var);
    }

    private SootMethod getDimSizeMethod() {
        SootClass arrayViewClass = Scene.v().getSootClass("hj.lang.ArrayView");
        ArrayList<IntType> l = new ArrayList<IntType>();
        l.add(IntType.v());
        return arrayViewClass.getMethod("getDimensionSize", l, IntType.v());
    }

    @Override
    public Object clone() {
        return new HjArrayAccess((Local)this.arrayLocalBox.getValue(), (Point)this.point.clone());
    }

    @Override
    public Type getType() {
        Type runtimeViewType = this.arrayLocalBox.getValue().getType();
        return ArrayViewUtils.getHjArrayViewPrimitiveType(runtimeViewType);
    }

    @Override
    public String toString() {
        return "HjArrayAccess: " + this.arrayLocalBox.getValue() + "[" + this.point + "]";
    }
}

