/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.HjToJimple.jimple.AsyncRegionExpr;
import soot.HjToJimple.jimple.HjRegionEntry;
import soot.HjToJimple.jimple.RegionExit;
import soot.HjToJimple.util.Phaser;
import soot.HjToJimple.util.Place;
import soot.RefType;
import soot.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjAsyncRegionExpr
extends HjRegionEntry
implements AsyncRegionExpr {
    protected List<Phaser> phasers;
    protected List<Place> places;

    private HjAsyncRegionExpr(List<Phaser> phasers, List<Place> places, RegionExit regionExit) {
        super(regionExit);
        this.phasers = phasers;
        this.places = places;
    }

    public HjAsyncRegionExpr() {
        this(null, new ArrayList<Place>(), null);
    }

    @Override
    public void setPhasers(List<Phaser> phaserList) {
        this.phasers = phaserList;
    }

    @Override
    public List<Phaser> getPhasers() {
        return this.phasers;
    }

    @Override
    public boolean addPhaser(Phaser phaser) {
        if (phaser == null) {
            this.createPhaserList();
        }
        if (this.phasers.contains(phaser)) {
            return false;
        }
        this.phasers.add(phaser);
        return true;
    }

    private void createPhaserList() {
        this.phasers = new LinkedList<Phaser>();
    }

    @Override
    public void addPhasers(List<Phaser> phaserList) {
        if (this.phasers == null) {
            this.createPhaserList();
        }
        this.phasers.addAll(phaserList);
    }

    @Override
    public boolean removePhaser(Phaser phaser) {
        if (this.phasers == null || !this.phasers.contains(phaser)) {
            return false;
        }
        this.phasers.remove(phaser);
        return true;
    }

    @Override
    public boolean hasPhaser(Phaser phaser) {
        if (this.phasers == null) {
            return false;
        }
        return this.phasers.contains(phaser);
    }

    @Override
    public void setPlaces(List<Place> places) {
        this.places = places;
    }

    @Override
    public List<Place> getPlaces() {
        return this.places;
    }

    @Override
    public Place getPlace() {
        if (this.places != null) {
            if (this.places.size() == 1) {
                return this.places.get(0);
            }
            if (this.places.size() != 0) {
                throw new RuntimeException("More than one place for one activity " + this.places.size());
            }
        }
        return null;
    }

    @Override
    public boolean addPlace(Place place) {
        if (place == null || this.places.contains(place)) {
            return false;
        }
        this.places.add(place);
        return true;
    }

    @Override
    public void addPlaces(List<Place> placeList) {
        this.places.addAll(placeList);
    }

    @Override
    public boolean removePlace(Place place) {
        if (!this.places.contains(place)) {
            return false;
        }
        this.places.remove(place);
        return true;
    }

    @Override
    public boolean hasPlace(Place place) {
        return this.places.contains(place);
    }

    @Override
    public List getUseBoxes() {
        ArrayList useBoxesList = new ArrayList();
        if (this.phasers != null) {
            Iterator<Phaser> phaserIter = this.phasers.iterator();
            while (phaserIter.hasNext()) {
                useBoxesList.addAll(phaserIter.next().getUseBoxes());
            }
        }
        Iterator<Place> placeIter = this.places.iterator();
        while (placeIter.hasNext()) {
            useBoxesList.addAll(placeIter.next().getUseBoxes());
        }
        return useBoxesList;
    }

    @Override
    public Type getType() {
        return RefType.v();
    }

    @Override
    public Object clone() {
        return new HjAsyncRegionExpr(this.phasers, this.places, this.regionExit);
    }

    @Override
    public String toString() {
        String str = this.entryType() + "Region Entry";
        if (this.places != null && this.places.size() > 0) {
            str = str + " in place: " + this.places.get(0);
        }
        return str;
    }

    @Override
    public String entryType() {
        return "Async";
    }

    @Override
    public boolean isPhased() {
        return this.phasers != null;
    }
}

