/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.HjToJimple.LocalGenerator;
import soot.HjToJimple.jimple.HjArrayAccess;
import soot.HjToJimple.jimple.HjOperator;
import soot.HjToJimple.jimple.utils.StmtUtils;
import soot.Singletons;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Stmt;

public class HjInternalObjectsTranslator
extends BodyTransformer {
    public HjInternalObjectsTranslator(Singletons.Global g) {
    }

    public static HjInternalObjectsTranslator v() {
        return G.v().soot_HjToJimple_jimple_HjInternalObjectsTranslator();
    }

    protected void internalTransform(Body body, String phaseName, Map opts) {
        this.hjArrayTransform(body, phaseName, opts);
    }

    protected void hjArrayTransform(Body body, String phaseName, Map opts) {
        LocalGenerator lg = new LocalGenerator(body);
        Iterator<Unit> stmtIt = body.getUnits().snapshotIterator();
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (stmt.containsInvokeExpr()) {
                this.handleInvoke(body, stmt, lg);
                continue;
            }
            if (!(stmt instanceof AssignStmt)) continue;
            this.handleAssign(body, (AssignStmt)stmt, lg);
        }
    }

    protected void handleInvoke(Body body, Stmt stmt, LocalGenerator lg) {
        InvokeExpr invokeExpr = stmt.getInvokeExpr();
        if (invokeExpr instanceof HjOperator) {
            if (stmt instanceof AssignStmt) {
                this.invokeWithReturn((HjOperator)invokeExpr, body, stmt, lg);
            } else if (stmt instanceof InvokeStmt) {
                this.simpleInvoke((HjOperator)invokeExpr, body, stmt, lg);
            } else {
                throw new RuntimeException("Unsupport stmt for Hj Operations " + stmt);
            }
        }
    }

    protected void invokeWithReturn(HjOperator invokeExpr, Body body, Stmt stmt, LocalGenerator lg) {
        Value retValue = ((AssignStmt)stmt).getLeftOp();
        Stmt newStmt = invokeExpr.generateStmt(retValue);
        if (newStmt != null) {
            body.getUnits().swapWith(stmt, newStmt);
        } else {
            List<Stmt> newStmtList = invokeExpr.generateStmts(retValue, lg);
            if (newStmtList != null) {
                StmtUtils.replaceStmt(body, stmt, newStmtList);
            }
        }
    }

    protected void simpleInvoke(HjOperator invokeExpr, Body body, Stmt stmt, LocalGenerator lg) {
        Stmt newStmt = invokeExpr.generateStmt();
        if (newStmt != null) {
            body.getUnits().swapWith(stmt, newStmt);
        } else {
            List<Stmt> newStmtList = null;
            newStmtList = invokeExpr instanceof HjArrayAccess ? invokeExpr.generateStmts(null, lg) : invokeExpr.generateStmts(lg);
            if (newStmtList != null) {
                StmtUtils.replaceStmt(body, stmt, newStmtList);
            }
        }
    }

    protected void handleAssign(Body body, AssignStmt stmt, LocalGenerator lg) {
        Value leftVal = stmt.getLeftOpBox().getValue();
        Value rightVal = stmt.getRightOpBox().getValue();
        if (leftVal instanceof HjArrayAccess) {
            HjArrayAccess set = (HjArrayAccess)leftVal;
            set.setArrayValue(rightVal);
            List<Stmt> stmts = set.generateStmts(lg);
            StmtUtils.replaceStmt(body, stmt, stmts);
        } else if (rightVal instanceof HjArrayAccess) {
            List<Stmt> stmts = ((HjArrayAccess)rightVal).generateStmts(lg);
            StmtUtils.replaceStmt(body, stmt, stmts);
        }
    }
}

