/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple.ext.complex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.Body;
import soot.BodyTransformer;
import soot.ByteType;
import soot.G;
import soot.HjToJimple.LocalGenerator;
import soot.HjToJimple.jimple.ComplexAccessorExpr;
import soot.HjToJimple.jimple.ComplexRealExpr;
import soot.HjToJimple.jimple.HjArrayAccess;
import soot.HjToJimple.jimple.HjArrayViewConstructor;
import soot.HjToJimple.jimple.Region;
import soot.HjToJimple.jimple.RegionStmt;
import soot.HjToJimple.jimple.ext.complex.ComplexUtils;
import soot.HjToJimple.util.HjValueBox;
import soot.Local;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AddExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.ComplexConstant;
import soot.jimple.Constant;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.LengthExpr;
import soot.jimple.MulExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.ParameterRef;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.SubExpr;
import soot.jimple.UnopExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.internal.AbstractBinopExpr;
import soot.jimple.internal.AbstractInstanceFieldRef;
import soot.jimple.internal.JEqExpr;
import soot.jimple.internal.JIfStmt;
import soot.jimple.internal.JNeExpr;
import soot.jimple.toolkits.invoke.SiteInliner;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjComplexTransformer
extends BodyTransformer {
    public static final String COMPLEX_IMAG = "imag";
    public static final String COMPLEX_REAL = "real";
    public static final String UNDERSCORE_COMPLEX_IMAG = "_imag";
    public static final String UNDERSCORE_COMPLEX_REAL = "_real";
    private HashMap<String, SootMethod> methodMap = new HashMap();
    private HashMap<String, SootMethod> removeMethodMap = new HashMap();
    private HashMap<String, SootField> removeFieldMap = new HashMap();
    public static final boolean COMPLEX_LOGGER = false;
    private HashMap<String, SootField> realFieldMap = new HashMap();
    private HashMap<String, SootField> imagFieldMap = new HashMap();
    private ArrayList<SootField> removedFields = new ArrayList();
    private HashSet<Local> complexArrayRefSet = new HashSet();

    public HjComplexTransformer(Singletons.Global g) {
    }

    public static HjComplexTransformer v() {
        return G.v().soot_HjToJimple_jimple_ext_complex_HjComplexTransformer();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map opts) {
        this.hjComplexBodyTransform(body, phaseName, opts);
        this.complexArrayRefSet.clear();
    }

    private void hjComplexBodyTransform(Body body, String phaseName, Map opts) {
        LocalGenerator lg = new LocalGenerator(body);
        HashMap<String, Local> localsMap = new HashMap<String, Local>();
        ArrayList<Local> localsList = new ArrayList<Local>();
        boolean hasComplexArray = false;
        hasComplexArray = this.transformLocalComplex(body, localsMap, localsList);
        if (body.getLocals().size() != localsList.size() || hasComplexArray) {
            Chain<Local> localsChain = body.getLocals();
            localsChain.clear();
            localsChain.addAll(localsList);
        }
        this.visitStatements(body, lg, localsMap);
    }

    private void visitStatements(Body body, LocalGenerator lg, HashMap<String, Local> localsMap) {
        Iterator<Unit> stmtIter = body.getUnits().snapshotIterator();
        while (stmtIter.hasNext()) {
            Stmt stmt = (Stmt)stmtIter.next();
            if (this.hasComplex(stmt)) {
                if (stmt instanceof RegionStmt) {
                    this.transformRegionStmt(body, localsMap, stmt);
                    continue;
                }
                if (stmt instanceof IdentityStmt) {
                    this.handleIdentityStmt(body, localsMap, stmt);
                    continue;
                }
                if (stmt instanceof AssignStmt) {
                    ValueBox rightOpBoxImag;
                    ValueBox leftOpBoxImag;
                    ValueBox rightOpBoxReal = ((AssignStmt)stmt).getRightOpBox();
                    Value rightValue = rightOpBoxReal.getValue();
                    if (rightValue instanceof InvokeExpr) {
                        InvokeExpr invokeExpr = this.buildInvoke((InvokeExpr)rightValue, localsMap);
                        if (invokeExpr != null) {
                            rightOpBoxReal.setValue(invokeExpr);
                        }
                        if (!(rightValue instanceof HjArrayAccess)) continue;
                    }
                    AssignStmt cloneStmt = (AssignStmt)stmt.clone();
                    ValueBox leftOpBoxReal = ((AssignStmt)stmt).getLeftOpBox();
                    Value leftValue = leftOpBoxReal.getValue();
                    if (this.handleAssignmentRightValue(leftValue, leftOpBoxReal, leftOpBoxImag = cloneStmt.getLeftOpBox(), rightValue, rightOpBoxReal, rightOpBoxImag = cloneStmt.getRightOpBox(), stmt, body, localsMap, lg, cloneStmt)) continue;
                    if (leftValue instanceof Local && ComplexUtils.isComplex(leftValue)) {
                        leftOpBoxReal.setValue(this.getLocal((Local)leftValue, localsMap, COMPLEX_REAL));
                        leftOpBoxImag.setValue(this.getLocal((Local)leftValue, localsMap, COMPLEX_IMAG));
                    } else {
                        if (leftValue instanceof Local && leftValue.getType() instanceof ArrayType) continue;
                        if (leftValue instanceof ArrayRef) {
                            if (this.handleAssignmentToArrayRef(body, lg, stmt, cloneStmt, leftValue, leftOpBoxImag)) {
                                continue;
                            }
                        } else if (leftValue instanceof HjArrayAccess) {
                            if (this.handleAssignmentToHjArray(body, lg, stmt, cloneStmt, leftValue, leftOpBoxImag)) {
                                continue;
                            }
                        } else if (leftValue instanceof AbstractInstanceFieldRef) {
                            if (this.handleAssignmentToInstanceFieldRef(leftOpBoxReal, leftValue, leftOpBoxImag)) {
                                continue;
                            }
                        } else if (leftValue instanceof StaticFieldRef) {
                            this.handleAssignmentToStaticFieldRef(leftOpBoxReal, leftValue, leftOpBoxImag);
                        } else {
                            throw new RuntimeException("Unsupport left value: " + leftValue.getClass().getName());
                        }
                    }
                    body.getUnits().insertAfter(cloneStmt, (Unit)stmt);
                    continue;
                }
                if (stmt instanceof InvokeStmt) {
                    this.handleInvokeStmt(localsMap, stmt);
                    continue;
                }
                if (stmt instanceof JIfStmt) {
                    JIfStmt ifStmt = (JIfStmt)stmt;
                    ValueBox conditionBox = ifStmt.getConditionBox();
                    Value conditionValue = conditionBox.getValue();
                    this.handleBinOp((AbstractBinopExpr)conditionValue, conditionBox, null, stmt, body, lg, localsMap);
                    continue;
                }
                throw new RuntimeException("Unsupported stmt which has complex number: " + stmt.getClass().getName());
            }
            if (!(stmt instanceof AssignStmt) || !(((AssignStmt)stmt).getRightOp() instanceof LengthExpr)) continue;
            Value arrayVal = ((LengthExpr)((AssignStmt)stmt).getRightOp()).getOp();
            Value resVal = ((AssignStmt)stmt).getLeftOp();
            if (!this.complexArrayRefSet.contains((Local)arrayVal)) continue;
            AssignStmt shrinkStmt = Jimple.v().newAssignStmt(resVal, Jimple.v().newDivExpr(resVal, IntConstant.v(2)));
            body.getUnits().insertAfter(shrinkStmt, (Unit)stmt);
        }
    }

    private void handleInvokeStmt(HashMap<String, Local> localsMap, Stmt stmt) {
        ValueBox invokeExprBox = ((InvokeStmt)stmt).getInvokeExprBox();
        InvokeExpr invokeExpr = (InvokeExpr)invokeExprBox.getValue();
        if ((invokeExpr = this.buildInvoke(invokeExpr, localsMap)) != null) {
            invokeExprBox.setValue(invokeExpr);
        }
    }

    private void handleAssignmentToStaticFieldRef(ValueBox leftOpBox, Value leftValue, ValueBox leftOpBox_) {
        StaticFieldRef staticFieldRef = (StaticFieldRef)leftValue;
        SootField realField = this.buildField(staticFieldRef.getFieldRef(), COMPLEX_REAL);
        SootField imagField = this.buildField(staticFieldRef.getFieldRef(), COMPLEX_IMAG);
        leftOpBox.setValue(Jimple.v().newStaticFieldRef(realField.makeRef()));
        leftOpBox_.setValue(Jimple.v().newStaticFieldRef(imagField.makeRef()));
    }

    private boolean handleAssignmentToInstanceFieldRef(ValueBox leftOpBox, Value leftValue, ValueBox leftOpBox_) {
        AbstractInstanceFieldRef instFieldRef = (AbstractInstanceFieldRef)leftValue;
        if (instFieldRef.getType() instanceof ArrayType) {
            SootField arrayField = this.buildField(instFieldRef.getFieldRef(), null);
            Local baseLocal = (Local)instFieldRef.getBase();
            leftOpBox.setValue(Jimple.v().newInstanceFieldRef(baseLocal, arrayField.makeRef()));
            return true;
        }
        SootField realField = this.buildField(instFieldRef.getFieldRef(), COMPLEX_REAL);
        SootField imagField = this.buildField(instFieldRef.getFieldRef(), COMPLEX_IMAG);
        Local baseLocal = (Local)instFieldRef.getBase();
        leftOpBox.setValue(Jimple.v().newInstanceFieldRef(baseLocal, realField.makeRef()));
        leftOpBox_.setValue(Jimple.v().newInstanceFieldRef(baseLocal, imagField.makeRef()));
        return false;
    }

    private boolean handleAssignmentToArrayGeneric(Body body, LocalGenerator lg, Stmt stmt, Stmt cloneStmt, Value leftValue, ValueBox leftOpBox_, ValueBox indexBoxReal, ValueBox indexBoxImag) {
        Value indexValue = indexBoxReal.getValue();
        if (!(indexValue instanceof IntConstant)) {
            if (indexValue instanceof Local) {
                BinopExpr binExpr = Jimple.v().newMulExpr((Local)indexValue, IntConstant.v(2));
                Local newIndex = lg.generateLocal(((Local)indexValue).getType());
                body.getUnits().insertBefore(Jimple.v().newAssignStmt(newIndex, binExpr), (Unit)stmt);
                body.getUnits().insertAfter(cloneStmt, (Unit)stmt);
                binExpr = Jimple.v().newAddExpr(newIndex, IntConstant.v(1));
                body.getUnits().insertAfter(Jimple.v().newAssignStmt(newIndex, binExpr), (Unit)stmt);
                indexBoxReal.setValue(newIndex);
                indexBoxImag.setValue(newIndex);
                return true;
            }
            throw new RuntimeException("Unsupport index value: " + indexValue.getClass().getName());
        }
        int indexVal = ((IntConstant)indexValue).value;
        indexBoxReal.setValue(IntConstant.v(indexVal * 2));
        indexBoxImag.setValue(IntConstant.v(indexVal * 2 + 1));
        return false;
    }

    private boolean handleAssignmentToHjArray(Body body, LocalGenerator lg, Stmt stmt, Stmt cloneStmt, Value leftValue, ValueBox leftOpBox_) {
        List<HjValueBox> indexBoxesReal = ((HjArrayAccess)leftValue).getArrayIndex().getIndexBoxes();
        List<HjValueBox> indexBoxesImag = ((HjArrayAccess)leftOpBox_.getValue()).getArrayIndex().getIndexBoxes();
        ValueBox indexBoxReal = indexBoxesReal.get(indexBoxesReal.size() - 1);
        ValueBox indexBoxImag = indexBoxesImag.get(indexBoxesImag.size() - 1);
        return this.handleAssignmentToArrayGeneric(body, lg, stmt, cloneStmt, leftValue, leftOpBox_, indexBoxReal, indexBoxImag);
    }

    private boolean handleAssignmentToArrayRef(Body body, LocalGenerator lg, Stmt stmt, Stmt cloneStmt, Value leftValue, ValueBox leftOpBox_) {
        ValueBox indexBoxReal = ((ArrayRef)leftValue).getIndexBox();
        ValueBox indexBoxImag = ((ArrayRef)leftOpBox_.getValue()).getIndexBox();
        return this.handleAssignmentToArrayGeneric(body, lg, stmt, cloneStmt, leftValue, leftOpBox_, indexBoxReal, indexBoxImag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleAssignmentRightValue(Value leftValue, ValueBox leftOpBoxReal, ValueBox leftOpBoxImag, Value rightValue, ValueBox rightOpBoxReal, ValueBox rightOpBoxImag, Stmt stmt, Body body, HashMap<String, Local> localsMap, LocalGenerator lg, Stmt cloneStmt) {
        if (rightValue instanceof Local && ComplexUtils.isComplex(rightValue)) {
            rightOpBoxReal.setValue(this.getLocal((Local)rightValue, localsMap, COMPLEX_REAL));
            rightOpBoxImag.setValue(this.getLocal((Local)rightValue, localsMap, COMPLEX_IMAG));
            return false;
        } else {
            if (rightValue instanceof Local && rightValue.getType() instanceof ArrayType) return false;
            if (rightValue instanceof CastExpr) {
                if (ComplexUtils.isComplexConstant(rightValue = ((CastExpr)rightValue).getOp())) {
                    ComplexConstant constant = (ComplexConstant)rightValue;
                    rightOpBoxReal.setValue(constant.getReal());
                    rightOpBoxImag.setValue(constant.getImag());
                    return false;
                } else {
                    if (!(rightValue instanceof Local)) throw new RuntimeException("Unsupport cast expr for complex: " + rightValue.getClass().getName());
                    rightOpBoxReal.setValue(this.getLocal((Local)rightValue, localsMap, COMPLEX_REAL));
                    rightOpBoxImag.setValue(this.getLocal((Local)rightValue, localsMap, COMPLEX_IMAG));
                }
                return false;
            } else if (rightValue instanceof AbstractBinopExpr) {
                this.handleBinOp((AbstractBinopExpr)rightValue, rightOpBoxReal, rightOpBoxImag, stmt, body, lg, localsMap);
                return false;
            } else {
                if (rightValue instanceof NewArrayExpr) {
                    NewArrayExpr newArrExpr = (NewArrayExpr)rightValue;
                    Type arrType = newArrExpr.getBaseType();
                    Type newArrType = ComplexUtils.getComplexBaseType(arrType);
                    newArrExpr.setBaseType(newArrType);
                    Value sizeValue = newArrExpr.getSize();
                    if (sizeValue instanceof IntConstant) {
                        newArrExpr.setSize(IntConstant.v(((IntConstant)sizeValue).value * 2));
                        return true;
                    } else {
                        if (!(sizeValue instanceof Local)) throw new RuntimeException("Unsupport size value: " + sizeValue.getClass().getName());
                        MulExpr binExpr = Jimple.v().newMulExpr((Local)sizeValue, IntConstant.v(2));
                        Local sizeLocal = lg.generateLocal(((Local)sizeValue).getType());
                        body.getUnits().insertBefore(Jimple.v().newAssignStmt(sizeLocal, binExpr), (Unit)stmt);
                        newArrExpr.setSize(sizeLocal);
                    }
                    return true;
                }
                if (rightValue instanceof NewMultiArrayExpr) {
                    NewMultiArrayExpr newMultiArrExpr = (NewMultiArrayExpr)rightValue;
                    ArrayType arrType = newMultiArrExpr.getBaseType();
                    Type newArrType = ComplexUtils.getComplexBaseType(arrType);
                    newMultiArrExpr.setBaseType(ArrayType.v(newArrType, arrType.numDimensions));
                    int sizeCount = newMultiArrExpr.getSizeCount();
                    Value sizeValue = newMultiArrExpr.getSize(sizeCount - 1);
                    if (sizeValue instanceof IntConstant) {
                        newMultiArrExpr.setSize(sizeCount - 1, IntConstant.v(((IntConstant)sizeValue).value * 2));
                        return true;
                    } else {
                        if (!(sizeValue instanceof Local)) throw new RuntimeException("Unsupport size value: " + sizeValue.getClass().getName());
                        MulExpr binExpr = Jimple.v().newMulExpr((Local)sizeValue, IntConstant.v(2));
                        Local sizeLocal = lg.generateLocal(((Local)sizeValue).getType());
                        body.getUnits().insertBefore(Jimple.v().newAssignStmt(sizeLocal, binExpr), (Unit)stmt);
                        newMultiArrExpr.setSize(sizeCount - 1, sizeLocal);
                    }
                    return true;
                }
                if (rightValue instanceof AbstractInstanceFieldRef) {
                    this.handleAssignmentToInstanceFieldRef(rightOpBoxReal, rightValue, rightOpBoxImag);
                    return false;
                } else if (rightValue instanceof StaticFieldRef) {
                    this.handleAssignmentToStaticFieldRef(rightOpBoxReal, rightValue, rightOpBoxImag);
                    return false;
                } else if (rightValue instanceof ComplexConstant) {
                    ComplexConstant constant = (ComplexConstant)rightValue;
                    rightOpBoxReal.setValue(constant.getReal());
                    rightOpBoxImag.setValue(constant.getImag());
                    return false;
                } else {
                    if (rightValue instanceof ArrayRef) {
                        if (!this.handleAssignmentRightValueArrayRef(leftValue, leftOpBoxReal, leftOpBoxImag, rightValue, rightOpBoxImag, stmt, body, localsMap, lg, cloneStmt)) return false;
                        return true;
                    }
                    if (rightValue instanceof HjArrayAccess) {
                        if (!this.handleAssignmentRightValueHjArrayRef(leftValue, leftOpBoxReal, leftOpBoxImag, rightValue, rightOpBoxImag, stmt, body, localsMap, lg, cloneStmt)) return false;
                        return true;
                    }
                    if (!(rightValue instanceof UnopExpr)) throw new RuntimeException("Unsupport right value: " + rightValue.getClass().getName() + " in: " + stmt);
                    UnopExpr unopExpr = (UnopExpr)rightValue;
                    Value unopVal = unopExpr.getOp();
                    if (unopVal instanceof Local) {
                        unopExpr.setOp(this.getLocal((Local)unopVal, localsMap, COMPLEX_REAL));
                        ((UnopExpr)rightOpBoxImag.getValue()).setOp(this.getLocal((Local)unopVal, localsMap, COMPLEX_IMAG));
                        return false;
                    } else {
                        if (!(unopVal instanceof ComplexConstant)) throw new RuntimeException("Unsupport unop value: " + unopVal);
                        ComplexConstant constant = (ComplexConstant)unopVal;
                        unopExpr.setOp(constant.getReal());
                        ((UnopExpr)rightOpBoxImag.getValue()).setOp(constant.getImag());
                    }
                }
            }
        }
        return false;
    }

    private boolean handleAssignmentRightValueArrayGeneric(Value leftValue, ValueBox leftOpBoxReal, ValueBox leftOpBoxImag, Value rightValue, ValueBox rightOpBoxImag, Stmt stmt, Body body, HashMap<String, Local> localsMap, LocalGenerator lg, Stmt cloneStmt, ValueBox indexBoxReal, ValueBox indexBoxImag) {
        Value indexValue = indexBoxReal.getValue();
        if (!(indexValue instanceof IntConstant)) {
            if (indexValue instanceof Local) {
                BinopExpr binExpr = Jimple.v().newMulExpr((Local)indexValue, IntConstant.v(2));
                Local newIndex = lg.generateLocal(((Local)indexValue).getType());
                body.getUnits().insertBefore(Jimple.v().newAssignStmt(newIndex, binExpr), (Unit)stmt);
                body.getUnits().insertAfter(cloneStmt, (Unit)stmt);
                binExpr = Jimple.v().newAddExpr(newIndex, IntConstant.v(1));
                body.getUnits().insertAfter(Jimple.v().newAssignStmt(newIndex, binExpr), (Unit)stmt);
                indexBoxReal.setValue(newIndex);
                indexBoxImag.setValue(newIndex);
                if (!(leftValue instanceof Local) || !ComplexUtils.isComplex(leftValue)) {
                    throw new RuntimeException("The left side must be complex local " + leftValue);
                }
                leftOpBoxReal.setValue(this.getLocal((Local)leftValue, localsMap, COMPLEX_REAL));
                leftOpBoxImag.setValue(this.getLocal((Local)leftValue, localsMap, COMPLEX_IMAG));
                return true;
            }
            throw new RuntimeException("Unsupport index value: " + indexValue.getClass().getName());
        }
        int indexVal = ((IntConstant)indexValue).value;
        indexBoxReal.setValue(IntConstant.v(indexVal * 2));
        indexBoxImag.setValue(IntConstant.v(indexVal * 2 + 1));
        return false;
    }

    private boolean handleAssignmentRightValueHjArrayRef(Value leftValue, ValueBox leftOpBoxReal, ValueBox leftOpBoxImag, Value rightValue, ValueBox rightOpBoxImag, Stmt stmt, Body body, HashMap<String, Local> localsMap, LocalGenerator lg, Stmt cloneStmt) {
        List<HjValueBox> indexBoxesReal = ((HjArrayAccess)rightValue).getArrayIndex().getIndexBoxes();
        List<HjValueBox> indexBoxesImag = ((HjArrayAccess)rightOpBoxImag.getValue()).getArrayIndex().getIndexBoxes();
        ValueBox indexBoxReal = indexBoxesReal.get(indexBoxesReal.size() - 1);
        ValueBox indexBoxImag = indexBoxesImag.get(indexBoxesImag.size() - 1);
        return this.handleAssignmentRightValueArrayGeneric(leftValue, leftOpBoxReal, leftOpBoxImag, rightValue, rightOpBoxImag, stmt, body, localsMap, lg, cloneStmt, indexBoxReal, indexBoxImag);
    }

    private boolean handleAssignmentRightValueArrayRef(Value leftValue, ValueBox leftOpBoxReal, ValueBox leftOpBoxImag, Value rightValue, ValueBox rightOpBoxImag, Stmt stmt, Body body, HashMap<String, Local> localsMap, LocalGenerator lg, Stmt cloneStmt) {
        ValueBox indexBoxReal = ((ArrayRef)rightValue).getIndexBox();
        ValueBox indexBoxImag = ((ArrayRef)rightOpBoxImag.getValue()).getIndexBox();
        return this.handleAssignmentRightValueArrayGeneric(leftValue, leftOpBoxReal, leftOpBoxImag, rightValue, rightOpBoxImag, stmt, body, localsMap, lg, cloneStmt, indexBoxReal, indexBoxImag);
    }

    private int handleIdentityStmt(Body body, HashMap<String, Local> localsMap, Stmt stmt) {
        int paramCounter = 0;
        Stmt cloneStmt = (Stmt)stmt.clone();
        ValueBox leftOpBox = ((IdentityStmt)stmt).getLeftOpBox();
        ValueBox rightOpBox = ((IdentityStmt)stmt).getRightOpBox();
        Value leftValue = leftOpBox.getValue();
        Value rightValue = rightOpBox.getValue();
        if (leftValue instanceof Value && rightValue instanceof ParameterRef) {
            ValueBox leftOpBox_ = ((IdentityStmt)cloneStmt).getLeftOpBox();
            ValueBox rightOpBox_ = ((IdentityStmt)cloneStmt).getRightOpBox();
            Type rightType = ((ParameterRef)rightValue).getType();
            if (ComplexUtils.isComplex(rightType)) {
                leftOpBox.setValue(this.getLocal((Local)leftValue, localsMap, COMPLEX_REAL));
                leftOpBox_.setValue(this.getLocal((Local)leftValue, localsMap, COMPLEX_IMAG));
                Type paramType = ComplexUtils.getComplexBaseType(rightType);
                ParameterRef paramRef = (ParameterRef)rightValue;
                rightOpBox.setValue(new ParameterRef(paramType, paramRef.getIndex() + paramCounter++));
                rightOpBox_.setValue(new ParameterRef(paramType, paramRef.getIndex() + paramCounter));
                body.getUnits().insertAfter(cloneStmt, (Unit)stmt);
            } else if (rightType instanceof ArrayType) {
                int numDim = ((ArrayType)rightType).numDimensions;
                Type baseType = ComplexUtils.getComplexBaseType((ArrayType)rightType);
                ArrayType arrayType = ArrayType.v(baseType, numDim);
                int refIndex = ((ParameterRef)rightValue).getIndex();
                rightOpBox.setValue(new ParameterRef(arrayType, refIndex));
            }
        } else {
            throw new RuntimeException("No supported identity right value: " + rightValue.getClass().getName());
        }
        return paramCounter;
    }

    private void transformRegionStmt(Body body, HashMap<String, Local> localsMap, Stmt stmt) {
        Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
        if (regionExpr instanceof ComplexAccessorExpr) {
            ComplexAccessorExpr complexAccessor = (ComplexAccessorExpr)regionExpr;
            String kind = complexAccessor.getKind();
            Local leftLocal = (Local)complexAccessor.getLeftLocal();
            Value rightValue = complexAccessor.getRightLocal();
            if (rightValue instanceof Constant) {
                ComplexConstant cc = (ComplexConstant)rightValue;
                rightValue = regionExpr instanceof ComplexRealExpr ? cc.getReal() : cc.getImag();
            } else {
                rightValue = this.getLocal((Local)rightValue, localsMap, kind);
            }
            AssignStmt assignStmt = Jimple.v().newAssignStmt(leftLocal, rightValue);
            body.getUnits().swapWith(stmt, assignStmt);
        }
    }

    private boolean transformLocalComplex(Body body, HashMap<String, Local> localsMap, ArrayList<Local> localsList) {
        boolean hasComplexArray = false;
        Chain<Local> localsChain = body.getLocals();
        for (Local local : localsChain) {
            if (ComplexUtils.isComplex(local.getType())) {
                Type baseType = ComplexUtils.getComplexBaseType(local.getType());
                Local local_real = Jimple.v().newLocal(local.getName() + UNDERSCORE_COMPLEX_REAL, baseType);
                Local local_imag = Jimple.v().newLocal(local.getName() + UNDERSCORE_COMPLEX_IMAG, baseType);
                localsList.add(local_real);
                localsList.add(local_imag);
                localsMap.put(local_real.getName(), local_real);
                localsMap.put(local_imag.getName(), local_imag);
                continue;
            }
            if (local.getType() instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)local.getType();
                if (ComplexUtils.isComplex(arrayType)) {
                    Type baseType = ComplexUtils.getComplexBaseType(arrayType);
                    ArrayType arrType = ArrayType.v(baseType, arrayType.numDimensions);
                    local.setType(arrType);
                    hasComplexArray = true;
                    if (arrayType.numDimensions == 1) {
                        this.complexArrayRefSet.add(local);
                    }
                }
                localsList.add(local);
                continue;
            }
            localsList.add(local);
        }
        return hasComplexArray;
    }

    private void handleBinOp(AbstractBinopExpr binopExpr, ValueBox rightOpBox, ValueBox rightOpBox_, Stmt stmt, Body body, LocalGenerator lg, HashMap<String, Local> localsMap) {
        Value dVal;
        Value cVal;
        Value bVal;
        Value aVal;
        Value op1 = binopExpr.getOp1();
        Value op2 = binopExpr.getOp2();
        if (op1 instanceof Local) {
            aVal = this.getLocal((Local)op1, localsMap, COMPLEX_REAL);
            bVal = this.getLocal((Local)op1, localsMap, COMPLEX_IMAG);
        } else if (ComplexUtils.isComplexConstant(op1)) {
            ComplexConstant constant = (ComplexConstant)op1;
            aVal = constant.getReal();
            bVal = constant.getImag();
        } else {
            throw new RuntimeException("Unsupport binop: " + op1);
        }
        if (op2 instanceof Local) {
            cVal = this.getLocal((Local)op2, localsMap, COMPLEX_REAL);
            dVal = this.getLocal((Local)op2, localsMap, COMPLEX_IMAG);
        } else if (ComplexUtils.isComplexConstant(op2)) {
            ComplexConstant doubleConstant = (ComplexConstant)op2;
            cVal = doubleConstant.getReal();
            dVal = doubleConstant.getImag();
        } else {
            throw new RuntimeException("Unsupport binop: " + op2);
        }
        Type type = aVal.getType();
        if (binopExpr instanceof AddExpr) {
            Local t1Local = lg.generateLocal(type);
            Local t2Local = lg.generateLocal(type);
            AssignStmt acRealStmt = Jimple.v().newAssignStmt(t1Local, Jimple.v().newAddExpr(aVal, cVal));
            body.getUnits().insertBefore(acRealStmt, (Unit)stmt);
            AssignStmt acImagStmt = Jimple.v().newAssignStmt(t2Local, Jimple.v().newAddExpr(bVal, dVal));
            body.getUnits().insertBefore(acImagStmt, (Unit)stmt);
            rightOpBox.setValue(t1Local);
            rightOpBox_.setValue(t2Local);
        } else if (binopExpr instanceof SubExpr) {
            Local t1Local = lg.generateLocal(type);
            Local t2Local = lg.generateLocal(type);
            AssignStmt acRealStmt = Jimple.v().newAssignStmt(t1Local, Jimple.v().newSubExpr(aVal, cVal));
            body.getUnits().insertBefore(acRealStmt, (Unit)stmt);
            AssignStmt acImagStmt = Jimple.v().newAssignStmt(t2Local, Jimple.v().newSubExpr(bVal, dVal));
            body.getUnits().insertBefore(acImagStmt, (Unit)stmt);
            rightOpBox.setValue(t1Local);
            rightOpBox_.setValue(t2Local);
        } else if (binopExpr instanceof MulExpr) {
            Local t1Local = lg.generateLocal(type);
            Local t2Local = lg.generateLocal(type);
            Local t3Local = lg.generateLocal(type);
            AssignStmt acMulStmt = Jimple.v().newAssignStmt(t1Local, Jimple.v().newMulExpr(aVal, cVal));
            body.getUnits().insertBefore(acMulStmt, (Unit)stmt);
            AssignStmt bdMulStmt = Jimple.v().newAssignStmt(t2Local, Jimple.v().newMulExpr(bVal, dVal));
            body.getUnits().insertBefore(bdMulStmt, (Unit)stmt);
            AssignStmt realStmt = Jimple.v().newAssignStmt(t1Local, Jimple.v().newSubExpr(t1Local, t2Local));
            body.getUnits().insertBefore(realStmt, (Unit)stmt);
            AssignStmt bcMulStmt = Jimple.v().newAssignStmt(t2Local, Jimple.v().newMulExpr(bVal, cVal));
            body.getUnits().insertBefore(bcMulStmt, (Unit)stmt);
            AssignStmt adMulStmt = Jimple.v().newAssignStmt(t3Local, Jimple.v().newMulExpr(aVal, dVal));
            body.getUnits().insertBefore(adMulStmt, (Unit)stmt);
            AssignStmt imagStmt = Jimple.v().newAssignStmt(t2Local, Jimple.v().newAddExpr(t2Local, t3Local));
            body.getUnits().insertBefore(imagStmt, (Unit)stmt);
            rightOpBox.setValue(t1Local);
            rightOpBox_.setValue(t2Local);
        } else if (binopExpr instanceof DivExpr) {
            Local t1Local = lg.generateLocal(type);
            Local t2Local = lg.generateLocal(type);
            Local t3Local = lg.generateLocal(type);
            Local t4Local = lg.generateLocal(type);
            if (dVal instanceof DoubleConstant && ((DoubleConstant)dVal).value == 0.0 || dVal instanceof FloatConstant && ((FloatConstant)dVal).value == 0.0f) {
                AssignStmt acDivStmt = Jimple.v().newAssignStmt(t1Local, Jimple.v().newDivExpr(aVal, cVal));
                body.getUnits().insertBefore(acDivStmt, (Unit)stmt);
                AssignStmt bcDivStmt = Jimple.v().newAssignStmt(t2Local, Jimple.v().newDivExpr(bVal, cVal));
                body.getUnits().insertBefore(bcDivStmt, (Unit)stmt);
            } else {
                AssignStmt ccMulStmt = Jimple.v().newAssignStmt(t1Local, Jimple.v().newMulExpr(cVal, cVal));
                body.getUnits().insertBefore(ccMulStmt, (Unit)stmt);
                AssignStmt ddMulStmt = Jimple.v().newAssignStmt(t2Local, Jimple.v().newMulExpr(dVal, dVal));
                body.getUnits().insertBefore(ddMulStmt, (Unit)stmt);
                AssignStmt ccddStmt = Jimple.v().newAssignStmt(t4Local, Jimple.v().newAddExpr(t1Local, t2Local));
                body.getUnits().insertBefore(ccddStmt, (Unit)stmt);
                AssignStmt acMulStmt = Jimple.v().newAssignStmt(t1Local, Jimple.v().newMulExpr(aVal, cVal));
                body.getUnits().insertBefore(acMulStmt, (Unit)stmt);
                AssignStmt bdMulStmt = Jimple.v().newAssignStmt(t2Local, Jimple.v().newMulExpr(bVal, dVal));
                body.getUnits().insertBefore(bdMulStmt, (Unit)stmt);
                AssignStmt acbdStmt = Jimple.v().newAssignStmt(t1Local, Jimple.v().newAddExpr(t1Local, t2Local));
                body.getUnits().insertBefore(acbdStmt, (Unit)stmt);
                AssignStmt realStmt = Jimple.v().newAssignStmt(t1Local, Jimple.v().newDivExpr(t1Local, t4Local));
                body.getUnits().insertBefore(realStmt, (Unit)stmt);
                AssignStmt bcMulStmt = Jimple.v().newAssignStmt(t2Local, Jimple.v().newMulExpr(bVal, cVal));
                body.getUnits().insertBefore(bcMulStmt, (Unit)stmt);
                AssignStmt adMulStmt = Jimple.v().newAssignStmt(t3Local, Jimple.v().newMulExpr(aVal, dVal));
                body.getUnits().insertBefore(adMulStmt, (Unit)stmt);
                AssignStmt bcadStmt = Jimple.v().newAssignStmt(t2Local, Jimple.v().newSubExpr(t2Local, t3Local));
                body.getUnits().insertBefore(bcadStmt, (Unit)stmt);
                AssignStmt imagStmt = Jimple.v().newAssignStmt(t2Local, Jimple.v().newDivExpr(t2Local, t4Local));
                body.getUnits().insertBefore(imagStmt, (Unit)stmt);
            }
            rightOpBox.setValue(t1Local);
            rightOpBox_.setValue(t2Local);
        } else if (binopExpr instanceof JEqExpr || binopExpr instanceof JNeExpr) {
            Local t1Local = lg.generateLocal(ByteType.v());
            Local t2Local = lg.generateLocal(ByteType.v());
            Local resLocal = lg.generateLocal(ByteType.v());
            Local cmpLocal = lg.generateLocal(ByteType.v());
            ValueBox op1Box = binopExpr.getOp1Box();
            ValueBox op2Box = binopExpr.getOp2Box();
            BinopExpr ce = Jimple.v().newCmplExpr(aVal, cVal);
            AssignStmt acRealStmt = Jimple.v().newAssignStmt(t1Local, ce);
            body.getUnits().insertBefore(acRealStmt, (Unit)stmt);
            ce = Jimple.v().newCmplExpr(bVal, dVal);
            AssignStmt acImagStmt = Jimple.v().newAssignStmt(t2Local, ce);
            body.getUnits().insertBefore(acImagStmt, (Unit)stmt);
            ce = Jimple.v().newOrExpr(t1Local, t2Local);
            AssignStmt andStmt = Jimple.v().newAssignStmt(resLocal, ce);
            body.getUnits().insertBefore(andStmt, (Unit)stmt);
            IntConstant cst = IntConstant.v(0);
            AssignStmt trueStmt = Jimple.v().newAssignStmt(cmpLocal, cst);
            body.getUnits().insertBefore(trueStmt, (Unit)stmt);
            op1Box.setValue(resLocal);
            op2Box.setValue(cmpLocal);
        } else {
            throw new RuntimeException("Unsupport binop expr: " + binopExpr);
        }
    }

    private Local getLocal(Local local, HashMap<String, Local> localsMap, String subscript) {
        String name = local.getName() + "_" + subscript;
        Local newLocal = localsMap.get(name);
        if (newLocal != null) {
            return newLocal;
        }
        throw new RuntimeException("Unrecognized local: " + local);
    }

    private boolean hasComplex(Stmt stmt) {
        boolean hasComplex = false;
        for (ValueBox valueBox : stmt.getUseBoxes()) {
            Type baseType;
            Type type;
            Value value = valueBox.getValue();
            if (value instanceof Local || value instanceof SootFieldRef) {
                type = ((Local)value).getType();
                if (type instanceof ArrayType) {
                    hasComplex |= ComplexUtils.isComplex((ArrayType)type);
                    continue;
                }
                hasComplex |= ComplexUtils.isComplex(type);
                continue;
            }
            if (value instanceof NewArrayExpr) {
                baseType = ((NewArrayExpr)value).getBaseType();
                hasComplex |= ComplexUtils.isComplex(baseType);
                continue;
            }
            if (value instanceof NewMultiArrayExpr) {
                baseType = ((NewMultiArrayExpr)value).getBaseType().baseType;
                hasComplex |= ComplexUtils.isComplex(baseType);
                continue;
            }
            if (value instanceof FieldRef) {
                type = ((FieldRef)value).getFieldRef().type();
                hasComplex |= ComplexUtils.isComplex(type);
                if (!(type instanceof ArrayType)) continue;
                hasComplex |= ComplexUtils.isComplex((ArrayType)type);
                continue;
            }
            if (value instanceof HjArrayViewConstructor) {
                hasComplex |= ComplexUtils.isComplexArrayView(value.getType());
                continue;
            }
            if (ComplexUtils.isComplex(value)) {
                hasComplex |= true;
                continue;
            }
            if (!(value instanceof ParameterRef)) continue;
            type = ((ParameterRef)value).getType();
            hasComplex |= ComplexUtils.isComplex(type);
            if (!(type instanceof ArrayType)) continue;
            hasComplex |= ComplexUtils.isComplex((ArrayType)type);
        }
        for (ValueBox valueBox : stmt.getDefBoxes()) {
            Type type;
            Value value = valueBox.getValue();
            if (value instanceof Local) {
                type = ((Local)value).getType();
                hasComplex |= ComplexUtils.isComplex(type);
                continue;
            }
            if (value instanceof ArrayRef || value instanceof HjArrayAccess) continue;
            if (value instanceof FieldRef) {
                type = ((FieldRef)value).getFieldRef().type();
                hasComplex |= ComplexUtils.isComplex(type);
                if (!(type instanceof ArrayType)) continue;
                hasComplex |= ComplexUtils.isComplex((ArrayType)type);
                continue;
            }
            throw new RuntimeException("Unsupport def value: " + value.getClass().getName() + " in: " + stmt);
        }
        if (stmt.containsInvokeExpr()) {
            SootMethod method = null;
            try {
                method = stmt.getInvokeExpr().getMethod();
            }
            catch (Exception e) {
                method = null;
            }
            if (method != null && this.methodMap.containsKey(method.toString())) {
                hasComplex = true;
            }
        }
        return hasComplex;
    }

    protected InvokeExpr buildInvoke(InvokeExpr invokeExpr, HashMap<String, Local> localsMap) {
        SootMethodRef methodRef = invokeExpr.getMethodRef();
        if (methodRef == null) {
            return null;
        }
        SootMethod method = this.methodMap.get(methodRef.resolve().toString());
        if (method == null) {
            return null;
        }
        if (invokeExpr instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)invokeExpr;
            Local baseLocal = (Local)instanceInvokeExpr.getBase();
            ArrayList<Value> params = new ArrayList<Value>();
            for (Value argValue : instanceInvokeExpr.getArgs()) {
                if (argValue instanceof Local || argValue instanceof SootFieldRef) {
                    Type type = ((Local)argValue).getType();
                    if (ComplexUtils.isComplex(type)) {
                        params.add(this.getLocal((Local)argValue, localsMap, COMPLEX_REAL));
                        params.add(this.getLocal((Local)argValue, localsMap, COMPLEX_IMAG));
                        continue;
                    }
                    params.add(argValue);
                    continue;
                }
                if (ComplexUtils.isComplexConstant(argValue)) {
                    ComplexConstant constant = (ComplexConstant)argValue;
                    params.add(constant.getReal());
                    params.add(constant.getImag());
                    continue;
                }
                params.add(argValue);
            }
            if (instanceInvokeExpr instanceof VirtualInvokeExpr) {
                return Jimple.v().newVirtualInvokeExpr(baseLocal, method.makeRef(), params);
            }
            if (instanceInvokeExpr instanceof SpecialInvokeExpr) {
                return Jimple.v().newSpecialInvokeExpr(baseLocal, method.makeRef(), params);
            }
            return Jimple.v().newInterfaceInvokeExpr(baseLocal, method.makeRef(), params);
        }
        if (invokeExpr instanceof StaticInvokeExpr) {
            return this.handleStaticInvokeExpr(invokeExpr, localsMap, method);
        }
        System.out.println("no not virtual invoke");
        return null;
    }

    private InvokeExpr handleStaticInvokeExpr(InvokeExpr invokeExpr, HashMap<String, Local> localsMap, SootMethod method) {
        StaticInvokeExpr staticInvokeExpr = (StaticInvokeExpr)invokeExpr;
        ArrayList<Value> params = new ArrayList<Value>();
        for (Value argValue : staticInvokeExpr.getArgs()) {
            if (argValue instanceof Local || argValue instanceof SootFieldRef) {
                Type type = ((Local)argValue).getType();
                if (ComplexUtils.isComplex(type)) {
                    params.add(this.getLocal((Local)argValue, localsMap, COMPLEX_REAL));
                    params.add(this.getLocal((Local)argValue, localsMap, COMPLEX_IMAG));
                    continue;
                }
                params.add(argValue);
                continue;
            }
            if (argValue instanceof ComplexConstant) {
                ComplexConstant constant = (ComplexConstant)argValue;
                params.add(constant.getReal());
                params.add(constant.getImag());
                continue;
            }
            params.add(argValue);
        }
        return Jimple.v().newStaticInvokeExpr(method.makeRef(), params);
    }

    private SootField buildField(SootFieldRef fieldRef, String subscript) {
        SootField imagField;
        SootField realField;
        SootField field = fieldRef.resolve();
        Type fieldType = field.getType();
        String fieldToString = field.toString();
        if (!this.realFieldMap.containsKey(fieldToString)) {
            SootClass declClass = fieldRef.declaringClass();
            if (!ComplexUtils.isComplex(fieldType)) {
                if (fieldType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)fieldType;
                    int numDim = arrayType.numDimensions;
                    if (ComplexUtils.isComplex(arrayType)) {
                        Type complexBaseType = ComplexUtils.getComplexBaseType(arrayType);
                        SootField arrayField = new SootField(field.getName(), ArrayType.v(complexBaseType, numDim), field.getModifiers());
                        declClass.addField(arrayField);
                        this.realFieldMap.put(fieldToString, arrayField);
                        this.removeFieldMap.put(fieldToString, field);
                        return arrayField;
                    }
                    throw new RuntimeException("Wrong array field type: " + arrayType.baseType);
                }
                throw new RuntimeException("Wrong type: " + fieldType);
            }
            Type fieldJavaType = ComplexUtils.getComplexBaseType(fieldType);
            realField = new SootField(field.getName() + UNDERSCORE_COMPLEX_REAL, fieldJavaType, field.getModifiers());
            imagField = new SootField(field.getName() + UNDERSCORE_COMPLEX_IMAG, fieldJavaType, field.getModifiers());
            declClass.addField(realField);
            declClass.addField(imagField);
            this.realFieldMap.put(fieldToString, realField);
            this.imagFieldMap.put(fieldToString, imagField);
            this.removeFieldMap.put(fieldToString, field);
        } else {
            realField = this.realFieldMap.get(fieldToString);
            imagField = this.imagFieldMap.get(fieldToString);
            if (imagField == null) {
                return realField;
            }
        }
        if (subscript.startsWith(COMPLEX_REAL)) {
            return realField;
        }
        return imagField;
    }

    public void handleMethods(Iterator<SootClass> classIter) {
        ArrayList<SootMethod> newMethodList = new ArrayList<SootMethod>();
        ArrayList<SootMethod> removeMethodList = new ArrayList<SootMethod>();
        while (classIter.hasNext()) {
            newMethodList.clear();
            SootClass checkClass = classIter.next();
            Iterator<SootMethod> methodIter = checkClass.methodIterator();
            while (methodIter.hasNext()) {
                Type baseType;
                ArrayType arrayType;
                SootMethod method = methodIter.next();
                boolean hasComplex = false;
                if (ComplexUtils.isComplex(method.getReturnType())) {
                    removeMethodList.add(method);
                    continue;
                }
                Iterator origParamTypes = method.getParameterTypes().iterator();
                ArrayList<Type> paramTypes = new ArrayList<Type>();
                while (origParamTypes.hasNext()) {
                    Type type = (Type)origParamTypes.next();
                    if (ComplexUtils.isComplex(type)) {
                        Type baseType2 = ComplexUtils.getComplexBaseType(type);
                        paramTypes.add(baseType2);
                        paramTypes.add(baseType2);
                        hasComplex = true;
                        continue;
                    }
                    if (type instanceof ArrayType) {
                        arrayType = (ArrayType)type;
                        if (ComplexUtils.isComplex(arrayType)) {
                            baseType = ComplexUtils.getComplexBaseType(arrayType);
                            paramTypes.add(ArrayType.v(baseType, arrayType.numDimensions));
                            hasComplex = true;
                            continue;
                        }
                        paramTypes.add(type);
                        continue;
                    }
                    paramTypes.add(type);
                }
                Type retType = method.getReturnType();
                if (retType instanceof ArrayType && ComplexUtils.isComplex(arrayType = (ArrayType)retType)) {
                    baseType = ComplexUtils.getComplexBaseType(arrayType);
                    retType = ArrayType.v(baseType, arrayType.numDimensions);
                    hasComplex = true;
                }
                if (!hasComplex) continue;
                SootMethod newMethod = new SootMethod(method.getName(), paramTypes, retType, method.getModifiers());
                newMethod.setActiveBody(method.retrieveActiveBody());
                this.methodMap.put(method.toString(), newMethod);
                this.removeMethodMap.put(method.toString(), method);
                newMethodList.add(newMethod);
            }
            Iterator newMethodIter = newMethodList.iterator();
            while (newMethodIter.hasNext()) {
                checkClass.addMethod((SootMethod)newMethodIter.next());
            }
            for (SootMethod method : removeMethodList) {
                try {
                    checkClass.removeMethod(method);
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean inlineComplex(Iterator<SootClass> classIter) {
        boolean hasInlining = false;
        while (classIter.hasNext()) {
            SootClass checkClass = classIter.next();
            Iterator<SootMethod> methodIter = checkClass.methodIterator();
            while (methodIter.hasNext()) {
                SootMethod method = methodIter.next();
                if (!method.isConcrete()) continue;
                Body body = method.retrieveActiveBody();
                Iterator<Unit> unitIter = body.getUnits().snapshotIterator();
                while (unitIter.hasNext()) {
                    Stmt stmt = (Stmt)unitIter.next();
                    if (!stmt.containsInvokeExpr()) continue;
                    SootMethod calleeMethod = null;
                    try {
                        calleeMethod = stmt.getInvokeExpr().getMethod();
                    }
                    catch (Exception e) {
                        calleeMethod = null;
                    }
                    if (calleeMethod == null || !ComplexUtils.isComplex(calleeMethod.getReturnType())) continue;
                    SiteInliner.inlineSite(calleeMethod, stmt, method);
                    hasInlining = true;
                }
            }
        }
        return hasInlining;
    }

    public void cleanClass() {
        Object[] methods = this.removeMethodMap.values().toArray();
        for (int i = 0; i < methods.length; ++i) {
            SootMethod method = (SootMethod)methods[i];
            SootClass declClass = method.getDeclaringClass();
            method.releaseActiveBody();
            declClass.removeMethod(method);
        }
        Object[] fields = this.removeFieldMap.values().toArray();
        for (int i = 0; i < fields.length; ++i) {
            SootField field = (SootField)fields[i];
            SootClass declClass = field.getDeclaringClass();
            declClass.removeField(field);
        }
    }
}

