/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple.utils;

import java.util.List;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.ComplexDoubleType;
import soot.ComplexFloatType;
import soot.DoubleType;
import soot.FloatType;
import soot.HjToJimple.Util;
import soot.IntType;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;

public class ArrayViewUtils {
    public static Type getHjArrayViewRuntimeBaseType(Type arrayType) {
        SootClass sootClass = ((RefType)arrayType).getSootClass();
        if (ArrayViewUtils.isShortArrayView(sootClass)) {
            return ShortType.v();
        }
        if (ArrayViewUtils.isIntArrayView(sootClass)) {
            return IntType.v();
        }
        if (ArrayViewUtils.isLongArrayView(sootClass)) {
            return LongType.v();
        }
        if (ArrayViewUtils.isDoubleArrayView(sootClass)) {
            return DoubleType.v();
        }
        if (ArrayViewUtils.isFloatArrayView(sootClass)) {
            return FloatType.v();
        }
        if (ArrayViewUtils.isComplexDoubleArrayView(sootClass)) {
            return DoubleType.v();
        }
        if (ArrayViewUtils.isComplexFloatArrayView(sootClass)) {
            return FloatType.v();
        }
        if (ArrayViewUtils.isBooleanArrayView(sootClass)) {
            return BooleanType.v();
        }
        if (ArrayViewUtils.isCharArrayView(sootClass)) {
            return CharType.v();
        }
        if (ArrayViewUtils.isByteArrayView(sootClass)) {
            return ByteType.v();
        }
        throw new RuntimeException("Unsupported HjArray type: " + arrayType + " -->" + arrayType.getClass().getName());
    }

    public static Type getHjArrayViewPrimitiveType(Type arrayType) {
        SootClass sootClass = ((RefType)arrayType).getSootClass();
        if (ArrayViewUtils.isShortArrayView(sootClass)) {
            return ShortType.v();
        }
        if (ArrayViewUtils.isIntArrayView(sootClass)) {
            return IntType.v();
        }
        if (ArrayViewUtils.isLongArrayView(sootClass)) {
            return LongType.v();
        }
        if (ArrayViewUtils.isDoubleArrayView(sootClass)) {
            return DoubleType.v();
        }
        if (ArrayViewUtils.isFloatArrayView(sootClass)) {
            return FloatType.v();
        }
        if (ArrayViewUtils.isComplexDoubleArrayView(sootClass)) {
            return ComplexDoubleType.v();
        }
        if (ArrayViewUtils.isComplexFloatArrayView(sootClass)) {
            return ComplexFloatType.v();
        }
        if (ArrayViewUtils.isBooleanArrayView(sootClass)) {
            return BooleanType.v();
        }
        if (ArrayViewUtils.isCharArrayView(sootClass)) {
            return CharType.v();
        }
        if (ArrayViewUtils.isByteArrayView(sootClass)) {
            return ByteType.v();
        }
        throw new RuntimeException("Unsupported HjArray type: " + arrayType + " -->" + arrayType.getClass().getName());
    }

    public static Type getHjArrayViewType(Type baseType) {
        if (baseType instanceof IntType) {
            return RefType.v("hj.array.view.IntArrayView");
        }
        if (baseType instanceof DoubleType) {
            return RefType.v("hj.array.view.DoubleArrayView");
        }
        if (baseType instanceof FloatType) {
            return RefType.v("hj.array.view.FloatArrayView");
        }
        if (baseType instanceof BooleanType) {
            return RefType.v("hj.array.view.BooleanArrayView");
        }
        if (baseType instanceof LongType) {
            return RefType.v("hj.array.view.LongArrayView");
        }
        if (baseType instanceof ShortType) {
            return RefType.v("hj.array.view.ShortArrayView");
        }
        if (baseType instanceof ByteType) {
            return RefType.v("hj.array.view.ByteArrayView");
        }
        if (baseType instanceof ComplexDoubleType) {
            return RefType.v("hj.array.view.ComplexDoubleArrayView");
        }
        if (baseType instanceof ComplexFloatType) {
            return RefType.v("hj.array.view.ComplexDoubleArrayView");
        }
        throw new RuntimeException("Unsupported base type: " + baseType + " -->" + baseType.getClass().getName());
    }

    public static SootClass getHjArrayViewRuntimeClass(Type baseType) {
        if (baseType instanceof IntType) {
            return ArrayViewUtils.getIntArrayViewClass();
        }
        if (baseType instanceof DoubleType) {
            return ArrayViewUtils.getDoubleArrayViewClass();
        }
        if (baseType instanceof FloatType) {
            return ArrayViewUtils.getFloatArrayViewClass();
        }
        if (baseType instanceof BooleanType) {
            return ArrayViewUtils.getBooleanArrayViewClass();
        }
        if (baseType instanceof LongType) {
            return ArrayViewUtils.getLongArrayViewClass();
        }
        if (baseType instanceof ShortType) {
            return ArrayViewUtils.getShortArrayViewClass();
        }
        if (baseType instanceof ByteType) {
            return ArrayViewUtils.getByteArrayViewClass();
        }
        if (baseType instanceof ComplexDoubleType) {
            return ArrayViewUtils.getComplexDoubleArrayViewClass();
        }
        if (baseType instanceof ComplexFloatType) {
            return ArrayViewUtils.getComplexFloatArrayViewClass();
        }
        throw new RuntimeException("Unsupported base type: " + baseType + " -->" + baseType.getClass().getName());
    }

    public static SootClass getShortArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.ShortArrayView");
    }

    public static boolean isShortArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getShortArrayViewClass());
    }

    public static SootClass getIntArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.IntArrayView");
    }

    public static boolean isIntArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getIntArrayViewClass());
    }

    public static SootClass getLongArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.LongArrayView");
    }

    public static boolean isLongArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getLongArrayViewClass());
    }

    public static SootClass getDoubleArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.DoubleArrayView");
    }

    public static boolean isDoubleArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getDoubleArrayViewClass());
    }

    public static SootClass getFloatArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.FloatArrayView");
    }

    public static boolean isFloatArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getFloatArrayViewClass());
    }

    public static SootClass getBooleanArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.BooleanArrayView");
    }

    public static boolean isBooleanArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getBooleanArrayViewClass());
    }

    public static SootClass getCharArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.CharArrayView");
    }

    public static boolean isCharArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getCharArrayViewClass());
    }

    public static SootClass getByteArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.ByteArrayView");
    }

    public static boolean isByteArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getByteArrayViewClass());
    }

    public static SootClass getComplexDoubleArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.ComplexDoubleArrayView");
    }

    public static boolean isComplexArrayView(SootClass arrayViewClass) {
        return ArrayViewUtils.isComplexDoubleArrayView(arrayViewClass) || ArrayViewUtils.isComplexFloatArrayView(arrayViewClass);
    }

    public static boolean isComplexDoubleArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getComplexDoubleArrayViewClass());
    }

    public static SootClass getComplexFloatArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.ComplexDoubleArrayView");
    }

    public static boolean isComplexFloatArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getComplexFloatArrayViewClass());
    }

    public static SootMethod getArrayMethod(SootClass factoryClass, List typeList, Type retType) {
        SootClass retClass = ((RefType)retType).getSootClass();
        RefType runtimeArrayViewType = retClass.getType();
        if (ArrayViewUtils.isShortArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newShortArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isIntArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newIntArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isLongArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newLongArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isDoubleArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newDoubleArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isFloatArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newFloatArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isBooleanArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newBooleanArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isCharArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newCharArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isByteArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newByteArrayView", typeList, runtimeArrayViewType);
        }
        throw new RuntimeException("No supported return array type " + retType);
    }

    public static boolean isComplexArrayView(Type type) {
        SootClass sootClass = ((RefType)type).getSootClass();
        return ArrayViewUtils.isComplexArrayView(sootClass);
    }
}

