/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Binary;
import soot.HjToJimple.util.HjValueBox;
import soot.HjToJimple.util.LoopDomain;
import soot.Local;
import soot.Value;
import soot.ValueBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoopDomain_c
implements LoopDomain {
    private ValueBox initialValueBox;
    private ValueBox terminalValueBox;
    private ValueBox strideValueBox;
    private ValueBox domainValueBox;
    private Binary.Operator domainOper;
    private Binary.Operator strideOper;
    private List<LoopDomain> subDomains;

    public LoopDomain_c() {
        this.domainOper = Binary.ADD;
        this.strideOper = Binary.ADD;
    }

    public LoopDomain_c(Value domainValue) {
        this.domainValueBox = new HjValueBox(domainValue);
        this.domainOper = Binary.ADD;
        this.strideOper = Binary.ADD;
    }

    public LoopDomain_c(Value initialValue, Value terminalValue, Value strideValue) {
        if (initialValue != null) {
            this.initialValueBox = new HjValueBox(initialValue);
        }
        if (terminalValue != null) {
            this.terminalValueBox = new HjValueBox(terminalValue);
        }
        if (strideValue != null) {
            this.strideValueBox = new HjValueBox(strideValue);
        }
        this.domainOper = Binary.ADD;
        this.strideOper = Binary.ADD;
    }

    public LoopDomain_c(Value initialValue, Value terminalValue, Value strideValue, Binary.Operator strideOper, Binary.Operator domainOper) {
        if (initialValue != null) {
            this.initialValueBox = new HjValueBox(initialValue);
        }
        if (terminalValue != null) {
            this.terminalValueBox = new HjValueBox(terminalValue);
        }
        if (strideValue != null) {
            this.strideValueBox = new HjValueBox(strideValue);
        }
        this.domainOper = domainOper;
        this.strideOper = strideOper;
    }

    @Override
    public void addDomain(LoopDomain domain) {
        if (this.subDomains == null) {
            this.subDomains = new ArrayList<LoopDomain>();
        }
        this.subDomains.add(domain);
    }

    @Override
    public void setSubDomains(List<LoopDomain> domainList) {
        this.subDomains = domainList;
    }

    @Override
    public boolean hasSubDomains() {
        return this.subDomains != null;
    }

    @Override
    public List<LoopDomain> getSubDomains() {
        return this.subDomains;
    }

    @Override
    public void setInitialValue(Value initialValue) {
        if (initialValue != null) {
            if (this.initialValueBox != null) {
                this.initialValueBox.setValue(initialValue);
            } else {
                this.initialValueBox = new HjValueBox(initialValue);
            }
        }
    }

    @Override
    public void setTerminalValue(Value terminalValue) {
        if (terminalValue != null) {
            if (this.terminalValueBox != null) {
                this.terminalValueBox.setValue(terminalValue);
            } else {
                this.terminalValueBox = new HjValueBox(terminalValue);
            }
        }
    }

    @Override
    public void setStrideValue(Value strideValue) {
        if (strideValue != null) {
            if (this.strideValueBox != null) {
                this.strideValueBox.setValue(strideValue);
            } else {
                this.strideValueBox = new HjValueBox(strideValue);
            }
        }
    }

    @Override
    public Value getInitialValue() {
        if (this.initialValueBox != null) {
            return this.initialValueBox.getValue();
        }
        return null;
    }

    @Override
    public Value getTerminalValue() {
        if (this.terminalValueBox != null) {
            return this.terminalValueBox.getValue();
        }
        return null;
    }

    @Override
    public Value getStrideValue() {
        if (this.strideValueBox != null) {
            return this.strideValueBox.getValue();
        }
        return null;
    }

    @Override
    public Value getDomainValue() {
        if (this.domainValueBox != null) {
            return this.domainValueBox.getValue();
        }
        return null;
    }

    @Override
    public void setDomainValue(Value domainValue) {
        if (domainValue != null) {
            if (this.domainValueBox != null) {
                this.domainValueBox.setValue(domainValue);
            } else {
                this.domainValueBox = new HjValueBox(domainValue);
            }
        }
    }

    @Override
    public void setDomainOper(Binary.Operator oper) {
        this.domainOper = oper;
    }

    @Override
    public Binary.Operator getDomainOper() {
        return this.domainOper;
    }

    @Override
    public void setStrideOper(Binary.Operator oper) {
        this.strideOper = oper;
    }

    @Override
    public Binary.Operator getStrideOper() {
        return this.strideOper;
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> localList = new ArrayList<ValueBox>();
        if (this.subDomains != null) {
            this.collectLocals(this.subDomains.iterator(), localList);
        } else if (this.domainValueBox != null) {
            localList.add(this.domainValueBox);
        } else {
            if (this.initialValueBox != null) {
                localList.add(this.initialValueBox);
            }
            if (this.terminalValueBox != null) {
                localList.add(this.terminalValueBox);
            }
            if (this.strideValueBox != null) {
                localList.add(this.strideValueBox);
            }
        }
        return localList;
    }

    protected void collectLocals(Iterator<LoopDomain> domainIter, List localList) {
        while (domainIter.hasNext()) {
            LoopDomain domain = domainIter.next();
            if (domain.hasSubDomains()) {
                this.collectLocals(domain.getSubDomains().iterator(), localList);
                continue;
            }
            if (this.domainValueBox != null) {
                localList.add(new HjValueBox(this.domainValueBox.getValue()));
                continue;
            }
            if (domain.getInitialValue() != null && domain.getInitialValue() instanceof Local) {
                localList.add(new HjValueBox(domain.getInitialValue()));
            }
            if (domain.getTerminalValue() != null && domain.getTerminalValue() instanceof Local) {
                localList.add(new HjValueBox(domain.getTerminalValue()));
            }
            if (domain.getStrideValue() == null || !(domain.getStrideValue() instanceof Local)) continue;
            localList.add(new HjValueBox(domain.getStrideValue()));
        }
    }

    @Override
    public List<Value> collectInitValues() {
        ArrayList<Value> valueList = new ArrayList<Value>();
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            while (domainIter.hasNext()) {
                domainIter.next().collectInitValues(valueList);
            }
        } else if (this.domainValueBox != null) {
            valueList.add(this.domainValueBox.getValue());
        } else if (this.initialValueBox != null) {
            valueList.add(this.initialValueBox.getValue());
        }
        return valueList;
    }

    @Override
    public void collectInitValues(List<Value> valueList) {
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            while (domainIter.hasNext()) {
                domainIter.next().collectInitValues(valueList);
            }
        } else if (this.domainValueBox != null) {
            valueList.add(this.domainValueBox.getValue());
        } else if (this.initialValueBox != null) {
            valueList.add(this.initialValueBox.getValue());
        }
    }

    @Override
    public List<Local> collectInitLocals() {
        ArrayList<Local> localList = new ArrayList<Local>();
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            while (domainIter.hasNext()) {
                domainIter.next().collectInitLocals(localList);
            }
        } else if (this.domainValueBox != null) {
            if (this.domainValueBox.getValue() instanceof Local) {
                localList.add((Local)this.domainValueBox.getValue());
            }
        } else if (this.initialValueBox != null && this.initialValueBox.getValue() instanceof Local) {
            localList.add((Local)this.initialValueBox.getValue());
        }
        return localList;
    }

    @Override
    public void collectInitLocals(List<Local> localList) {
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            while (domainIter.hasNext()) {
                domainIter.next().collectInitLocals(localList);
            }
        } else if (this.domainValueBox != null) {
            if (this.domainValueBox.getValue() instanceof Local) {
                localList.add((Local)this.domainValueBox.getValue());
            }
        } else if (this.initialValueBox != null && this.initialValueBox.getValue() instanceof Local) {
            localList.add((Local)this.initialValueBox.getValue());
        }
    }

    @Override
    public List<Value> collectTermValues() {
        ArrayList<Value> valueList = new ArrayList<Value>();
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            while (domainIter.hasNext()) {
                domainIter.next().collectTermValues(valueList);
            }
        } else if (this.domainValueBox != null) {
            valueList.add(this.domainValueBox.getValue());
        } else if (this.terminalValueBox != null) {
            valueList.add(this.terminalValueBox.getValue());
        }
        return valueList;
    }

    @Override
    public void collectTermValues(List<Value> valueList) {
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            while (domainIter.hasNext()) {
                domainIter.next().collectTermValues(valueList);
            }
        } else if (this.domainValueBox != null) {
            valueList.add(this.domainValueBox.getValue());
        } else if (this.terminalValueBox != null) {
            valueList.add(this.terminalValueBox.getValue());
        }
    }

    @Override
    public List<Local> collectTermLocals() {
        ArrayList<Local> localList = new ArrayList<Local>();
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            while (domainIter.hasNext()) {
                domainIter.next().collectTermLocals(localList);
            }
        } else if (this.domainValueBox != null) {
            if (this.domainValueBox.getValue() instanceof Local) {
                localList.add((Local)this.domainValueBox.getValue());
            }
        } else if (this.terminalValueBox != null && this.terminalValueBox.getValue() instanceof Local) {
            localList.add((Local)this.terminalValueBox.getValue());
        }
        return localList;
    }

    @Override
    public void collectTermLocals(List<Local> localList) {
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            while (domainIter.hasNext()) {
                domainIter.next().collectTermLocals(localList);
            }
        } else if (this.domainValueBox != null) {
            if (this.domainValueBox.getValue() instanceof Local) {
                localList.add((Local)this.domainValueBox.getValue());
            }
        } else if (this.terminalValueBox != null && this.terminalValueBox.getValue() instanceof Local) {
            localList.add((Local)this.terminalValueBox.getValue());
        }
    }

    @Override
    public List<Value> collectStrideValues() {
        ArrayList<Value> valueList = new ArrayList<Value>();
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            while (domainIter.hasNext()) {
                domainIter.next().collectStrideValues(valueList);
            }
        } else if (this.domainValueBox != null) {
            valueList.add(this.domainValueBox.getValue());
        } else if (this.strideValueBox != null) {
            valueList.add(this.strideValueBox.getValue());
        }
        return valueList;
    }

    @Override
    public void collectStrideValues(List<Value> valueList) {
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            while (domainIter.hasNext()) {
                domainIter.next().collectStrideValues(valueList);
            }
        } else if (this.domainValueBox != null) {
            valueList.add(this.domainValueBox.getValue());
        } else if (this.strideValueBox != null) {
            valueList.add(this.strideValueBox.getValue());
        }
    }

    @Override
    public List<Local> collectStrideLocals() {
        ArrayList<Local> localList = new ArrayList<Local>();
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            while (domainIter.hasNext()) {
                domainIter.next().collectStrideLocals(localList);
            }
        } else if (this.domainValueBox != null) {
            if (this.domainValueBox.getValue() instanceof Local) {
                localList.add((Local)this.domainValueBox.getValue());
            }
        } else if (this.strideValueBox != null && this.strideValueBox.getValue() instanceof Local) {
            localList.add((Local)this.strideValueBox.getValue());
        }
        return localList;
    }

    @Override
    public void collectStrideLocals(List<Local> localList) {
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            while (domainIter.hasNext()) {
                domainIter.next().collectStrideLocals(localList);
            }
        } else if (this.domainValueBox != null) {
            if (this.domainValueBox.getValue() instanceof Local) {
                localList.add((Local)this.domainValueBox.getValue());
            }
        } else if (this.strideValueBox != null && this.strideValueBox.getValue() instanceof Local) {
            localList.add((Local)this.strideValueBox.getValue());
        }
    }

    @Override
    public LoopDomain clone() {
        LoopDomain_c cloneDomain = new LoopDomain_c(this.initialValueBox.getValue(), this.terminalValueBox.getValue(), this.strideValueBox.getValue(), this.strideOper, this.domainOper);
        cloneDomain.setDomainValue(this.domainValueBox.getValue());
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            while (domainIter.hasNext()) {
                cloneDomain.addDomain(domainIter.next().clone());
            }
        }
        return cloneDomain;
    }

    @Override
    public String toString() {
        String str = "[";
        if (this.subDomains != null) {
            Iterator<LoopDomain> domainIter = this.subDomains.iterator();
            if (domainIter.hasNext()) {
                str = str + domainIter.next();
            }
            while (domainIter.hasNext()) {
                str = str + "," + domainIter.next();
            }
        } else {
            str = this.domainValueBox != null ? str + this.domainValueBox.getValue() : str + this.initialValueBox.getValue() + ",  " + this.terminalValueBox.getValue() + ", " + this.strideValueBox.getValue();
        }
        str = str + "]";
        return str;
    }
}

