/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import polyglot.ext.hj.Version;
import soot.CompilationDeathException;
import soot.G;
import soot.Pack;
import soot.PackManager;
import soot.Scene;
import soot.Singletons;
import soot.Timers;
import soot.Transform;
import soot.options.Options;
import soot.toolkits.astmetrics.ClassData;

public class Main {
    public final String versionString = "2.3.0";
    private Date start;
    private Date finish;
    public String[] cmdLineArgs = new String[0];

    public Main(Singletons.Global g) {
    }

    public static Main v() {
        return G.v().soot_Main();
    }

    private void printVersion() {
        G.v().out.println("Habanero-Java Compiler (build " + Version.getVersion() + ")");
        G.v().out.println("Soot version 2.3.0");
        G.v().out.println("Copyright (C) 1997-2008 Raja Vallee-Rai and others.");
        G.v().out.println("All rights reserved.");
        G.v().out.println("");
        G.v().out.println("Contributions are copyright (C) 1997-2008 by their respective contributors.");
        G.v().out.println("See the file 'credits' for a list of contributors.");
        G.v().out.println("See individual source files for details.");
        G.v().out.println("");
        G.v().out.println("Soot comes with ABSOLUTELY NO WARRANTY.  Soot is free software,");
        G.v().out.println("and you are welcome to redistribute it under certain conditions.");
        G.v().out.println("See the accompanying file 'COPYING-LESSER.txt' for details.");
        G.v().out.println();
        G.v().out.println("Visit the Soot website:");
        G.v().out.println("  http://www.sable.mcgill.ca/soot/");
        G.v().out.println();
        G.v().out.println("For a list of command line options, enter:");
        G.v().out.println("  java soot.Main --help");
    }

    private void processCmdLine(String[] args) {
        if (!Options.v().parse(args)) {
            throw new CompilationDeathException(0, "Option parse error");
        }
        if (PackManager.v().onlyStandardPacks()) {
            for (Pack pack : PackManager.v().allPacks()) {
                Options.v().warnForeignPhase(pack.getPhaseName());
                Iterator trIt = pack.iterator();
                while (trIt.hasNext()) {
                    Transform tr = (Transform)trIt.next();
                    Options.v().warnForeignPhase(tr.getPhaseName());
                }
            }
        }
        Options.v().warnNonexistentPhase();
        if (Options.v().help()) {
            G.v().out.println(Options.v().getUsage());
            throw new CompilationDeathException(1);
        }
        if (Options.v().phase_list()) {
            G.v().out.println(Options.v().getPhaseList());
            throw new CompilationDeathException(1);
        }
        if (!Options.v().phase_help().isEmpty()) {
            for (String phase : Options.v().phase_help()) {
                G.v().out.println(Options.v().getPhaseHelp(phase));
            }
            throw new CompilationDeathException(1);
        }
        if (args.length == 0 || Options.v().version()) {
            this.printVersion();
            throw new CompilationDeathException(1);
        }
        this.postCmdLineCheck();
    }

    private void exitCompilation(int status) {
        this.exitCompilation(status, "");
    }

    private void exitCompilation(int status, String msg) {
        if (status == 0) {
            G.v().out.println("compilation failed: " + msg);
        }
    }

    private void postCmdLineCheck() {
        if (Options.v().classes().isEmpty() && Options.v().process_dir().isEmpty()) {
            throw new CompilationDeathException(0, "No input classes specified!");
        }
    }

    public static void main(String[] args) {
        int ret = Main.mainEntry(args);
        System.exit(ret);
    }

    public static int mainEntry(String[] args) {
        int ret = -1;
        try {
            ret = Main.v().run(args);
        }
        catch (OutOfMemoryError e) {
            G.v().out.println("Soot has run out of the memory allocated to it by the Java VM.");
            G.v().out.println("To allocate more memory to Soot, use the -Xmx switch to Java.");
            G.v().out.println("For example (for 400MB): java -Xmx400m soot.Main ...");
            throw e;
        }
        return ret == 1 ? 0 : 1;
    }

    public int run(String[] args) {
        this.cmdLineArgs = args;
        this.start = new Date();
        try {
            Timers.v().totalTimer.start();
            this.processCmdLine(this.cmdLineArgs);
            if (Options.v().info()) {
                G.v().out.println("Soot started on " + this.start);
            }
            Scene.v().loadNecessaryClasses();
            if (Options.v().ast_metrics()) {
                try {
                    FileOutputStream streamOut = new FileOutputStream("../astMetrics.xml");
                    PrintWriter writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
                    writerOut.println("<?xml version='1.0'?>");
                    writerOut.println("<ASTMetrics>");
                    for (ClassData cData : G.v().ASTMetricsData) {
                        writerOut.println(cData.toString());
                    }
                    writerOut.println("</ASTMetrics>");
                    writerOut.flush();
                    ((OutputStream)streamOut).close();
                }
                catch (IOException e) {
                    throw new CompilationDeathException("Cannot output file astMetrics");
                }
                this.exitCompilation(1);
                return 1;
            }
            PackManager.v().runPacks();
            PackManager.v().writeOutput();
            Timers.v().totalTimer.end();
            if (Options.v().time()) {
                Timers.v().printProfilingInformation();
            }
        }
        catch (CompilationDeathException e) {
            Timers.v().totalTimer.end();
            this.exitCompilation(e.getStatus(), e.getMessage());
            return e.getStatus();
        }
        this.finish = new Date();
        if (Options.v().info()) {
            G.v().out.println("Soot finished on " + this.finish);
            long runtime = this.finish.getTime() - this.start.getTime();
            G.v().out.println("Soot has run for " + runtime / 60000L + " min. " + runtime % 60000L / 1000L + " sec.");
        }
        this.exitCompilation(1);
        return 1;
    }
}

