/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.EmptyRegion;
import hj.array.Range;
import hj.array.Rectangular;
import hj.lang.Runtime;
import hj.lang.point;
import hj.lang.region;
import java.util.Iterator;

public class ContiguousRange
extends Range
implements Rectangular {
    public ContiguousRange(int hi) {
        this(0, hi);
    }

    public ContiguousRange(int lo, int hi) {
        super(lo, hi, hi - lo + 1);
        assert (lo <= hi);
    }

    public int ordinal(point p) {
        if (!this.contains(p)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return p.get(0) - this.lo;
    }

    public region union(region r) {
        assert (r != null);
        region ret = null;
        if (r instanceof ContiguousRange) {
            ContiguousRange cr = (ContiguousRange)r;
            if (this.contains(cr.lo) || this.contains(cr.hi)) {
                int l = this.lo < cr.lo ? this.lo : cr.lo;
                int h = this.hi > cr.hi ? this.hi : cr.hi;
                ret = new ContiguousRange(l, h);
            }
        }
        if (ret == null) {
            ret = super.union(r);
        }
        return ret;
    }

    public region intersection(region r) {
        region ret;
        assert (r != null);
        if (r instanceof ContiguousRange) {
            int h;
            ContiguousRange cr = (ContiguousRange)r;
            int l = this.lo > cr.lo ? this.lo : cr.lo;
            int n = h = this.hi < cr.hi ? this.hi : cr.hi;
            ret = l <= h ? new ContiguousRange(l, h) : new EmptyRegion(this.rank);
        } else {
            ret = super.intersection(r);
        }
        return ret;
    }

    public region difference(region r) {
        assert (r != null);
        region ret = null;
        if (r instanceof ContiguousRange) {
            ContiguousRange cr = (ContiguousRange)r;
            if (this.lo >= cr.lo && this.hi <= cr.hi) {
                ret = new EmptyRegion(this.rank);
            } else if (this.lo == cr.lo) {
                ret = new ContiguousRange(cr.hi + 1, this.hi);
            } else if (this.hi == cr.hi) {
                ret = new ContiguousRange(this.lo, cr.lo - 1);
            }
        }
        if (ret == null) {
            ret = super.difference(r);
        }
        return ret;
    }

    public boolean disjoint(region r) {
        boolean ret;
        assert (r != null);
        if (r instanceof ContiguousRange) {
            ContiguousRange cr = (ContiguousRange)r;
            ret = cr.hi < this.lo || this.hi < cr.lo;
        } else {
            ret = super.disjoint(r);
        }
        return ret;
    }

    public boolean contains(point p) {
        int val;
        boolean ret = p.rank == 1 ? this.lo <= (val = p.get(0)) && val <= this.hi : false;
        return ret;
    }

    public boolean contains(int[] p) {
        boolean ret;
        if (p.length == 1) {
            int val = p[0];
            ret = p.length == 1 && this.lo <= val && val <= this.hi;
        } else {
            ret = false;
        }
        return ret;
    }

    public boolean contains(region r) {
        boolean ret;
        assert (r != null);
        if (r instanceof ContiguousRange) {
            ContiguousRange cr = (ContiguousRange)r;
            ret = cr.lo >= this.lo && cr.hi <= this.hi;
        } else {
            ret = super.contains(r);
        }
        return ret;
    }

    public String toString() {
        return this.lo + ":" + this.hi;
    }

    public region[] partition(int n, int dim) {
        assert (n > 0);
        assert (dim == 0);
        region[] ret = new region[n];
        int all_size = this.size();
        int base = this.low();
        if (n == 1) {
            ret[0] = this;
        } else if (n >= all_size) {
            int i;
            for (i = 0; i < all_size; ++i) {
                ret[i] = new ContiguousRange(base, base);
                ++base;
            }
            while (i < n) {
                ret[i] = new EmptyRegion(1);
                ++i;
            }
        } else {
            int sub_size = all_size % n == 0 ? all_size / n : (all_size + all_size % n) / n;
            for (int i = 0; i < n; ++i) {
                int lo = base + i * sub_size;
                int hi = i < n - 1 ? lo + sub_size - 1 : base + all_size - 1;
                ret[i] = lo <= hi ? new ContiguousRange(lo, hi) : new EmptyRegion(1);
            }
        }
        return ret;
    }

    public boolean isConvex() {
        return true;
    }

    public region convexHull() {
        return this;
    }

    public int size() {
        return this.size;
    }

    public region rank(int index) {
        return this;
    }

    public point coord(int ord) {
        assert (ord < this.size());
        return Runtime.factory.getPointFactory().point(new int[]{ord + this.lo});
    }

    public Iterator iterator() {
        return new RegionIterator();
    }

    private class RegionIterator
    implements Iterator {
        private int next_;

        private RegionIterator() {
            this.next_ = ContiguousRange.this.lo;
        }

        public boolean hasNext() {
            return this.next_ <= ContiguousRange.this.hi;
        }

        public void remove() {
            throw new Error("not implemented");
        }

        public Object next() {
            assert (this.hasNext());
            int[] nArray = new int[]{this.next_++};
            point ret = Runtime.factory.getPointFactory().point(nArray);
            return ret;
        }
    }
}

