/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.Helper;
import hj.array.Operator;
import hj.array.lang.GenericReferenceArray;
import hj.array.lang.genericArray;
import hj.compilergenerated.Parameter1;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;
import hj.runtime.common.Configuration;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Iterator;

public abstract class GenericArray
extends GenericReferenceArray {
    protected final boolean refsToValues_;

    public GenericArray(dist d, boolean mutable, boolean refs_to_values) {
        super(d, mutable);
        this.refsToValues_ = refs_to_values;
    }

    protected abstract GenericArray newInstance(dist var1);

    protected abstract GenericArray newInstance(dist var1, Parameter1 var2);

    protected final GenericArray newInstance(dist d, Operator.Pointwise p) {
        GenericArray res = this.newInstance(d);
        if (p != null) {
            this.scan(res, p);
        }
        return res;
    }

    public abstract Parameter1 getOrdinal(int var1);

    public abstract Parameter1 setOrdinal(Parameter1 var1, int var2);

    public Parameter1 set(Parameter1 v, point pos) {
        return this.set(v, pos, true, true);
    }

    public Parameter1 set(Parameter1 v, point pos, boolean chkPl, boolean chkAOB) {
        if (Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(pos));
        }
        int theIndex = Helper.ordinal(this.distribution, pos, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public Parameter1 set(Parameter1 v, int d0) {
        return this.set(v, d0, true, true);
    }

    public Parameter1 set(Parameter1 v, int d0, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public Parameter1 set(Parameter1 v, int d0, int d1) {
        return this.set(v, d0, d1, true, true);
    }

    public Parameter1 set(Parameter1 v, int d0, int d1, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public Parameter1 set(Parameter1 v, int d0, int d1, int d2) {
        return this.set(v, d0, d1, d2, true, true);
    }

    public Parameter1 set(Parameter1 v, int d0, int d1, int d2, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public Parameter1 set(Parameter1 v, int d0, int d1, int d2, int d3) {
        return this.set(v, d0, d1, d2, d3, true, true);
    }

    public Parameter1 set(Parameter1 v, int d0, int d1, int d2, int d3, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2, d3));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, d3, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public Parameter1 get(point pos) {
        return this.get(pos, true, true);
    }

    public Parameter1 get(point pos, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(pos));
        }
        int theIndex = Helper.ordinal(this.distribution, pos, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public Parameter1 get(int d0) {
        return this.get(d0, true, true);
    }

    public Parameter1 get(int d0, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public Parameter1 get(int d0, int d1) {
        return this.get(d0, d1, true, true);
    }

    public Parameter1 get(int d0, int d1, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public Parameter1 get(int d0, int d1, int d2) {
        return this.get(d0, d1, d2, true, true);
    }

    public Parameter1 get(int d0, int d1, int d2, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public Parameter1 get(int d0, int d1, int d2, int d3) {
        return this.get(d0, d1, d2, d3, true, true);
    }

    public Parameter1 get(int d0, int d1, int d2, int d3, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2, d3));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, d3, chkAOB);
        return this.getOrdinal(theIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean valueEquals(Indexable other) {
        block9: {
            GenericArray o = (GenericArray)other;
            if (!o.distribution.equals(this.distribution)) {
                return false;
            }
            place here = Runtime.runtime.currentPlace();
            try {
                if (this.refsToValues_) {
                    Iterator it = this.distribution.region.iterator();
                    while (it.hasNext()) {
                        point pos = (point)it.next();
                        place pl = this.distribution.get(pos);
                        Runtime.runtime.setCurrentPlace(pl);
                        if (Runtime.equalsequals(this.get(pos), o.get(pos))) continue;
                        boolean bl = false;
                        return bl;
                    }
                    break block9;
                }
                Iterator it = this.distribution.region.iterator();
                while (it.hasNext()) {
                    point pos = (point)it.next();
                    place pl = this.distribution.get(pos);
                    Runtime.runtime.setCurrentPlace(pl);
                    if (this.get(pos) == o.get(pos)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                Runtime.runtime.setCurrentPlace(here);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assign(GenericArray rhs) {
        assert (rhs instanceof GenericArray);
        assert (rhs.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        GenericArray rhs_t = rhs;
        try {
            Iterator it = rhs_t.distribution.region.iterator();
            while (it.hasNext()) {
                point pos = (point)it.next();
                place pl = this.distribution.get(pos);
                Runtime.runtime.setCurrentPlace(pl);
                this.set(rhs_t.get(pos), pos);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointwise(GenericArray res, Operator.Pointwise op, GenericArray arg) {
        assert (res == null || res.distribution.equals(this.distribution));
        assert (arg != null);
        assert (arg.distribution.equals(this.distribution));
        GenericArray res_t = res;
        GenericArray arg_t = arg;
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                Parameter1 arg1 = this.get(p);
                Parameter1 arg2 = arg_t.get(p);
                Parameter1 val = op.apply(p, arg1, arg2);
                if (res_t == null) continue;
                res_t.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointwise(GenericArray res, Operator.Pointwise op) {
        assert (res == null || res.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                Parameter1 arg1 = this.get(p);
                Parameter1 val = op.apply(p, arg1);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduction(Operator.Reduction op) {
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                Parameter1 arg1 = this.get(p);
                op.apply(arg1);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(GenericArray res, Operator.Unary op) {
        assert (res == null || res instanceof GenericArray);
        assert (res.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        GenericArray res_t = res == null ? null : res;
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                Parameter1 arg1 = this.get(p);
                Parameter1 val = op.apply(arg1);
                if (res_t == null) continue;
                res_t.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(GenericArray res, Operator.Pointwise op) {
        assert (res == null || res instanceof GenericArray);
        assert (res.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        GenericArray res_t = res == null ? null : res;
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                Parameter1 val = op.apply(p, null);
                if (res_t == null) continue;
                res_t.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericReferenceArray lift(Operator.Binary op, genericArray arg) {
        assert (arg.distribution.equals(this.distribution));
        GenericArray result = this.newInstance(this.distribution);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                ((GenericReferenceArray)result).set(op.apply(this.get(p), arg.get(p)), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericReferenceArray lift(Operator.Unary op) {
        GenericArray result = this.newInstance(this.distribution);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                ((GenericReferenceArray)result).set(op.apply(this.get(p)), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameter1 reduce(Operator.Binary op, Parameter1 unit) {
        Parameter1 result = unit;
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                result = op.apply(this.get(p), result);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericReferenceArray scan(Operator.Binary op, Parameter1 unit) {
        Parameter1 temp = unit;
        GenericArray result = this.newInstance(this.distribution);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                temp = op.apply(this.get(p), temp);
                ((GenericReferenceArray)result).set(temp, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericReferenceArray overlay(genericArray d) {
        dist dist2 = this.distribution.overlay(d.distribution);
        GenericArray ret = this.newInstance(dist2, (Parameter1)null);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                Parameter1 val = d.distribution.region.contains(p) ? d.get(p) : this.get(p);
                ret.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(genericArray d) {
        assert (this.region.contains(d.region));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = d.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                this.set(d.get(p), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericReferenceArray union(genericArray d) {
        dist dist2 = this.distribution.union(d.distribution);
        GenericArray ret = this.newInstance(dist2, (Parameter1)null);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                Parameter1 val = this.distribution.region.contains(p) ? this.get(p) : d.get(p);
                ret.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    public GenericReferenceArray restriction(dist d) {
        return this.restriction(d.region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericReferenceArray restriction(region d) {
        dist dist2 = this.distribution.restriction(d);
        GenericArray ret = this.newInstance(dist2, (Parameter1)null);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                ret.set(this.get(p), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    public Object toJava() {
        final int[] dims_tmp = new int[this.distribution.rank];
        for (int i = 0; i < this.distribution.rank; ++i) {
            dims_tmp[i] = this.distribution.region.rank(i).high() + 1;
        }
        final Object ret = Array.newInstance(Parameter1.class, dims_tmp);
        this.pointwise(null, new Operator.Pointwise(){

            public Parameter1 apply(point p, Parameter1 arg) {
                int i;
                Object handle = ret;
                for (i = 0; i < dims_tmp.length - 1; ++i) {
                    handle = Array.get(handle, p.get(i));
                }
                Array.set(handle, p.get(i), arg);
                return arg;
            }
        });
        return ret;
    }

    public genericArray toValueArray() {
        if (!this.mutable_) {
            return this;
        }
        try {
            return (genericArray)this.clone();
        }
        catch (CloneNotSupportedException x) {
            throw new Error("TODO: <T>ReferenceArray --> <T>ValueArray");
        }
    }

    public static void printArray(String prefix, Object[][] a) {
        GenericArray.printArray(prefix, a, System.out);
    }

    public static void printArray(String prefix, Object[][] a, PrintStream out) {
        out.print(prefix + "{");
        for (int i = 0; i < a.length; ++i) {
            out.print("{");
            for (int j = 0; j < a[i].length; ++j) {
                out.print(a[i][j]);
                if (j >= a[i].length - 1) continue;
                out.print(", ");
            }
            out.print("}");
            if (i >= a.length - 1) continue;
            out.print(", ");
        }
        out.println("}");
    }
}

