/*
 * Decompiled with CFR 0.152.
 */
package hj.util;

import hj.runtime.wsh.Activity;
import hj.util.Epoc;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ConcurrentHashMap
extends java.util.concurrent.ConcurrentHashMap
implements Map,
Cloneable,
Serializable {
    protected transient Entry[] table;
    protected static final int CONCURRENCY_LEVEL = 32;
    protected static final int SEGMENT_MASK = 31;
    protected final Segment[] segments = new Segment[32];
    public static int DEFAULT_INITIAL_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 32;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected final float loadFactor;
    protected int threshold;
    protected volatile transient int votesForResize;
    protected transient Set keySet = null;
    protected transient Set entrySet = null;
    protected transient Collection values = null;

    protected static int bitcount(int w) {
        w -= (0xAAAAAAAA & w) >>> 1;
        w = (w & 0x33333333) + (w >>> 2 & 0x33333333);
        w = w + (w >>> 4) & 0xF0F0F0F;
        w += w >>> 8;
        w += w >>> 16;
        return w & 0xFF;
    }

    private int p2capacity(int initialCapacity) {
        int result;
        int cap = initialCapacity;
        if (cap > 0x40000000 || cap < 0) {
            result = 0x40000000;
        } else {
            for (result = 32; result < cap; result <<= 1) {
            }
        }
        return result;
    }

    protected static int hash(Object x) {
        int h = x.hashCode();
        return (h << 7) - h + (h >>> 9) + (h >>> 17);
    }

    protected boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    protected Entry[] newTable(int capacity) {
        this.threshold = (int)((float)capacity * this.loadFactor / 32.0f) + 1;
        return new Entry[capacity];
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor) {
        if (!(loadFactor > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment();
        }
        int cap = this.p2capacity(initialCapacity);
        this.table = this.newTable(cap);
    }

    public ConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ConcurrentHashMap() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f);
    }

    public ConcurrentHashMap(Map t) {
        this(Math.max((int)((float)t.size() / 0.75f) + 1, 32), 0.75f);
        this.putAll(t);
    }

    public int size() {
        int c = 0;
        for (int i = 0; i < this.segments.length; ++i) {
            c += this.segments[i].getCount();
        }
        return c;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i].getCount() == 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Segment seg;
        Entry first;
        int hash = ConcurrentHashMap.hash(key);
        Entry[] tab = this.table;
        int index = hash & tab.length - 1;
        Entry e = first = tab[index];
        while (e != null) {
            if (e.hash == hash && this.eq(key, e.key)) {
                Object value = e.value;
                if (value == null) break;
                return value;
            }
            e = e.next;
        }
        Segment segment = seg = this.segments[hash & 0x1F];
        synchronized (segment) {
            tab = this.table;
            index = hash & tab.length - 1;
            Entry newFirst = tab[index];
            if (e != null || first != newFirst) {
                e = newFirst;
                while (e != null) {
                    if (e.hash == hash && this.eq(key, e.key)) {
                        return e.value;
                    }
                    e = e.next;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObj(Object key, Epoc epoc) {
        Segment seg;
        Entry first;
        int hash = ConcurrentHashMap.hash(key);
        Entry[] tab = this.table;
        int index = hash & tab.length - 1;
        Entry e = first = tab[index];
        while (e != null) {
            if (e.hash == hash && this.eq(key, e.key)) {
                Object value = e.value;
                if (value == null) break;
                epoc.value = value;
                epoc.activity = e.activity;
                epoc.act_clock = e.act_clock;
                epoc.isWrite = e.isWrite;
                epoc.inLock = e.inLock;
                return value;
            }
            e = e.next;
        }
        Segment segment = seg = this.segments[hash & 0x1F];
        synchronized (segment) {
            tab = this.table;
            index = hash & tab.length - 1;
            Entry newFirst = tab[index];
            if (e != null || first != newFirst) {
                e = newFirst;
                while (e != null) {
                    if (e.hash == hash && this.eq(key, e.key)) {
                        epoc.value = e.value;
                        epoc.activity = e.activity;
                        epoc.act_clock = e.act_clock;
                        epoc.isWrite = e.isWrite;
                        epoc.inLock = e.inLock;
                        return e.value;
                    }
                    e = e.next;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInt(int hash, Epoc epoc) {
        Segment seg;
        Entry first;
        Entry[] tab = this.table;
        int index = hash & tab.length - 1;
        Entry e = first = tab[index];
        while (e != null) {
            if (e.hash == hash && hash == e.intKey) {
                Object value = e.value;
                if (value == null) break;
                epoc.value = value;
                epoc.activity = e.activity;
                epoc.act_clock = e.act_clock;
                epoc.isWrite = e.isWrite;
                epoc.inLock = e.inLock;
                return value;
            }
            e = e.next;
        }
        Segment segment = seg = this.segments[hash & 0x1F];
        synchronized (segment) {
            tab = this.table;
            index = hash & tab.length - 1;
            Entry newFirst = tab[index];
            if (e != null || first != newFirst) {
                e = newFirst;
                while (e != null) {
                    if (e.hash == hash && hash == e.intKey) {
                        epoc.value = e.value;
                        epoc.activity = e.activity;
                        epoc.act_clock = e.act_clock;
                        epoc.isWrite = e.isWrite;
                        epoc.inLock = e.inLock;
                        return e.value;
                    }
                    e = e.next;
                }
            }
            return null;
        }
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        int votes;
        int segcount;
        Entry[] tab;
        Segment seg;
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hash(key);
        Segment segment = seg = this.segments[hash & 0x1F];
        synchronized (segment) {
            Entry newEntry;
            Entry first;
            tab = this.table;
            int index = hash & tab.length - 1;
            Entry e = first = tab[index];
            while (e != null) {
                if (e.hash == hash && this.eq(key, e.key)) {
                    Object oldValue = e.value;
                    e.value = value;
                    return oldValue;
                }
                e = e.next;
            }
            tab[index] = newEntry = new Entry(hash, key, value, first);
            segcount = ++seg.count;
            if (seg.count < this.threshold) {
                return null;
            }
            votes = this.votesForResize;
            int bit = 1 << (hash & 0x1F);
            if ((votes & bit) == 0) {
                votes = this.votesForResize |= bit;
            }
        }
        if (ConcurrentHashMap.bitcount(votes) >= 8 || segcount > this.threshold * 32) {
            this.resize(0, tab);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putObj(Object key, Object value, Activity activity2, int act_clock, boolean isWrite, boolean inLock, Object checkValue) {
        int votes;
        int segcount;
        Entry[] tab;
        Segment seg;
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hash(key);
        Segment segment = seg = this.segments[hash & 0x1F];
        synchronized (segment) {
            Entry newEntry;
            Entry first;
            tab = this.table;
            int index = hash & tab.length - 1;
            Entry e = first = tab[index];
            while (e != null) {
                if (e.hash == hash && this.eq(key, e.key)) {
                    Object oldValue = e.value;
                    if (oldValue != checkValue) {
                        return null;
                    }
                    e.value = value;
                    e.activity = activity2;
                    e.act_clock = act_clock;
                    e.isWrite = isWrite;
                    e.inLock = inLock;
                    return value;
                }
                e = e.next;
            }
            tab[index] = newEntry = new Entry(hash, key, value, activity2, act_clock, isWrite, inLock, first);
            segcount = ++seg.count;
            if (seg.count < this.threshold) {
                return newEntry.value;
            }
            votes = this.votesForResize;
            int bit = 1 << (hash & 0x1F);
            if ((votes & bit) == 0) {
                votes = this.votesForResize |= bit;
            }
        }
        if (ConcurrentHashMap.bitcount(votes) >= 8 || segcount > this.threshold * 32) {
            this.resize(0, tab);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putInt(int hash, Object value, Activity activity2, int act_clock, boolean isWrite, boolean inLock, Object checkValue) {
        int votes;
        int segcount;
        Entry[] tab;
        Segment seg;
        if (value == null) {
            throw new NullPointerException();
        }
        Segment segment = seg = this.segments[hash & 0x1F];
        synchronized (segment) {
            Entry newEntry;
            Entry first;
            tab = this.table;
            int index = hash & tab.length - 1;
            Entry e = first = tab[index];
            while (e != null) {
                if (e.hash == hash && hash == e.intKey) {
                    Object oldValue = e.value;
                    if (oldValue != checkValue) {
                        return false;
                    }
                    e.value = value;
                    e.activity = activity2;
                    e.act_clock = act_clock;
                    e.isWrite = isWrite;
                    e.inLock = inLock;
                    return true;
                }
                e = e.next;
            }
            tab[index] = newEntry = new Entry(hash, hash, value, activity2, act_clock, isWrite, inLock, first);
            segcount = ++seg.count;
            if (seg.count < this.threshold) {
                return true;
            }
            votes = this.votesForResize;
            int bit = 1 << (hash & 0x1F);
            if ((votes & bit) == 0) {
                votes = this.votesForResize |= bit;
            }
        }
        if (ConcurrentHashMap.bitcount(votes) >= 8 || segcount > this.threshold * 32) {
            this.resize(0, tab);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resize(int index, Entry[] assumedTab) {
        Segment seg;
        Segment segment = seg = this.segments[index];
        synchronized (segment) {
            if (assumedTab == this.table) {
                int next = index + 1;
                if (next < this.segments.length) {
                    this.resize(next, assumedTab);
                } else {
                    this.rehash();
                }
            }
        }
    }

    protected void rehash() {
        this.votesForResize = 0;
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int newCapacity = oldCapacity << 1;
        Entry[] newTable = this.newTable(newCapacity);
        int mask = newCapacity - 1;
        for (int i = 0; i < oldCapacity; ++i) {
            int k;
            Entry e = oldTable[i];
            if (e == null) continue;
            int idx = e.hash & mask;
            Entry next = e.next;
            if (next == null) {
                newTable[idx] = e;
                continue;
            }
            Entry lastRun = e;
            int lastIdx = idx;
            Entry last = next;
            while (last != null) {
                k = last.hash & mask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last;
                }
                last = last.next;
            }
            newTable[lastIdx] = lastRun;
            Entry p = e;
            while (p != lastRun) {
                k = p.hash & mask;
                newTable[k] = new Entry(p.hash, p.key, p.value, newTable[k]);
                p = p.next;
            }
        }
        this.table = newTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        for (int s = 0; s < this.segments.length; ++s) {
            Entry[] tab;
            Segment seg;
            Segment segment = seg = this.segments[s];
            synchronized (segment) {
                tab = this.table;
            }
            for (int i = s; i < tab.length; i += this.segments.length) {
                Entry e = tab[i];
                while (e != null) {
                    if (value.equals(e.value)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        while (true) {
            int max;
            Entry[] tab;
            Segment segment = this.segments[0];
            synchronized (segment) {
                tab = this.table;
                max = this.threshold * 32;
            }
            if (n < max) break;
            this.resize(0, tab);
        }
        for (Map.Entry entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (int s = 0; s < this.segments.length; ++s) {
            Segment seg;
            Segment segment = seg = this.segments[s];
            synchronized (segment) {
                Entry[] tab = this.table;
                for (int i = s; i < tab.length; i += this.segments.length) {
                    Entry e = tab[i];
                    while (e != null) {
                        e.value = null;
                        e = e.next;
                    }
                    tab[i] = null;
                    seg.count = 0;
                }
                continue;
            }
        }
    }

    public Object clone() {
        return new ConcurrentHashMap((Map)this);
    }

    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public Enumeration keys() {
        return new KeyIterator();
    }

    public Enumeration elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        int cap;
        s.defaultWriteObject();
        Segment segment = this.segments[0];
        synchronized (segment) {
            cap = this.table.length;
        }
        s.writeInt(cap);
        for (int k = 0; k < this.segments.length; ++k) {
            Entry[] tab;
            Segment seg;
            Segment segment2 = seg = this.segments[k];
            synchronized (segment2) {
                tab = this.table;
            }
            for (int i = k; i < tab.length; i += this.segments.length) {
                Entry e = tab[i];
                while (e != null) {
                    s.writeObject(e.key);
                    s.writeObject(e.value);
                    e = e.next;
                }
            }
        }
        s.writeObject(null);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int cap = s.readInt();
        this.table = this.newTable(cap);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment();
        }
        while (true) {
            Object key = s.readObject();
            Object value = s.readObject();
            if (key == null) break;
            this.put(key, value);
        }
    }

    protected class ValueIterator
    extends HashIterator {
        protected ValueIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentValue;
        }
    }

    protected class KeyIterator
    extends HashIterator {
        protected KeyIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentKey;
        }
    }

    protected class HashIterator
    implements Iterator,
    Enumeration {
        protected final Entry[] tab;
        protected int index;
        protected Entry entry = null;
        protected Object currentKey;
        protected Object currentValue;
        protected Entry lastReturned = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HashIterator() {
            Segment segment = ConcurrentHashMap.this.segments[0];
            synchronized (segment) {
                this.tab = ConcurrentHashMap.this.table;
            }
            for (int i = 1; i < ConcurrentHashMap.this.segments.length; ++i) {
                ConcurrentHashMap.this.segments[i].synch();
            }
            this.index = this.tab.length - 1;
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.next();
        }

        public boolean hasNext() {
            do {
                if (this.entry != null) {
                    Object v = this.entry.value;
                    if (v != null) {
                        this.currentKey = this.entry.key;
                        this.currentValue = v;
                        return true;
                    }
                    this.entry = this.entry.next;
                }
                while (this.entry == null && this.index >= 0) {
                    this.entry = this.tab[this.index--];
                }
            } while (this.entry != null);
            this.currentValue = null;
            this.currentKey = null;
            return false;
        }

        protected Object returnValueOfNext() {
            return this.entry;
        }

        public Object next() {
            if (this.currentKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this.returnValueOfNext();
            this.lastReturned = this.entry;
            this.currentValue = null;
            this.currentKey = null;
            this.entry = this.entry.next;
            return result;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    protected static class Entry
    implements Map.Entry {
        protected final Object key;
        protected final int intKey;
        protected volatile Object value;
        protected volatile Activity activity;
        protected volatile int act_clock;
        protected volatile boolean isWrite;
        protected volatile boolean inLock;
        protected final int hash;
        protected final Entry next;

        Entry(int hash, Object key, Object value, Entry next) {
            this.value = value;
            this.hash = hash;
            this.key = key;
            this.intKey = -1;
            this.next = next;
        }

        Entry(int hash, Object key, Object value, Activity activity2, int act_clock, boolean isWrite, boolean inLock, Entry next) {
            this.hash = hash;
            this.value = value;
            this.activity = activity2;
            this.act_clock = act_clock;
            this.isWrite = isWrite;
            this.inLock = inLock;
            this.key = key;
            this.intKey = -1;
            this.next = next;
        }

        Entry(int hash, int intKey, Object value, Activity activity2, int act_clock, boolean isWrite, boolean inLock, Entry next) {
            this.hash = hash;
            this.value = value;
            this.activity = activity2;
            this.act_clock = act_clock;
            this.isWrite = isWrite;
            this.inLock = inLock;
            this.key = null;
            this.intKey = intKey;
            this.next = next;
        }

        public Object getKey() {
            return this.key;
        }

        public int getIntKey() {
            return this.intKey;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (this.key != null) {
                return this.key.equals(e.getKey()) && this.value.equals(e.getValue());
            }
            return this.intKey == ((Entry)e).intKey && this.value.equals(e.getValue());
        }

        public int hashCode() {
            if (this.key != null) {
                return this.key.hashCode() ^ this.value.hashCode();
            }
            return this.intKey ^ this.value.hashCode();
        }

        public String toString() {
            if (this.key != null) {
                return this.key + "=" + this.value;
            }
            return this.intKey + "=" + this.value;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new HashIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object v = ConcurrentHashMap.this.get(entry.getKey());
            return v != null && v.equals(entry.getValue());
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public boolean contains(Object o) {
            return ConcurrentHashMap.this.containsValue(o);
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public boolean contains(Object o) {
            return ConcurrentHashMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return ConcurrentHashMap.this.remove(o) != null;
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    protected static final class Segment
    implements Serializable {
        protected int count;

        protected Segment() {
        }

        protected synchronized int getCount() {
            return this.count;
        }

        protected synchronized void synch() {
        }
    }
}

