/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import java.util.ListIterator;
import polyglot.ast.ClassBody_c;
import polyglot.ast.Formal_c;
import polyglot.ast.MethodDecl;
import polyglot.ast.MethodDecl_c;
import polyglot.ast.Node;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.ClassType_c;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.visit.TypeChecker;

public class HjClassBody_c
extends ClassBody_c {
    public HjClassBody_c(Position pos, List members) {
        super(pos, members);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjClassBody_c result = (HjClassBody_c)super.typeCheck(tc);
        HjTypeSystem xts = (HjTypeSystem)tc.typeSystem();
        ClassBody_c cb = (ClassBody_c)result.node();
        ListIterator i = cb.members().listIterator();
        while (i.hasNext()) {
            MethodDecl_c md;
            MethodInstance mi;
            Object o = i.next();
            if (!(o instanceof MethodDecl) || !(mi = (md = (MethodDecl_c)o).methodInstance()).flags().isNative()) continue;
            if (!mi.returnType().isPrimitive()) {
                throw new SemanticException("extern return type \"" + mi.returnType() + "\" is not a primitive type.", md.position());
            }
            ListIterator j = md.formals().listIterator();
            while (j.hasNext()) {
                Formal_c parameter = (Formal_c)j.next();
                if (parameter.declType().isPrimitive()) continue;
                boolean isOk = true;
                if (parameter.declType().isArray()) {
                    isOk = false;
                } else {
                    ClassType_c ct = (ClassType_c)parameter.declType().toClass();
                    isOk = xts.isHjArrayView((Type)ct);
                }
                if (isOk) continue;
                throw new SemanticException(parameter + ":parameters to extern calls must be either Hj arrays or primitives.", parameter.position());
            }
        }
        return result;
    }
}

