/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassDecl_c;
import polyglot.ast.ClassMember;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjClassDecl;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.PropertyDecl;
import polyglot.ext.hj.ast.PropertyDecl_c;
import polyglot.ext.hj.ast.TypeDecl;
import polyglot.ext.hj.ast.ValueClassDecl_c;
import polyglot.ext.hj.types.HjFlags;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Flags;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjClassDecl_c
extends ClassDecl_c
implements TypeDecl,
HjClassDecl {
    protected TypeNode classInvariant;

    public static TypeDecl make(Position pos, Flags flags, Id name, List<PropertyDecl> properties, TypeNode tci, TypeNode superClass, List interfaces, ClassBody body, HjNodeFactory nf, boolean valueClass) {
        boolean isInterface = flags.isInterface();
        ClassBody classBody = body = flags.isInterface() ? PropertyDecl_c.addGetters(properties, body, nf) : PropertyDecl_c.addProperties(properties, body, nf);
        if (tci != null) {
            body = HjClassDecl_c.addCI(tci, body, nf);
        }
        ClassDecl_c result = valueClass ? new ValueClassDecl_c(pos, flags, name, tci, superClass, interfaces, body, nf) : new HjClassDecl_c(pos, flags, name, tci, superClass, interfaces, body);
        return result;
    }

    protected HjClassDecl_c(Position pos, Flags flags, Id name, TypeNode tci, TypeNode superClass, List interfaces, ClassBody body) {
        super(pos, flags, name, superClass, interfaces, body);
        this.classInvariant = tci;
    }

    @Override
    public TypeNode classInvariant() {
        return this.classInvariant;
    }

    public static ClassBody addCI(TypeNode tn, ClassBody body, HjNodeFactory nf) {
        HjTypeSystem ts = (HjTypeSystem)nf.extensionInfo().typeSystem();
        Position pos = tn.position();
        PropertyDecl_c f = new PropertyDecl_c(pos, Flags.PUBLIC.Static().Final(), tn, nf.Id(pos, "classInvariant$"), (Expr)nf.NullLit(pos), nf);
        body = body.addMember((ClassMember)f);
        return body;
    }

    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        ParsedClassType type = (tb = tb.pushClass(this.position(), this.flags, this.name.id())).currentClass();
        if (type.isMember() && type.outer().flags().isInterface()) {
            type.flags(type.flags().Public().Static());
        }
        if (type.isMember() && type.flags().isInterface()) {
            type.flags(type.flags().Static());
        }
        if (type.flags().isInterface()) {
            type.flags(type.flags().Abstract());
        }
        return tb;
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        ClassDecl n = (ClassDecl)super.disambiguate(ar);
        HjFlags xf = HjFlags.toHjFlags(n.flags());
        if (xf.isSafe()) {
            ClassBody b = n.body();
            List m = b.members();
            int count = m.size();
            ArrayList<ClassMember> newM = new ArrayList<ClassMember>(count);
            for (int i = 0; i < count; ++i) {
                ClassMember mem = (ClassMember)m.get(i);
                if (mem instanceof MethodDecl) {
                    MethodDecl decl = (MethodDecl)mem;
                    HjFlags mxf = HjFlags.toHjFlags(decl.flags()).Safe();
                    mem = decl.flags((Flags)mxf);
                }
                newM.add(mem);
            }
            n = n.body(b.members(newM));
        }
        return n;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjClassDecl_c result = (HjClassDecl_c)super.typeCheck(tc);
        if (this.type instanceof HjParsedClassType) {
            HjParsedClassType xpType = (HjParsedClassType)this.type;
            xpType.checkRealClause();
        }
        return result;
    }
}

