/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.LocalDecl_c;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjVarDecl;
import polyglot.ext.hj.types.HjArrayType;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjLocalInstance;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class HjLocalDecl_c
extends LocalDecl_c
implements HjVarDecl {
    public HjLocalDecl_c(Position pos, Flags flags, TypeNode type, Id name, Expr init) {
        super(pos, flags, type, name, init);
    }

    public boolean isDisambiguated() {
        return (this.type == null || this.type.isDisambiguated()) && this.li != null && this.li.isCanonical() && super.isDisambiguated();
    }

    public String shortToString() {
        return "<HjLocalDecl_c #" + this.hashCode() + (this.type() == null ? "" : " <TypeNode #" + this.type().hashCode() + "type=" + this.type().type() + ">") + " name=|" + this.name() + "|" + (this.init() == null ? "" : " <Expr #" + this.init().hashCode() + ">") + (this.localInstance() == null ? "" : " <LocalInstance #" + this.localInstance().hashCode() + ">") + ">";
    }

    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        Context c = tc.context();
        LocalInstance outerLocal = null;
        try {
            outerLocal = c.findLocal(this.li.name());
        }
        catch (SemanticException e) {
            // empty catch block
        }
        if (outerLocal != null) {
            throw new SemanticException("Local variable \"" + this.name + "\" multiply defined.  " + "Previous definition at " + outerLocal.position() + ".", this.position());
        }
        return tc;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjLocalDecl_c result = (HjLocalDecl_c)super.typeCheck(tc);
        ((HjLocalInstance)result.li).setSelfClauseIfFinal();
        Type typeToCheck = this.type().type();
        if (this.type().type() instanceof HjArrayType) {
            HjArrayType array = (HjArrayType)this.type().type();
            typeToCheck = array.base();
        }
        if (((HjTypeSystem)tc.typeSystem()).isFuture(typeToCheck) && !this.flags().isFinal()) {
            throw new SemanticException("Futures must be declared as final", this.position());
        }
        return result.type(this.type().type(this.li.type()));
    }

    public HjLocalDecl_c pickUpTypeFromTypeNode(TypeChecker tc) {
        HjLocalInstance xli = (HjLocalInstance)this.li;
        HjType newType = (HjType)this.type.type();
        xli.setType(newType);
        xli.setSelfClauseIfFinal();
        return (HjLocalDecl_c)this.type(this.type().type(xli.type()));
    }

    public Context enterChildScope(Node child, Context c) {
        HjContext cxt = (HjContext)c;
        if (child == this.type) {
            TypeSystem ts = c.typeSystem();
            LocalInstance li = this.localInstance();
            cxt.addVariable((VarInstance)li);
            cxt.setVarWhoseTypeIsBeingElaborated((VarInstance)this.localInstance());
        }
        Context cc = super.enterChildScope(child, c);
        return cc;
    }
}

