/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Loop;
import polyglot.ast.Loop_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.HjFormal;
import polyglot.ext.hj.ast.HjLoop;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public abstract class HjLoop_c
extends Loop_c
implements HjLoop,
Loop {
    protected Formal formal;
    protected Expr domain;
    protected Stmt body;
    protected List locals;

    protected HjLoop_c(Position pos) {
        super(pos);
    }

    protected HjLoop_c(Position pos, Formal formal, Expr domain, Stmt body) {
        super(pos);
        this.formal = formal;
        this.domain = domain;
        this.body = body;
    }

    protected HjLoop_c reconstruct(Formal formal, Expr domain, Stmt body) {
        if (formal != this.formal || domain != this.domain || body != this.body) {
            HjLoop_c n = (HjLoop_c)this.copy();
            n.formal = formal;
            n.domain = domain;
            n.body = body;
            return n;
        }
        return this;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        NodeFactory nf = tc.nodeFactory();
        Expr newDomain = this.domain;
        if (ts.isHjArrayView(newDomain.type())) {
            newDomain = (Expr)nf.Field(this.position(), (Receiver)this.domain, nf.Id(this.position(), "region")).del().typeCheck(tc);
        }
        if (!ts.isRegion(newDomain.type())) {
            throw new SemanticException("Hj loop domain must be an arrayview or a region not a " + newDomain.type());
        }
        HjFormal hjFormal = (HjFormal)this.formal;
        if (!hjFormal.isUnnamed() && hjFormal.vars().size() != 0) {
            throw new SemanticException("Invalid point declaration, uss 'point p' or 'point[i,...,k]' notation");
        }
        return this.domain(newDomain);
    }

    public Term entry() {
        return this.formal.entry();
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG((Term)this.formal, this.domain.entry());
        v.visitCFG((Term)this.domain, this.body.entry());
        v.visitCFG((Term)this.body, (Term)this);
        return succs;
    }

    public Context enterScope(Context c) {
        return c.pushBlock();
    }

    public Node visitChildren(NodeVisitor v) {
        Formal formal = (Formal)this.visitChild((Node)this.formal, v);
        Expr domain = (Expr)this.visitChild((Node)this.domain, v);
        Stmt body = (Stmt)this.visitChild((Node)this.body, v);
        return this.reconstruct(formal, domain, body);
    }

    public Stmt body() {
        return this.body;
    }

    public Formal formal() {
        return this.formal;
    }

    public Expr domain() {
        return this.domain;
    }

    public List locals() {
        return this.locals == null ? Collections.EMPTY_LIST : this.locals;
    }

    public HjLoop body(Stmt body) {
        HjLoop_c n = (HjLoop_c)this.copy();
        n.body = body;
        return n;
    }

    public HjLoop formal(Formal formal) {
        HjLoop_c n = (HjLoop_c)this.copy();
        n.formal = formal;
        return n;
    }

    public HjLoop domain(Expr domain) {
        HjLoop_c n = (HjLoop_c)this.copy();
        n.domain = domain;
        return n;
    }

    public HjLoop locals(List locals) {
        HjLoop_c n = (HjLoop_c)this.copy();
        n.locals = locals;
        return n;
    }

    public Term continueTarget() {
        return this.formal.entry();
    }

    public Expr cond() {
        return null;
    }
}

