import java.io.*;
import java.util.*;
import java.util.zip.GZIPInputStream;

public class Boruvka {
		
    static public long runtime;

    public static void main(String[] argv) {
	main(argv[0]);
    }

    public static void main(String filename)
    {
	Loader.read(filename); // Exclude file input from timing measurement
	long start = System.nanoTime();
	Component n;
        // START OF EDGE CONTRACTION ALGORITHM
	while ((n = Loader.nodesLoaded.poll()) != null) {
            // poll() removes first element (node n) from the nodesLoaded work-list
	    if (n.isDead) continue; // node n has already been merged
	    Edge e = n.getMinEdge(); // retrieve n's edge with minimum cost
	    if (e==null) break; // done - we've contracted the graph to a single node
	    Component other = e.getOther(n);
	    other.isDead = true;
	    n.merge(other, e.weight); // merge node other into node n
	    Loader.nodesLoaded.add(n); // add newly merged n back in the work-list
	}
        // END OF EDGE CONTRACTION ALGORITHM
	runtime = System.nanoTime() - start;
	System.out.println("Finished with edges = " +  n.totalEdges + ",  total weight = " + n.totalWeight + ", time = " + (runtime /1000000000.0) + " seconds");
    }
} // class Boruvka

class Loader
{
    static Map<Integer, Component> nodes = new  HashMap<Integer, Component>();
    static Map<Pair<Integer,Integer>, Edge> edges = new HashMap<Pair<Integer,Integer>, Edge>();
    static Queue<Component> nodesLoaded = new LinkedList<Component>();

    static Component getComponent(int node) {
	if (!nodes.containsKey(node))
	    nodes.put(node, new Component());
	return nodes.get(node);
    }
	
    static void addEdge(int from, int to,  Component fromC, Component toC, double w)
    {
	Pair<Integer,Integer> p;
	if (from < to)
	    p = new Pair<Integer,Integer>(from, to);
	else 
	    p = new Pair<Integer,Integer>(to, from);
	if (!edges.containsKey(p)) {
	    Edge e = new Edge(fromC, toC, w);
	    edges.put(p, e);
	    fromC.addEdge(e);
	    toC.addEdge(e);
	}
	else
	    assert(edges.get(p).weight == w);
    }
	
    static void read(String filename)
    {
	System.out.println("Sequential version (seq): Reading " + filename);	
	double totweight = 0;		
	int edges = 0;
	try {
	    // Open the compressed file
	    GZIPInputStream in = new GZIPInputStream(new FileInputStream(filename));
	    Reader r = new BufferedReader(new InputStreamReader(in));
	    StreamTokenizer st =new StreamTokenizer(r);
	    String cstring = "c";
	    String pstring = "p";
	    st.commentChar(cstring.charAt(0));
	    st.commentChar(pstring.charAt(0));
	    // read graph
	    while (st.nextToken() != StreamTokenizer.TT_EOF) {
		assert(st.sval.equals("a"));
		st.nextToken();
		int from =  (int) st.nval;
		st.nextToken();
		int to = (int) st.nval;
		Component nodeFrom = getComponent(from);
		Component nodeTo = getComponent(to);
		assert(nodeTo != nodeFrom); // Assume no self-loops in the input graph
		st.nextToken();
		int weight = (int) st.nval;
		addEdge(from, to, nodeFrom, nodeTo, weight);
		totweight += weight;
		edges++;
	    }
	    // Close the file and stream
	    in.close();
	} catch (IOException e) {
	    e.printStackTrace();
	}
	
	List<Component> nd = new ArrayList<Component>();
	nd.addAll(nodes.values());
	Collections.shuffle(nd);
	nodesLoaded.addAll(nd);
	nodes.clear();
	Loader.edges.clear();
		
	System.out.println("loaded " + nodesLoaded.size() + " - edges "+ edges + "- total weight " + totweight);
    }
} // class Loader


