import java.util.*;

class Edge implements Comparable<Edge>
{
	//int fromNode, toNode;
	Component fromComponent, toComponent;
	public double weight;
	
	
	public static class EdgeComparator implements Comparator<Edge> 
	{
		public int compare(Edge e1, Edge e2)
		{
			if (e1.weight == e2.weight)
				return 0;
			else if (e1.weight < e2.weight)
					return -1;
			else return 1;
		}
	}
	
	public Edge( /*int fromN, int toN,*/ Component from, Component to, double weight)
	{
		//this.fromNode = fromN;
		//this.toNode = toN;
		this.fromComponent = from;
		this.toComponent = to;

		this.weight = weight;
	}
	
	public Component getOther(Component from)
	{
		if (fromComponent == from)
		{
			assert(toComponent != from);
			return toComponent;
		}

		if (toComponent == from)
		{
			assert(fromComponent != from);
			return fromComponent;
		}
		assert(false);
		return null;

	}
	
	public int compareTo(Edge e)
	{
		if (e.weight == weight)
			return 0;
		else if (weight < e.weight)
				return -1;
		else return 1;
	}
	
	
	public Edge replaceComponent(Component from, Component to)
	{
		if (fromComponent == from )
			fromComponent = to;
		if (toComponent == from)
			toComponent = to;
		return this;
	}
	

	
}
