package edu.rice.linpack.LNumber;
import edu.rice.linpack.util.*;

public class LCDouble extends LComplex {

  private double data;
  private double imag;
  
  public LCDouble() {
    data = 0;
    imag = 0;
  }
  public LCDouble(LCDouble S) {
    data = S.data;
    imag = S.imag;
  }
  public LCDouble(double d,double c) {
    data = d;
    imag = c;
  }

  public static LNumber[] makeArray(double[] f, double[] c) {
    int l = f.length;
    LNumber[] N = new LNumber[l];
    for(int i=0;i<l;i++) {
      N[i] = new LCDouble(f[i],c[i]);
    }
    return N;
  }
  public static LNumber[][] makeMatrix(double[][] f, double[][] c) {
    int l = f.length;
    int q = f[0].length;
    LNumber[][] N = new LNumber[l][q];
    for(int i=0;i<l;i++) {
      for(int j=0;j<q;j++) {
	N[i][j] = new LCDouble(f[i][j],c[i][j]);
      }
    }
    return N;
  }
  public static void getArray(LCDouble[] N, double[] f, double[] c) {
    int l = N.length;
    for(int i=0;i<l;i++) {
      f[i] = N[i].data;
      c[i] = N[i].imag;
    }
  }
  public static void getMatrix(LCDouble[][] N, double[][] f, double[][] c) {
    int l = N.length;
    if(l > 0) {
      int q = N[0].length;
      for(int i=0;i<l;i++) {
	for(int j=0;j<q;j++) { 
	  f[i][j] = N[i][j].data;
	  c[i][j] = N[i][j].imag;
	}
      }
    }
  }

  public double getReal() {
    return (double)data;
  }
  public double getImag() {
    return (double)imag;
  }
  public void setOne() {
    data = 1;
    imag = 0;
  }
  public void setZero() {
    data = 0;
    imag = 0;
  }
  void set(int i) {
    data = i;
    imag = 0;
  }
  void set(LNumber N) {
    data = ((LCDouble)N).data;
    imag = ((LCDouble)N).imag;
  }
  void set(double d, double i) {
    data = d;
    imag = i;
  }

  public void Print() {
    System.out.print(data+" + "+imag+"i   ");
  }  
  public String toString() {
    return (""+data+" + "+imag+"i");
  }

  public LNumber mult(LNumber N) {
    return new LCDouble((data * ((LCDouble)N).data)-
		       (imag * ((LCDouble)N).imag), 
		       (data * ((LCDouble)N).imag)+
		       (imag * ((LCDouble)N).data));
  }
  public LNumber mult(int i) {
    return new LCDouble(data*i,imag*i);
  }
  public void multTo(LNumber N) {
    double d = data*((LCDouble)N).data - imag*((LCDouble)N).imag; 
    imag = data*((LCDouble)N).imag + imag*((LCDouble)N).data;
    data = d;
  }
  public void multTo(int i) {
    data *= i;
    imag *= i;
  }
  public LNumber div(LNumber N) {
    double a = ((LCDouble)N).data;
    double b = ((LCDouble)N).imag;
    double denom = Math.pow(a,2) + Math.pow(b,2);
    return new LCDouble((a*data + b*imag)/denom,(a*imag - b*data)/denom);
  }
  public LNumber div(int i) {
    return new LCDouble(data/i,imag/i);
  }
  public void divTo(LNumber N) {
    double a = ((LCDouble)N).data;
    double b = ((LCDouble)N).imag;
    double denom = a*a + b*b;
    double d = (a*data + b*imag)/denom;
    imag = (a*imag - b*data)/denom;
    data = d;
  }
  public void divTo(int i) {
    data /= i;
    imag /= i;
  }
  public LNumber divides(LNumber N) {
    double c = ((LCDouble)N).data;
    double d = ((LCDouble)N).imag;
    double denom = Math.pow(data,2) + Math.pow(imag,2);
    return new LCDouble((c*data + d*imag)/denom,(d*data - c*imag)/denom);   
  }
  public LNumber divides(int i) {
    double denom = data*data + imag*imag;
    return new LCDouble(i*data/denom,-i*imag/denom);
  }
  public LNumber add(LNumber N) {
    return new LCDouble(data + ((LCDouble)N).data,imag + ((LCDouble)N).imag);
  }
  public LNumber add(int i) {
    return new LCDouble(data+i,imag);
  }
  public void addTo(LNumber N) {
    data += ((LCDouble)N).data;
    imag += ((LCDouble)N).imag;
  }
  public void addTo(double d) {
    data += d;
  }
  public void addTo(int i) {
    data += i;
  }
  public LNumber sub(LNumber N) {
    return new LCDouble(data - ((LCDouble)N).data,imag - ((LCDouble)N).imag);
  }
  public LNumber sub(int i) {
    return new LCDouble(data-i,imag);
  }
  public void subTo(LNumber N) {
    data -= ((LCDouble)N).data;
    imag -= ((LCDouble)N).imag;
  }
  public void subTo(int i) {
    data -= i;
  }
  public LNumber subFrom(LNumber N) {
    return new LCDouble(((LCDouble)N).data - data,((LCDouble)N).imag - imag);
  }
  public LNumber subFrom(int i) {
    return new LCDouble(i-data,-imag);
  }
  public LNumber abs() {
    return new LCDouble(Math.abs(data) + Math.abs(imag),0);
  }
  public LNumber modulus() {
    return new LCDouble(Math.sqrt(data*data + imag*imag),0);
  }
  //  public LNumber timesSign(LNumber N) {
  //  return (this.modulus()).mult(((LCDouble)N).div(N.modulus()));
  //}
  public boolean equals(LNumber N) {
    return (data == ((LCDouble)N).data && imag == ((LCDouble)N).imag);
  }
  public boolean equals(int i) {
    return (data == i && imag == 0);
  }
  public LNumber negate() {
    return new LCDouble(-data,-imag);
  }
  public LNumber negateTo() {
    data = -data;
    imag = -imag;
    return this;
  }
  public LNumber pplus() {
    data++;
    return this;
  }

  public LNumber max(LNumber m) {
    if(this.greaterThan(m))
      return this;
    return m;
  }
  public void maxTo(LNumber m) {
    if(!this.greaterThan(m)) {
      data = ((LCDouble)m).data;
      imag = ((LCDouble)m).imag;
    }
  }
  
  public boolean greaterThan(LNumber N) {
    return (data > ((LCDouble)N).data);
  }
  public boolean greaterThan(int d) {
    return (data > d);
  }
  public boolean lessThan(LNumber N) {
    return (data < ((LCDouble)N).data);
  }
  public boolean lessThan(int d) {
    return (data < d);
  }
  public boolean greaterOrEqual(LNumber N) {
    if(data > ((LCDouble)N).data)
      return true;
    else if(this.equals((LCDouble)N))
      return true;
    return false;
  }
  public boolean greaterOrEqual(int d) {
    if (data > d)
      return true;
    else if (data == d && imag == 0)
      return true;
    return false;
  }
   public boolean lessOrEqual(LNumber N) {
    if(data < ((LCDouble)N).data)
      return true;
    else if(this.equals((LCDouble)N))
      return true;
    return false;
  }
  public boolean lessOrEqual(int d) {
    if (data < d)
      return true;
    else if (data == d && imag == 0)
      return true;
    return false;
  }
 
  public LNumber sqrt() {
    double a = Math.sqrt(.5*((data)+Math.sqrt(data*data+imag*imag)));
    return new LCDouble(a,imag/(2*a));
  }
  public LNumber square() {
    return this.mult(this);
  }
  public LNumber inv() {
    double div = (data*data)+(imag*imag);
    return new LCDouble(data/div,-imag/div);
  }
  public LNumber invTo() {
    double div = (data*data)+(imag*imag);
    data = data/div;
    imag = -imag/div;
    return this;
  }
  public void ssq(LNumber SQ, LNumber Scale) {
    if(data != 0) {
      LCDouble temp = new LCDouble(Math.abs(data),0);
      if(Scale.lessThan(temp)) {
	SQ.set(SQ.mult(((Scale.div(temp)).square())).pplus());
	Scale.set(temp);
      }
      else
	SQ.addTo((temp.div(Scale)).square());
    }
    if(imag != 0) {
      LCDouble temp = new LCDouble(Math.abs(imag),0);
      if(Scale.lessThan(temp)) {
	SQ.set(SQ.mult(((Scale.div(temp)).square())).pplus());
	Scale.set(temp);
      }
      else
	SQ.addTo((temp.div(Scale)).square());
    }
  }
}
