package edu.rice.linpack.LNumber;
import edu.rice.linpack.util.*;

public class LCFloat extends LComplex {

  private float data;
  private float imag;
  
  public LCFloat() {
    data = 0;
    imag = 0;
  }
  public LCFloat(LCFloat S) {
    data = S.data;
    imag = S.imag;
  }
  public LCFloat(float d,float c) {
    data = d;
    imag = c;
  }

  public static LNumber[] makeArray(float[] f, float[] c) {
    int l = f.length;
    LNumber[] N = new LNumber[l];
    for(int i=0;i<l;i++) {
      N[i] = new LCFloat(f[i], c[i]);
    }
    return N;
  }
  public static LNumber[][] makeMatrix(float[][] f, float[][] c) {
    int l = f.length;
    int q = f[0].length;
    LNumber[][] N = new LNumber[l][q];
    for(int i=0;i<l;i++) {
      for(int j=0;j<q;j++) {
	N[i][j] = new LCFloat(f[i][j], c[i][j]);
      }
    }
    return N;
  }
  public static void getArray(LCFloat[] N, float[] f, float[] c) {
    int l = N.length;
    for(int i=0;i<l;i++) {
      f[i] = N[i].data;
      c[i] = N[i].imag;
    }
  }
  public static void getMatrix(LCFloat[][] N, float[][] f, float[][] c) {
    int l = N.length;
    if(l > 0) {
      int q = N[0].length;
      for(int i=0;i<l;i++) {
	for(int j=0;j<q;j++) {
	  f[i][j] = N[i][j].data;
	  c[i][j] = N[i][j].imag;
	}
      }
    }
  }

  public float getReal() {
    return data;
  }
  public float getImag() {
    return imag;
  }

  public void setOne() {
    data = 1;
    imag = 0;
  }
  public void setZero() {
    data = 0;
    imag = 0;
  }
  void set(int i) {
    data = i;
    imag = 0;
  }
  void set(LNumber N) {
    data = ((LCFloat)N).data;
    imag = ((LCFloat)N).imag;
  }
  void set(float d, float i) {
    data = d;
    imag = i;
  }
  public void Print() {
    System.out.print(data+" + "+imag+"i");
  }  
  public String toString() {
    return (""+data+" + "+imag+"i");
  }

  public LNumber mult(LNumber N) {
    return new LCFloat((data * ((LCFloat)N).data)-
		       (imag * ((LCFloat)N).imag), 
		       (data * ((LCFloat)N).imag)+
		       (imag * ((LCFloat)N).data));
  }
  public LNumber mult(int i) {
    return new LCFloat(data*i,imag*i);
  }
  public void multTo(LNumber N) {
    float d = data*((LCFloat)N).data - imag*((LCFloat)N).imag; 
    imag = data*((LCFloat)N).imag + imag*((LCFloat)N).data;
    data = d;
  }
  public void multTo(int i) {
    data *= i;
    imag *= i;
  }
  public LNumber div(LNumber N) {
    float a = ((LCFloat)N).data;
    float b = ((LCFloat)N).imag;
    float denom = a*a + b*b;
    return new LCFloat((a*data + b*imag)/denom,(a*imag - b*data)/denom);
  }
  public LNumber div(int i) {
    return new LCFloat(data/i,imag/i);
  }
  public void divTo(LNumber N) {
    float a = ((LCFloat)N).data;
    float b = ((LCFloat)N).imag;
    float denom = a*a + b*b;
    float d = (a*data + b*imag)/denom;
    imag = (a*imag - b*data)/denom;
    data = d;
  }
  public void divTo(int i) {
    data /= i;
    imag /= i;
  }
  public LNumber divides(LNumber N) {
    float c = ((LCFloat)N).data;
    float d = ((LCFloat)N).imag;
    float denom = data*data + imag*imag;
    return new LCFloat((c*data + d*imag)/denom,(d*data - c*imag)/denom);   
  }
  public LNumber divides(int i) {
    float denom = data*data + imag*imag;
    return new LCFloat(i*data/denom,-i*imag/denom);
  }
  public LNumber add(LNumber N) {
    return new LCFloat(data + ((LCFloat)N).data,imag + ((LCFloat)N).imag);
  }
  public LNumber add(int i) {
    return new LCFloat(data+i,imag);
  }
  public void addTo(LNumber N) {
    data += ((LCFloat)N).data;
    imag += ((LCFloat)N).imag;
  }
  public void addTo(float d) {
    data += d;
  }
  public void addTo(int i) {
    data += i;
  }
  public LNumber sub(LNumber N) {
    return new LCFloat(data - ((LCFloat)N).data,imag - ((LCFloat)N).imag);
  }
  public LNumber sub(int i) {
    return new LCFloat(data-i,imag);
  }
  public void subTo(LNumber N) {
    data -= ((LCFloat)N).data;
    imag -= ((LCFloat)N).imag;
  }
  public void subTo(int i) {
    data -= i;
  }
  public LNumber subFrom(LNumber N) {
    return new LCFloat(((LCFloat)N).data - data,((LCFloat)N).imag - imag);
  }
  public LNumber subFrom(int i) {
    return new LCFloat(i-data,-imag);
  }
  public LNumber abs() {
    return new LCFloat(Math.abs(imag) + Math.abs(data),0);
  }
  public LNumber modulus() {
    return new LCFloat((float)Math.sqrt(data*data + imag*imag),0);
  }
  //  public LNumber timesSign(LNumber N) {
  // return new LCFloat((this.modulus()).mult(N.div(N.modulus())));
  //}
  public boolean equals(LNumber N) {
    return (data == ((LCFloat)N).data && imag == ((LCFloat)N).imag);
  }
  public boolean equals(int i) {
    return (data == i && imag == 0);
  }
  public LNumber negate() {
    return new LCFloat(-data,-imag);
  }
  public LNumber negateTo() {
    data = -data;
    imag = -imag;
    return this;
  }
  public LNumber pplus() {
    data++;
    return this;
  }

  /* These are incomplete!! They need to be adjusted!!! */

  public LNumber max(LNumber m) {
    if(this.greaterThan(m))
      return this;
    return m;
  } 
  public void maxTo(LNumber m) {
    if(!this.greaterOrEqual(m)) {
      data = ((LCFloat)m).data;
      imag = ((LCFloat)m).imag;
    }
  }
  
  public boolean greaterThan(LNumber N) {
    return (data > ((LCFloat)N).data);
  }
  public boolean greaterThan(int d) {
    return (data > d);
  }
  public boolean lessThan(LNumber N) {
    return (data < ((LCFloat)N).data);
  }
  public boolean lessThan(int d) {
    return (data < d);
  }
  public boolean greaterOrEqual(LNumber N) {
    if(data > ((LCFloat)N).data)
      return true;
    else if(this.equals((LCFloat)N))
      return true;
    return false;
  }
  public boolean greaterOrEqual(int d) {
    if (data > d)
      return true;
    else if (data == d && imag == 0)
      return true;
    return false;
  }
  public boolean lessOrEqual(LNumber N) {
    if(data < ((LCFloat)N).data)
      return true;
    else if(this.equals((LCFloat)N))
      return true;
    return false;
  }
  public boolean lessOrEqual(int d) {
    if (data < d)
      return true;
    else if (data == d && imag == 0)
      return true;
    return false;
  }

  public LNumber sqrt() {
    float a = (float)Math.sqrt(.5*((data)+
				   (float)Math.sqrt(data*data+imag*imag)));
    return new LCFloat(a,imag/(2*a));
  }
  public LNumber square() {
    return this.mult(this);
  }
  public LNumber inv() {
    float div = (data*data)+(imag*imag);
    return new LCFloat(data/div,-imag/div);
  }
  public LNumber invTo() {
    float div = (data*data)+(imag*imag);
    data = data/div;
    imag = -imag/div;
    return this;
  }
  public void ssq(LNumber SQ, LNumber Scale) {
    if(data != 0) {
      LCFloat temp = new LCFloat(Math.abs(data),0);
      if(Scale.lessThan(temp)) {
	SQ.set(SQ.mult(((Scale.div(temp)).square())).pplus());
	Scale.set(temp);
      }
      else
	SQ.addTo((temp.div(Scale)).square());
    }
    if(imag != 0) {
      LCFloat temp = new LCFloat(Math.abs(imag),0);
      if(Scale.lessThan(temp)) {
	SQ.set(SQ.mult(((Scale.div(temp)).square())).pplus());
	Scale.set(temp);
      }
      else
	SQ.addTo((temp.div(Scale)).square());
    }
  }  

}
