package edu.rice.linpack.LNumber;
import edu.rice.linpack.util.*;

public class LDouble extends LNumber {
  
  private double data;
  
  public LDouble() {
    data = 0;
  }
  public LDouble(LDouble S){
    data = S.data;
  }
  public LDouble(double d) {
    data = d;
  }

  public static LNumber[] makeArray(double[] f) {
    int l = f.length;
    LNumber[] N = new LNumber[l];
    for(int i=0;i<l;i++) {
      N[i] = new LDouble(f[i]);
    }
    return N;
  }
  public static LNumber[][] makeMatrix(double[][] f) {
    int l = f.length;
    if(l > 0) {
      int q = f[0].length;
      LNumber[][] N = new LNumber[l][q];
      for(int i=0;i<l;i++) {
	for(int j=0;j<q;j++) {
	  N[i][j] = new LDouble(f[i][j]);
	}
      }
      return N;
    }
    return null;
  }
  public static double[] getArray(LDouble[] N) {
    int l = N.length;
    double[] f = new double[l];
    for(int i=0;i<l;i++) {
      f[i] = N[i].data;
    }
    return f;
  }
  public static double[][] getMatrix(LDouble[][] N) {
    int l = N.length;
    if(l > 0) {
      int q = N[0].length;
      double[][] f = new double[l][q];
      for(int i=0;i<l;i++) {
	for(int j=0;j<q;j++) {
	  f[i][j] = N[i][j].data;
	}
      }
      return f;
    }
    return null;
  }
  public static void getArray(LDouble[] N, double[] f) {
    int l = N.length;
    for(int i=0;i<l;i++) 
      f[i] = N[i].data;
  }
  public static void getMatrix(LDouble[][] N, double[][] f) {
    int l = N.length;
    if(l > 0) {
      int q = N[0].length;
      for(int i=0;i<l;i++) 
	for(int j=0;j<q;j++) 
	  f[i][j] = N[i][j].data;
    }
  }
 

  public double getDouble() {
    return data;
  }

  public void setOne() {
    data = 1;
  }
  public void setZero() {
    data = 0;
  }

  void set(int i) {
    data = i;
  }
  void set(LNumber N) {
    data = ((LDouble)N).data;
  }
  void set(double d) {
    data = d;
  }

 public void Print() {
    System.out.print(data);
  }  
  public String toString() {
    return (""+data);
  }

  public LNumber mult(LNumber N) {
    return new LDouble(data*((LDouble)N).data); 
  }
  public LNumber mult(int d) {
    return new LDouble(data*d);
  }
  public void multTo(LNumber N) {
    data *= ((LDouble)N).data;
  }  
  public void multTo(int d) {
    data *= d;
  }
  public LNumber div(LNumber N) {
    return new LDouble(data/((LDouble)N).data);
  }
  public LNumber div(int d) {
    return new LDouble(data/d);
  }
  public void divTo(LNumber N) {
    data /= ((LDouble)N).data;
  }
  public void divTo(int d) {
    data /= d;
  }
  public LNumber divides(LNumber N) {
    return new LDouble(((LDouble)N).data/data);
  }
  public LNumber divides(int d) {
    return new LDouble(d - data);
  }
  public LNumber add(LNumber N) {
    return new LDouble(data + ((LDouble)N).data);
  }
  public LNumber add(int d) {
    return new LDouble(data + d);
  }
  public void addTo(LNumber N) {
    data += ((LDouble)N).data;
  }
  public void addTo(double d) {
    data += d;
  }
  public void addTo(int d) {
    data += d;
  }
  public LNumber sub(LNumber N) {
    return new LDouble(data - ((LDouble)N).data);
  }
  public LNumber sub(int d) {
    return new LDouble(data - d);
  } 
  public void subTo(LNumber N) {
    data -= ((LDouble)N).data;
  }
  public void subTo(int d) {
    data -= d;
  } 
  public LNumber subFrom(LNumber N) {
    return new LDouble(((LDouble)N).data - data);
  }
  public LNumber subFrom(int d) {
    return new LDouble(d - data);
  }
  public LNumber abs() {
    return new LDouble(Math.abs(data));
  }
  public LNumber modulus() {
    return new LDouble(Math.abs(data));
  }
  public LNumber negate() {
    return new LDouble(-data);
  }
  public LNumber negateTo() {
    data = -data;
    return this;
  }
  public LNumber pplus() {
    data++;
    return this;
  }
  public LNumber max(LNumber m) {
    if(this.greaterThan(m))
      return this;
    return m;
  }
  public void maxTo(LNumber m) {
    if(!this.greaterThan(m))
      data = ((LDouble)m).data;
  }
  public boolean greaterThan(LNumber N) {
    return (data > ((LDouble)N).data);
  }
  public boolean greaterThan(int d) {
    return (data > d);
  }
  public boolean lessThan(LNumber N) {
    return (data < ((LDouble)N).data);
  }
  public boolean lessThan(int d) {
    return (data < d);
  }
  public boolean equals(LNumber N) {
    return (data == ((LDouble)N).data);
  }
  public boolean equals(int d) {
    return (data == d);
  }
  public boolean greaterOrEqual(LNumber N) {
    return (data >= ((LDouble)N).data);
  }
  public boolean greaterOrEqual(int d) {
    return (data >= d);
  }
  public boolean lessOrEqual(LNumber N) {
    return (data <= ((LDouble)N).data);
  }
  public boolean lessOrEqual(int d) {
    return (data <= d);
  }

  public LNumber sqrt() {
    return new LDouble(Math.sqrt(data));
  }
  public LNumber square() {
    return new LDouble(data * data);
  }
  public LNumber inv() {
    return new LDouble(1/data);
  }
  public LNumber invTo() {
    data = 1/data;
    return this;
  }
  public void ssq(LNumber SQ, LNumber Scale) {
    if(data != 0) {
      LDouble temp = new LDouble(Math.abs(data));
      if(Scale.lessThan(temp)) {
	SQ.set(SQ.mult(((Scale.div(temp)).square())).pplus());
	Scale.set(temp);
      }
      else
	SQ.addTo((temp.div(Scale)).square());
    }
  }

}
