package edu.rice.linpack.LNumber;
import edu.rice.linpack.util.*;

public class LFloat extends LNumber {
  
  private float data = 0;

  public LFloat() {
    data = 0;
  }
  public LFloat(LFloat S){
    data = S.data;
  }
  public LFloat(float d) {
    data = d;
  }

  public static LNumber[] makeArray(float[] f) {
    int l = f.length;
    LNumber[] N = new LNumber[l];
    for(int i=0;i<l;i++) {
      N[i] = new LFloat(f[i]);
    }
    return N;
  }
  public static LNumber[][] makeMatrix(float[][] f) {
    int l = f.length;
    if(l > 0) {
      int q = f[0].length;
      LNumber[][] N = new LNumber[l][q];
      for(int i=0;i<l;i++) {
	for(int j=0;j<q;j++) {
	  N[i][j] = new LFloat(f[i][j]);
	}
      }
      return N;
    }
    return null;
  }
  public static float[] getArray(LFloat[] N) {
    int l = N.length;
    float[] f = new float[l];
    for(int i=0;i<l;i++) {
      f[i] = N[i].data;
    }
    return f;
  }
  public static float[][] getMatrix(LFloat[][] N) {
    int l = N.length;
    if(l > 0) {
      int q = N[0].length;
      float[][] f = new float[l][q];
      for(int i=0;i<l;i++) {
	for(int j=0;j<q;j++) {
	  f[i][j] = N[i][j].data;
	}
      }
      return f;
    }
    return null;
  }
  public static void getArray(LFloat[] N, float[] f) {
    int l = N.length;
    for(int i=0;i<l;i++) 
      f[i] = N[i].data;
  }
  public static void getMatrix(LFloat[][] N, float[][] f) {
    int l = N.length;
    if(l > 0) {
      int q = N[0].length;
      for(int i=0;i<l;i++) {
	for(int j=0;j<q;j++) {
	  f[i][j] = N[i][j].data;
	}
      }
    }
  }
 

  public float getFloat() {
    return data;
  }

  public void setOne() {
    data = 1;
  }
  public void setZero() {
    data = 0;
  }
  void set(int i) {
    data = i;
  }
  void set(LNumber N) {
    data = ((LFloat)N).data;
  }
  void set(float d) {
    data = d;
  }

  public void Print() {
    System.out.print(data);
  }  
  public String toString() {
    return (""+data);
  }

  public LNumber mult(LNumber N) {
    return new LFloat(data*((LFloat)N).data);
  }
  public LNumber mult(int N) {
    return new LFloat(data*N);
  }  
  public void multTo(LNumber N) {
    data *= ((LFloat)N).data;
  }
  public void multTo(int d) {
    data *= d;
  }
  public LNumber div(LNumber N) {
    return new LFloat(data/((LFloat)N).data);
  }
  public LNumber div(int f) {
    return new LFloat(data/f);
  }
  public void divTo(LNumber N) {
    data /= ((LFloat)N).data;
  }
  public void divTo(int d) {
    data /= d;
  }
  public LNumber divides(LNumber N) {
    return new LFloat(((LFloat)N).data/data);
  }
  public LNumber divides(int f) {
    return new LFloat(f/data);
  }
  public LNumber add(LNumber N) {
    return new LFloat(data + ((LFloat)N).data);
  }
  public LNumber add(int f) {
    return new LFloat(data + f);
  }
  public void addTo(LNumber N) {
    data += ((LFloat)N).data;
  }
  public void addTo(double d) {
    data += d;
  }
  public void addTo(int d) {
    data += d;
  }
  public LNumber sub(LNumber N) {
    return new LFloat(data - ((LFloat)N).data);
  }
  public LNumber sub(int f) {
    return new LFloat(data - f);
  }
  public void subTo(LNumber N) {
    data -= ((LFloat)N).data;
  }
  public void subTo(int d) {
    data -= d;
  } 
  public LNumber subFrom(LNumber N) {
    return new LFloat(((LFloat)N).data - data);
  }
  public LNumber subFrom(int f) {
    return new LFloat(f - data);
  }
  public LNumber abs() {
    return new LFloat(Math.abs(data));
  }
  public LNumber modulus() {
    return new LFloat(Math.abs(data));
  }
  public LNumber negate() {
    return new LFloat(-data);
  }
  public LNumber negateTo() {
    data = -data;
    return this;
  }
  public LNumber pplus() {
    data++;
    return this;
  }
  public LNumber max(LNumber m) {
    if(this.greaterThan(m))
      return this;
    return m;
  }
  public void maxTo(LNumber m) {
    if(!this.greaterThan(m))
      data = ((LFloat)m).data;
  }  
  public boolean greaterThan(LNumber N) {
    return data > ((LFloat)N).data;
  }
  public boolean greaterThan(int f) {
    return data > f;
  }
  public boolean lessThan(LNumber N) {
    return data < ((LFloat)N).data;
  }
  public boolean lessThan(int f) {
    return data < f;
  }
  public boolean equals(LNumber N) {
    return data == ((LFloat)N).data;
  }
  public boolean equals(int f) {
    return data == f;
  }
  public boolean greaterOrEqual(LNumber N) {
    return data >= ((LFloat)N).data;
  }
  public boolean greaterOrEqual(int f) {
    return data >= f;
  }  
  public boolean lessOrEqual(LNumber N) {
    return data <= ((LFloat)N).data;
  }
  public boolean lessOrEqual(int f) {
    return data <= f;
  }  
  public LNumber sqrt() {
    return new LFloat((float)Math.sqrt(data));
  }
  public LNumber square() {
    return new LFloat(data * data);
  }
  public LNumber inv() {
    return new LFloat(1/data);
  }
  public LNumber invTo() {
    data = 1/data;
    return this;
  }
  public void ssq(LNumber SQ, LNumber Scale) {
    if(data != 0) {
      LFloat temp = new LFloat(Math.abs(data));
      if(Scale.lessThan(temp)) {
	SQ.set(SQ.mult(((Scale.div(temp)).square())).pplus());
	Scale.set(temp);
      }
      else
	SQ.addTo((temp.div(Scale)).square());
    }
  }
}
