package edu.rice.linpack.LNumber;
import edu.rice.linpack.util.*;

public abstract class LNumber implements Cloneable {
  
  public abstract LNumber mult(LNumber N);
  public abstract LNumber mult(int i);
  public abstract void multTo(LNumber N);
  public abstract void multTo(int N);
  public abstract LNumber div(LNumber N);
  public abstract LNumber div(int i);
  public abstract void divTo(LNumber N);
  public abstract void divTo(int N);
  public abstract LNumber divides(LNumber N);
  public abstract LNumber divides(int i);
  public abstract LNumber add(LNumber N);
  public abstract LNumber add(int i);
  public abstract void addTo(LNumber N);
  public abstract void addTo(double d);
  public abstract void addTo(int N);
  public abstract LNumber sub(LNumber N);
  public abstract LNumber sub(int i);
  public abstract void subTo(LNumber N);
  public abstract void subTo(int N);
  public abstract LNumber subFrom(LNumber N);
  public abstract LNumber subFrom(int i);
  public abstract LNumber abs();
  public abstract LNumber modulus();
  //  public abstract LNumber timesSign(LNumber N);
  public abstract boolean equals(LNumber N);
  public abstract boolean equals(int i);
  public abstract boolean greaterThan(LNumber N);
  public abstract boolean greaterThan(int i);
  public abstract boolean lessThan(LNumber N);
  public abstract boolean lessThan(int i);
  public abstract boolean greaterOrEqual(LNumber N);
  public abstract boolean greaterOrEqual(int i);
  public abstract boolean lessOrEqual(LNumber N);
  public abstract boolean lessOrEqual(int i);
  public abstract LNumber square();
  public abstract LNumber inv();
  public abstract LNumber invTo();
  public abstract LNumber negate();
  public abstract LNumber negateTo();
  public abstract void setOne();
  public abstract void setZero();
  abstract void set(LNumber N);
  public abstract LNumber sqrt(); 
  public abstract LNumber pplus();
  public abstract LNumber max(LNumber m);
  public abstract void maxTo(LNumber m);
  public abstract String toString();
  public abstract void ssq(LNumber SQ, LNumber Scale);

  public LNumber Clone() {
    try {
      return (LNumber)super.clone();
    }
    catch(CloneNotSupportedException e) {
    }
    this.setZero();
    return this;
  }

  public double getDouble()
       throws WrongDataTypeException
  {
    throw new WrongDataTypeException();
  }
  public float getFImag() 
       throws WrongDataTypeException
  {
    throw new WrongDataTypeException();
  }
  public float getFReal()
       throws WrongDataTypeException
  {
    throw new WrongDataTypeException();
  }
  public double getDImag() 
       throws WrongDataTypeException
  {
    throw new WrongDataTypeException();
  }
  public double getDReal()
       throws WrongDataTypeException
  {
    throw new WrongDataTypeException();
  }

  public abstract void Print();

}

