/*  
 ##  class DPacked
 ##  
 ##  This class holds the framework for a matrix stored in packed form.
 ##  It contains all the necessary basic routines for matrices adjusted
 ##  for its form.
 ##
 */

package edu.rice.linpack.Matrix.DMatrix;
import edu.rice.linpack.LNumber.*;
import edu.rice.linpack.Vector.*;
import edu.rice.linpack.util.*;

public abstract class DPacked extends DMatrix {

  protected int order;
        
  public abstract void factor()
       throws SingularMatrixException;

  public abstract LNumber condition()
       throws SingularMatrixException, WrongDataTypeException;
  public abstract LNumber condition(Vector Z)
       throws SingularMatrixException, WrongDataTypeException;

  public abstract void solve(Vector B, int J)
       throws WrongDataTypeException;
  public abstract void solve(Vector B)
       throws WrongDataTypeException;

  public abstract Vector determ();
  public abstract void inverse();

  public double getElem(int i) {
    return Mat[i][0];
  }
  public double[] getColumn(int q) {
    return getColumn(0,q);
  }
  public int getOrder() {
    return order;
  }
  public static double[][] pack(double[][] f) {
    int k = 0;
    int n = f.length;
    double[][] R = new double[(n*(n+1))/2][1];
    for(int j=0;j<n;j++) {
      for(int i=0;i<=j;i++) {
	R[k][0] = f[i][j];
	k++;
      }
    }	
    return R;
  }

  public void setColumn(int c,DPacked F) {
    for(int r=0;r<rows;r++) {
      this.Mat[r+c][0] = F.Mat[r][0];
    }
  }
  public void setColumn(int n, int rx, double[] f, int ry) {
    for(int i=0;i<n;i++) {
      this.Mat[i+rx][0] = f[i+ry];
    }
  }
  public void swapElem(int rx, int ry) {
    this.swapElem(rx,0,ry,0);
  }
  
  protected double oneNorm() {
    double[] Z = new double[order];
    
    int j1 = 0;
    for(int j=0;j<order;j++) {
      Z[j] = this.asum(j+1,1,j1,0);
      int ij = j1;
      j1 += j+1;
      for(int i=0;i<j;i++) {
	Z[i] += Math.abs(this.Mat[ij][0]);
	ij++;
      }
    }
    double anorm = 0;
    for(int j=0;j<order;j++) 
      anorm = Math.max(anorm, Z[j]);
   
    return anorm;
  }

  public void Print() {
    for(int n=0;n<order;n++) {
      System.out.println();
      for(int j=0;j<order;j++) {
	if(j < n) 
	  System.out.print("           ");
	else {
	  int q = j*(j+1)/2 + n;
	  System.out.print(this.Mat[q][0]+"     ");
	}
      }
    }
    System.out.println();
  }
}
