package edu.rice.linpack.Matrix.DMatrix;
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;

public class DPoDiag extends DTDiag {

  public DPoDiag() {
    super();
  }
  public DPoDiag(int i, int j) {
    super(2,j);
  }
  public DPoDiag(double[][] f) {
    cols = f.length;
    rows = 2;
    Mat = new double[2][cols];
    for(int i=0;i<cols-1;i++) {
      Mat[1][i] = f[i][i];
      Mat[0][i] = f[i][i+1];
    }
    Mat[1][cols-1] = f[cols-1][cols-1];
  }
  public DPoDiag(double[] a, double[] b) {
    cols = a.length;
    rows = 2;
    Mat = new double[2][cols];
    for(int i=0;i<cols-1;i++) {
      Mat[1][i] = a[i];
      Mat[0][i] = b[i];
    }
    Mat[1][cols-1] = a[cols-1];
  }
  public DPoDiag(DPoDiag F) {
    super(F);
  }

  public void solve(Vector Be) 
       throws WrongDataTypeException
  {
    double[] B = Be.getDoubleArray();

    if(cols == 1) 
      B[0] = B[0]/this.Mat[1][0];
    else {
      int nm = cols-1;
      int nhalf = nm/2;
      
      if(cols > 2) {
	int kbm = nm-1;
	
	for(int k=0;k<nhalf;k++) {
	  double T = this.Mat[0][k]/this.Mat[1][k];
	  this.Mat[1][k+1] -= T*this.Mat[0][k];
	  B[k+1] -= T*B[k];
	  T = this.Mat[0][kbm]/this.Mat[1][kbm+1];
	  this.Mat[1][kbm] -= T*this.Mat[0][kbm];
	  B[kbm] -= T*B[kbm+1];
	  kbm--;
	}
      }
      int kp = nhalf;
      
      //  Clean up for possible etc.  //

      if(cols%2 == 0) {
	double T = this.Mat[0][kp]/this.Mat[1][kp];
	this.Mat[1][kp+1] -= T*this.Mat[0][kp];
	B[kp+1] -= T*B[kp];
	kp++;
      }
      
      //  Back solve  //

      B[kp] /= this.Mat[1][kp];
      if(cols > 2) {
	int k = kp - 1;
	int kw = kp + nhalf;
	for(int kf = kp;kf<kw;kf++) {
	  B[k] = (B[k] - this.Mat[0][k]*B[k+1])/this.Mat[1][k];
	  B[kf+1] = (B[kf+1] - this.Mat[0][kf]*B[kf])/this.Mat[1][kf+1];
	  k--;
	}
      }
      if(cols%2 == 0) 
	B[0] = (B[0] - this.Mat[0][0]*B[1])/this.Mat[1][0];
    }
  }
}
      
