/*
 ##  class DTriFull
 ##
 ##  This class contains the framework for triangular matrices.
 ##
 */

package edu.rice.linpack.Matrix.DMatrix;
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;
import edu.rice.linpack.LNumber.*;

public abstract class DTriFull extends DFull {

  public abstract LNumber condition(Vector Z)
       throws WrongDataTypeException, SingularMatrixException;  
  public abstract void solve(Vector B, int J)
       throws WrongDataTypeException;
  public abstract void inverse();

  public void solve(Vector Be) 
       throws WrongDataTypeException
  {
    this.solve(Be,0);
  }


  void zeroDiag() 
       throws SingularMatrixException
  {
    for(int i=0;i<cols;i++) {
      if(this.Mat[i][i] == 0) 
	throw new SingularMatrixException(i+1);
    }
  }

  public void factor() 
       throws SingularMatrixException
  {
    this.zeroDiag();
  }
 
  public Vector determ() {
    
    double[] Det = new double[2];        
    Det[0] = 1;
    Det[1] = 0;
    
    for(int i=0;i<cols;i++) {
      Det[0] *= this.Mat[i][i];
      
      if(Det[0] == 0) {
	Det[1] = 0;
	DVector D = new DVector(Det);
	return D;
      }
      else 
	DUtil.detNorm(Det);
    }
    DVector De = new DVector(Det);
    return De;
  }
}
