h48210
s 00004/00002/00426
d D 1.5 98/08/26 16:03:22 jpiper 6 5
c got rid of getDouble
e
s 00006/00006/00422
d D 1.4 98/08/04 18:47:48 jpiper 5 4
c needed for debugging
e
s 00001/00001/00427
d D 1.3 98/08/03 18:47:38 jpiper 4 3
c made small changes
e
s 00070/00070/00358
d D 1.2 98/07/27 13:07:01 jpiper 3 1
c Created copy of FBanded
e
s 00000/00000/00000
d R 1.2 98/07/27 12:01:24 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DBanded.java
e
s 00428/00000/00000
d D 1.1 98/07/27 12:01:23 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/*
D 3
 ##  class FBanded
E 3
I 3
 ##  class DBanded
E 3
 ##  
 ##  This class holds the frame for matrices stored in banded form.
 ##  It also contains the Gaussian routines for banded matrices.
 ##
 */


D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.DMatrix;
E 3
import edu.rice.linpack.LNumber.*;
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;

D 3
public class FBanded extends FMatrix {
E 3
I 3
public class DBanded extends DMatrix {
E 3

  protected int mu, ml;

D 3
  public FBanded() {
E 3
I 3
  public DBanded() {
E 3
    super();
    cons();
  }
D 3
  public FBanded(int ML, int MU, int columns) {
E 3
I 3
  public DBanded(int ML, int MU, int columns) {
E 3
    cons(2*ML+MU+1,columns);
    mu = MU;
    ml = ML;
  }
D 3
  // This is for unbanded float arrays //
  public FBanded(float[][] f, int ML, int MU) {
E 3
I 3
  // This is for unbanded double arrays //
  public DBanded(double[][] f, int ML, int MU) {
E 3
    mu = MU;
D 4
    ml = ml;
E 4
I 4
    ml = ML;
E 4
    Mat = band(f,ml,mu);
    rows = Mat.length;
    cols = Mat[0].length;
    pivot = new int[cols];
  }
D 3
  // This is for banded float arrays //
  public FBanded(float[][] f, int ML) {
E 3
I 3
  // This is for banded double arrays //
  public DBanded(double[][] f, int ML) {
E 3
    cons(f);
    ml = ML;
    mu = f.length - 1 - 2*ML;
  }
D 3
  public FBanded(FFull F, int Ml, int Mu) {
E 3
I 3
  public DBanded(DFull F, int Ml, int Mu) {
E 3
    mu = Mu;
    ml = Ml;
    Mat = band(F.Mat,ml,mu);
    rows = Mat.length;
    cols = Mat[0].length;
    pivot = new int[cols];
  }
D 3
  public FBanded(FBanded F) {
E 3
I 3
  public DBanded(DBanded F) {
E 3
    cons(F);
    mu = F.mu;
    ml = F.ml;
  }

D 3
  private float[][] band(float[][] f, int Ml, int Mu) {
E 3
I 3
  private double[][] band(double[][] f, int Ml, int Mu) {
E 3
    int n = f[0].length;
D 3
    float[][] Fband = new float[2*ml+mu+1][n];
E 3
I 3
    double[][] Dband = new double[2*ml+mu+1][n];
E 3
    int M = Ml + Mu;
    for(int j=0;j<n;j++) {
      int i1 = Math.max(0,j-Mu);
      int i2 = Math.min(n,j+Ml+1);
      for(int i=i1;i<i2;i++) {
	int k = i - j + M;
D 3
	Fband[k][j] = f[i][j];
E 3
I 3
	Dband[k][j] = f[i][j];
E 3
      }
    }
D 3
    return Fband;
E 3
I 3
    return Dband;
E 3
  }
D 3
  public FFull unband() {
    FFull Fband = new FFull(cols,cols);
E 3
I 3
  public DFull unband() {
    DFull Fband = new DFull(cols,cols);
E 3
    int M = ml + mu;
    for(int j=0;j<cols;j++) {
      int i1 = Math.max(0,j-mu);
      int i2 = Math.min(cols,j+ml+1);
      for(int i=i1;i<i2;i++) {
	int k = i - j + M;
	Fband.Mat[i][j] = this.Mat[k][j];
      }
    }
    return Fband;
  }  
  
D 3
  public float oneNorm() {
    float anorm = 0;
E 3
I 3
  public double oneNorm() {
    double anorm = 0;
E 3
    int L = ml;
    int is = L + mu;
    for(int j=0;j<cols;j++) {
      anorm = Math.max(anorm,this.asum(L+1,1,is,j));
      if(is > ml) 
	is--;
      if(j < mu)
	L++;
      if(j >= cols-ml-1)
	L--;  
    }
    return anorm;
  }

  /*  Factor and solve are both completely checked
      Determ is fully tested and works fine.  
      Condition is fully tested and works fine.
      */

  /*  Pivots are java based  */

  public void factor() 
       throws SingularMatrixException
  {
    
    int info = 0;
    int M = ml + mu + 1;
D 3
    float T;
E 3
I 3
    double T;
E 3
    
    int Ji = Math.min(cols,M) - 1;
    int io;
    for(int Jz=mu+1;Jz < Ji;Jz++) {
      io = M - 1 - Jz;
      for(int i=io;i < ml;i++) 
	this.Mat[i][Jz] = 0;
    }
    
    int Jz = Ji;
    int Ju = 0;
    
    /* Gaussian elimination with partial pivoting */

    int colsm = cols - 1;
    if(cols > 1) {
      int kp;
      for(int k=0;k<colsm;k++,Jz++) {
	kp = k+1;
	if(Jz < cols) 
	  for(int i=0;i<ml;i++) 
	    this.Mat[i][Jz] = 0;
	
	int lm = Math.min(ml, colsm-k) - 1;
	int L = this.i_amax(lm+2,1,M-1,k) + M - 1;
	pivot[k] = L + kp - M;

	if(this.Mat[L][k] != 0) {
	  if(L != M-1) 
	    this.swapElem(L,k,M-1,k);
	  
D 3
	  T = (float)-1.0/this.Mat[M-1][k];
E 3
I 3
	  T = -1.0/this.Mat[M-1][k];
E 3
	  this.scal(lm+1,T,1,M,k);
	  
	  /*  ROW ELIMINATION WITH COLUMN INDEXING */

	  Ju = Math.min(Math.max(Ju,mu+pivot[k]),colsm);
	  int MM = M-2;
	  for(int j=kp;j<=Ju;j++) {
	    L--;
	    T = this.Mat[L][j];
	    if(L != MM) 
	      this.swapElem(L,j,MM,j);
	    this.axpy(lm+1, T,1,M,k,this,1,MM+1,j);
	    MM--;
	  }
	}
	else 
	  info = k+1;
      }
    }
    pivot[cols-1] = cols-1;
    if(this.Mat[M-1][cols-1] == 0) 
      info = cols;
    if(info != 0)
      throw new SingularMatrixException(info);
  }

  public LNumber condition() 
       throws SingularMatrixException, WrongDataTypeException
  {
D 3
    Vector Z = new FVector(cols);
E 3
I 3
    Vector Z = new DVector(cols);
E 3
    return this.condition(Z);
  }
  public LNumber condition(Vector Ze) 
       throws SingularMatrixException, WrongDataTypeException
  {
D 3
    float[] Z = Ze.getFloatArray();
E 3
I 3
    double[] Z = Ze.getDoubleArray();
E 3
    
    // Compute 1-Norm of this //

D 3
    float anorm = this.oneNorm();
    float ynorm;
E 3
I 3
    double anorm = this.oneNorm();
    double ynorm;
E 3

    // Factor //

    try {
      this.factor();
    } finally {
    
      // Rcond = 1/(norm(this) * (Estimate of norm(inv(this)))) //
      
      for(int j=0;j<cols;j++)
	Z[j] = 0;
      
      int M = ml + mu;
      
      this.solveTransUW(M,Z);
D 5
      
D 3
      float S = (float)1.0/FUtil.asum(cols,Z,1);
      FUtil.scal(cols,S,Z,1);
E 3
I 3
      double S = 1.0/DUtil.asum(cols,Z,1);
E 5
I 5

      double S = 1/DUtil.asum(cols,Z,1);
E 5
      DUtil.scal(cols,S,Z,1);
E 3
D 5
     
E 5
I 5
      
E 5
      this.solveLV(M,Z);
      
      ynorm = this.solveTransLY(M,Z);
D 5
    
E 5
I 5

E 5
      // Solve U*Z = W //
      
      ynorm = this.solveUZ(M,Z,ynorm);
    }   
D 3
    LFloat R = new LFloat();
E 3
I 3
D 6
    LDouble R = new LDouble();
E 6
I 6
    LDouble R;
E 6
E 3
D 5
    
E 5
I 5

E 5
    if(anorm != 0)
D 3
      R.setFloat(ynorm/anorm);
E 3
I 3
D 6
      R.setDouble(ynorm/anorm);
E 6
I 6
      R = new LDouble(ynorm/anorm);
    else
      R = new LDouble(anorm);
E 6
E 3
D 5
    
E 5
I 5

E 5
    return R;
  }
D 3
  private void solveTransUW(int M, float[] Z) {
E 3
I 3
  private void solveTransUW(int M, double[] Z) {
E 3

D 3
    float ek = 1;
E 3
I 3
    double ek = 1;
E 3
    int Ju = 0;
    for(int k=0;k<cols;k++) {
      
      if(Z[k] != 0) 
D 3
	ek = FUtil.signOf(ek,-Z[k]);
E 3
I 3
	ek = DUtil.signOf(ek,-Z[k]);
E 3
      if(Math.abs(ek-Z[k]) > Math.abs(this.Mat[M][k])) {
D 3
	float S = Math.abs(this.Mat[M][k])/Math.abs(ek-Z[k]);
	FUtil.scal(cols,S,Z,1);
E 3
I 3
	double S = Math.abs(this.Mat[M][k])/Math.abs(ek-Z[k]);
	DUtil.scal(cols,S,Z,1);
E 3
	ek *= S;
      }
      
D 3
      float wk = ek - Z[k];
      float wkm = -ek - Z[k];
      float S = Math.abs(wk);
      float SM = Math.abs(wkm);
E 3
I 3
      double wk = ek - Z[k];
      double wkm = -ek - Z[k];
      double S = Math.abs(wk);
      double SM = Math.abs(wkm);
E 3
      if(this.Mat[M][k] != 0) {
	wk = wk/this.Mat[M][k];
	wkm = wkm/this.Mat[M][k];
      }
      else {
	wk = 1;
	wkm = 1;
      }
      int kp = k + 1;
      Ju = Math.min(Math.max(Ju,mu+pivot[k]+1),cols);
      int MM = M-1;
      if(kp < Ju) {
	for(int j=kp;j<Ju; j++,MM--) {
	  SM += Math.abs(Z[j]+wkm*this.Mat[MM][j]);
	  Z[j] += wk*this.Mat[MM][j];
	  S += Math.abs(Z[j]);
	}
	if(S < SM) {
D 3
	  float T = wkm - wk;
E 3
I 3
	  double T = wkm - wk;
E 3
	  wk = wkm;
	  MM = M-1;
	  for(int j=kp;j<Ju;j++,MM--) 
	    Z[j] += T*this.Mat[MM][j];
	}
      }
      Z[k] = wk;
    }
  }
D 3
  private void solveLV(int M, float[] Z) {
E 3
I 3
  private void solveLV(int M, double[] Z) {
E 3
    
    for(int k=cols-1;k>=0;k--) {
      int lm = Math.min(ml,cols-k-1);
      if(k < cols-1)
	Z[k] += this.dot(lm, 1,M+1,k, Z, 1, k+1);
      if(Math.abs(Z[k]) > 1) {
D 3
	float S = (float)1.0/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
E 3
I 3
	double S = 1.0/Math.abs(Z[k]);
	DUtil.scal(cols,S,Z,1);
E 3
      }
      int L = pivot[k];
D 3
      FUtil.swapElems(Z,L,k);
E 3
I 3
      DUtil.swapElems(Z,L,k);
E 3
    }
    
D 3
    float S = (float)1.0/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
    double S = 1.0/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
E 3
  }
D 3
  private float solveTransLY(int M, float[] Z) {
    float ynorm = 1;
E 3
I 3
  private double solveTransLY(int M, double[] Z) {
    double ynorm = 1;
E 3

    for(int k=0;k<cols;k++) {
      int L = pivot[k];
D 3
      FUtil.swapElems(Z,L,k);
E 3
I 3
      DUtil.swapElems(Z,L,k);
E 3
      int lm = Math.min(ml,cols-k-1);
      if(k < cols)
	this.axpy(lm,Z[k],1,M+1,k, Z, 1, k+1);
      if(Math.abs(Z[k]) > 1) {
D 3
	float S = (float)1.0/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
E 3
I 3
	double S = 1.0/Math.abs(Z[k]);
	DUtil.scal(cols,S,Z,1);
E 3
	ynorm *= S;
      }
    }
D 3
    float S = (float)1.0/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
    double S = 1.0/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
E 3
    ynorm *= S;
    
    return ynorm;
  }
D 3
  float solveUZ(int M, float[] Z, float ynorm){
E 3
I 3
  double solveUZ(int M, double[] Z, double ynorm){
E 3
    
    for(int k=cols-1;k>=0;k--) {
      if(Math.abs(Z[k]) > Math.abs(this.Mat[M][k])) {
D 3
	float S = Math.abs(this.Mat[M][k])/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
E 3
I 3
	double S = Math.abs(this.Mat[M][k])/Math.abs(Z[k]);
	DUtil.scal(cols,S,Z,1);
E 3
	ynorm *= S;
      }
      
      if(this.Mat[M][k] != 0)
	Z[k] /= this.Mat[M][k];
      else
	Z[k] = 1;
      int lm = Math.min(k,M);
      int la = M - lm;
      int lz = k - lm;
D 3
      float T = -Z[k];
E 3
I 3
      double T = -Z[k];
E 3
      this.axpy(lm,T,1,la,k,Z,1,lz);
    }

D 3
    float S = (float)1.0/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
    double S = 1.0/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
E 3
    ynorm *= S;
  
    return ynorm;
  }
  
  public void solve(Vector B) 
       throws WrongDataTypeException
  {
    this.solve(B,0);
  }
  public void solve(Vector Be, int Job) 
       throws WrongDataTypeException
  {
    
D 3
    float[] B = Be.getFloatArray();
E 3
I 3
    double[] B = Be.getDoubleArray();
E 3

    int M = mu+ml+1;
    int nm = cols-1;
D 3
    float T;
E 3
I 3
    double T;
E 3

    if(Job == 0) {
      if(ml != 0) {
	if(nm > 0) {
	  for(int k=0;k<nm;k++) {
	    int lm = Math.min(ml,nm-k);
	    int l = pivot[k];
	    T = B[l];
	    if(l != k) 
D 3
	      FUtil.swapElems(B,l,k);
E 3
I 3
	      DUtil.swapElems(B,l,k);
E 3
	    this.axpy(lm,T,1,M,k,B,1,k+1);
	  }
	}
      }

      //  Solve U*X=Y  //

      this.solveRX(M-1,B);

    }
    else {

      //  Job is non-zero, solve trans(A)*X=B  //

      this.solveTransRY(M-1,B);

      if(ml != 0) {
	for(int k=cols-2;k>=0;k--) {
	  int lm = Math.min(ml,nm-k);
	  B[k] += this.dot(lm,1,M,k,B,1,k+1);
	  int l = pivot[k];
	  if(l != k) 
D 3
	    FUtil.swapElems(B,l,k);
E 3
I 3
	    DUtil.swapElems(B,l,k);
E 3
	}
      }
    }
    return; 
  }
D 3
  void solveTransRY(int M, float[] B) {
E 3
I 3
  void solveTransRY(int M, double[] B) {
E 3
    for(int k=0;k<cols;k++) {
      int lm = Math.min(k,M);
      int la = M-lm;
      int lb = k-lm;
D 3
      float T = this.dot(lm,1,la,k,B,1,lb);
E 3
I 3
      double T = this.dot(lm,1,la,k,B,1,lb);
E 3
      B[k] = (B[k] - T)/this.Mat[M][k];
    }
  }
D 3
  void solveRX(int M, float[] B){
E 3
I 3
  void solveRX(int M, double[] B){
E 3
    for(int k=cols-1;k>=0;k--) {
      int LM = Math.min(k,M);
      int la = M - LM;
      int lb = k - LM;
      B[k] /= this.Mat[M][k];
D 3
      float T = -B[k];
E 3
I 3
      double T = -B[k];
E 3
      this.axpy(LM,T,1,la,k,B,1,lb);
    }
  }
	    
  public Vector determ() {
    
D 3
    float[] Det = new float[2];
E 3
I 3
    double[] Det = new double[2];
E 3
    int M = mu + ml + 1;
    
    Det[0] = 1;
    Det[1] = 0;

    for(int i=0;i<cols;i++) {
      if(pivot[i] != i) 
	Det[0] = -Det[0];
      Det[0] *= this.Mat[M-1][i];
      
      if(Det[0] == 0) {
D 3
	FVector V = new FVector(Det);
E 3
I 3
	DVector V = new DVector(Det);
E 3
	return V;
      }      
      else 
D 3
	FUtil.detNorm(Det);
E 3
I 3
	DUtil.detNorm(Det);
E 3
    }
D 3
    FVector V2 = new FVector(Det);
E 3
I 3
    DVector V2 = new DVector(Det);
E 3
    return V2;
  }
}
E 1
