h08365
s 00004/00002/01621
d D 1.6 98/08/26 16:03:30 jpiper 7 6
c got rid of setDouble
e
s 00000/00000/01623
d D 1.5 98/08/11 16:42:09 jpiper 6 5
c needed for dbugging
e
s 00068/00000/01555
d D 1.4 98/07/31 17:57:20 jpiper 5 4
c Added transpose and Multiplication methods
e
s 00004/00000/01551
d D 1.3 98/07/29 10:32:58 zoran 4 3
c added a getPivot method
e
s 00234/00234/01317
d D 1.2 98/07/27 13:07:20 jpiper 3 1
c double copy of FFull
e
s 00000/00000/00000
d R 1.2 98/07/27 12:01:31 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DFull.java
e
s 01551/00000/00000
d D 1.1 98/07/27 12:01:30 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/*## 
D 3
 ##  class FFull
E 3
I 3
 ##  class DFull
E 3
 ##
D 3
 ##  This class extends FMatrix to represent all full matrices.   
E 3
I 3
 ##  This class extends DMatrix to represent all full matrices.   
E 3
 ##  It contains the subroutine for singular value decomposition, the 
 ##  QR decompostion routines, the updating routines, and the Gaussian 
 ##  Elimination factoring routines.
 ##
 ##*/

D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.DMatrix;
E 3
import edu.rice.linpack.LNumber.*;
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;

D 3
public class FFull extends FMatrix {
E 3
I 3
public class DFull extends DMatrix {
E 3

D 3
  public FFull() {
E 3
I 3
  public DFull() {
E 3
    super();
    cons();
  }
D 3
  public FFull(int i, int j) {
E 3
I 3
  public DFull(int i, int j) {
E 3
    cons(i,j);
  }
D 3
  public FFull(float[][] f) {
    cons(f);
E 3
I 3
  public DFull(double[][] D) {
    cons(D);
E 3
  }
D 3
  public FFull(FFull F) {
E 3
I 3
  public DFull(DFull F) {
E 3
    cons(F);
  }
D 3
  public FFull(int ni, int nj, float[][] f, int strow, int stcol) {
E 3
I 3
  public DFull(int ni, int nj, double[][] f, int strow, int stcol) {
E 3
    rows = ni;
    cols = nj;
D 3
    Mat = new float[rows][cols];
E 3
I 3
    Mat = new double[rows][cols];
E 3
    for(int i=0;i<rows;i++) {
      for(int j=0;j<cols;j++) {
	Mat[i][j] = f[i+strow][j+stcol];
      }
    }
    pivot = new int[cols];
  }

D 3
  public FBanded band(int ml, int mu) {
    FBanded B = new FBanded(ml,mu,cols);
E 3
I 3
  public DBanded band(int ml, int mu) {
    DBanded B = new DBanded(ml,mu,cols);
E 3
    int M = ml+mu;
    for(int j=0;j<cols;j++) {
      int i1 = Math.max(0,j-mu);
      int i2 = Math.min(cols-1,j+ml);
      for(int i=i1;i<=i2;i++) {
	int k = i-j+M;
	B.Mat[k][j] = this.Mat[i][j];
      }
    }
    return B;
  }
  public void setPivot(int[] f) {
    for(int i=0;i<cols;i++) 
      pivot[i] = f[i];
  }
  public void setPivot(int i, int p) {
    pivot[i] = p;
  }

I 4
  public int[] getPivot() {
    return pivot;
  }

I 5
  public void transpose() {
    if(rows == cols) 
      for(int i=0;i<rows;i++) {
	for(int j=0;j<i;j++) {
	  this.swapElem(i,j,j,i);
	}
      }
    else {
      double[][] G = new double[cols][rows];
      for(int i=0;i<rows;i++) {
	for(int j=0;j<cols;j++) {
	  G[j][i] = Mat[i][j];
	}
      }
      Mat = G;
      cols = rows;
      rows = G.length;
    }
  }
  public void transpose(DFull N) {
    for(int i=0;i<rows;i++) {
      for(int j=0;j<cols;j++) {
	N.Mat[j][i] = Mat[i][j];
      }
    }
  }

  public DFull matMult(DFull N) {
    DFull G = new DFull(rows,N.cols);
    for(int i=0;i<rows;i++) {
      double[] L = this.getRow(i,0);
      for(int j=0;j<N.cols;j++) {
	G.Mat[i][j] = N.dot(cols,1,0,j,L,1,0);
      }
    }
    return G;
  }
  public void matMultTo(DFull N) {
    double[][] G = new double[rows][N.cols];
    for(int i=0;i<rows;i++) {
      double[] L = this.getRow(i,0);
      for(int j=0;j<N.cols;j++) {
	G[i][j] = N.dot(cols,1,0,j,L,1,0);
      }
    }
    Mat = G;
    cols = N.cols;
  }
  public DFull matMultRev(DFull N) {
    DFull G = new DFull(N.rows,cols);
    for(int i=0;i<N.rows;i++) {
      double[] L = N.getRow(i,0);
      for(int j=0;j<cols;j++) {
	G.Mat[i][j] = this.dot(rows,1,0,j,L,1,0);
      }
    }
    return G;
  }

  public DVector matVec(DVector N) {
    DVector G = new DVector(rows);
    for(int i=0;i<rows;i++) {
      double[] L = this.getRow(i,0);
      G.setElem(DUtil.dot(cols,L,1,0,N.getDoubleArray(),1,0),i);
    }
    return G;
  }

E 5
E 4
D 3
  private float oneNorm() {
    float a = 0;
E 3
I 3
  private double oneNorm() {
    double a = 0;
E 3
    for(int j=0;j<cols;j++) 
      a = Math.max(a, this.asum(cols,1,0,j));
    return a;
  }
  
  /*##  
   ##  svDecompose is a subroutine to reduce a single precision nXp 
D 3
   ##  FFull by orthogonal transformations U and V to diagonal form.  
E 3
I 3
   ##  DFull by orthogonal transformations U and V to diagonal form.  
E 3
   ##  The diagonal elements S[i] are the singular values of this 
D 3
   ##  FFull.  The columns of U are the corresponding left singular
E 3
I 3
   ##  DFull.  The columns of U are the corresponding left singular
E 3
   ##  Vectors, and the columns of V the right singular vectors.
   ##
   ##  On Entry:
   ##
D 3
   ##     this      FFull where this.numofRows() >= n.
   ##               Contains the FFull whose singular value
   ##               decomposition is to be computed.  This FFull
E 3
I 3
   ##     this      DFull where this.numofRows() >= n.
   ##               Contains the DFull whose singular value
   ##               decomposition is to be computed.  This DFull
E 3
   ##               is destroyed by svDecompose
   ##
   ##     n         int
   ##               n is the number of columns of the section of this
D 3
   ##               FFull that is to be used.
E 3
I 3
   ##               DFull that is to be used.
E 3
   ##
   ##     p         int
   ##               p is the number of rows of the section of this 
D 3
   ##               FFull that is to be used.
E 3
I 3
   ##               DFull that is to be used.
E 3
   ##
   ##     job       int
   ##               job controls the computation of the singular
   ##               vectors.  It has the decimal expansion AB
   ##               with the following meaning:
   ##
   ##                    A == 0    Do not compute the left singular
   ##                              vectors.
   ##                    A == 1    Return the n left singular vectors
   ##                              in U.
   ##                    A >= 2    Return the first min(n,p) singluar
   ##                              vectors in U.
   ##                    B == 0    Do not compute the right singular
   ##                              vectors.
   ##                    B == 1    Return the right singular vectors
   ##                              in V.
   ##
   ##  On Return:
   ##
D 3
   ##     S         float[MM], where MM = Math.min(n+1,p).    
E 3
I 3
   ##     S         double[MM], where MM = Math.min(n+1,p).    
E 3
   ##               the first min(n,p) entries of S contain the 
D 3
   ##               singular values of this FFull arranged in 
E 3
I 3
   ##               singular values of this DFull arranged in 
E 3
   ##               descending order of magnitude.
   ##
D 3
   ##     E         float[p]
E 3
I 3
   ##     E         double[p]
E 3
   ##               E ordinarily contains zeros.  However see the 
   ##               discussion of info for exceptions.
   ##
D 3
   ##     U         float[n][k], where if job(A) == 1 then k == n
E 3
I 3
   ##     U         double[n][k], where if job(A) == 1 then k == n
E 3
   ##                               else k == Min(n,p)
D 3
   ##               U contains the FFull of right singular vectors.
E 3
I 3
   ##               U contains the DFull of right singular vectors.
E 3
   ##               U is not referenced if job(A) == 0.  
   ##
D 3
   ##     V         float[p][p]
   ##               V contains the FFull of right singular vectors.
E 3
I 3
   ##     V         double[p][p]
   ##               V contains the DFull of right singular vectors.
E 3
   ##               V is not referenced if job == 0.  
   ##
   ##     info      int
   ##               The singular values (and their corresponding
   ##               singular vectors) S(info),S(info+1),...,S(M-1)
   ##               are correct (here M=min(n,p)).  Thus if 
   ##               info == 0, all the singular values and their 
   ##               vectors are correct.  In any event, the matrix
   ##               B = U.transpose()*this*V is the bidiagonal matrix
   ##               with the elements of S on its diagonal and the 
   ##               elements of E on its super-diagonal.  Thus the 
   ##               singular values of this and B are the same.
   ##*/


D 3
  public int svDecompose(float[] S, float[] E, FFull U, FFull V, int job) {
E 3
I 3
  public int svDecompose(double[] S, double[] E, DFull U, DFull V, int job) {
E 3
    
D 3
    float[] W = new float[rows];
E 3
I 3
    double[] W = new double[rows];
E 3
    int info = 0;
    
    /*##  
      ##  This is the maximum number of iterations.
      ##*/
    int MAXIT = 30;

    /*##  
      ##  Determine what is to be computed
      ##*/

    boolean wantU = false;
    boolean wantV = false;
    int jobu = (job%100)/10;
    int NCU = rows;
    if(jobu > 1) 
      NCU = Math.min(cols,rows);
    if(jobu != 0) 
      wantU = true;
    if(job%10 != 0) 
      wantV = true;
    int NCT = Math.min(rows-1,cols);
    int NRT = Math.max(0,Math.min(cols-2,rows));
    int lu = Math.max(NCT,NRT);
    for(int q=0;q<lu;q++) {
      int qp = q+1;
      if(q < NCT) { 
	S[q] = this.nrm2(rows-q,1,q,q);
	if(S[q] != 0) {
	  if(this.Mat[q][q] != 0) 
D 3
	    S[q] = FUtil.signOf(S[q],this.Mat[q][q]);
E 3
I 3
	    S[q] = DUtil.signOf(S[q],this.Mat[q][q]);
E 3
	  this.scal(rows-q,1/S[q],1,q,q);
	  this.Mat[q][q]+=1;
	}
	S[q] = -S[q];
      }
      for(int j=qp;j<cols;j++) {
	if(q < NCT) 
	  if(S[q] != 0) {
D 3
	    float T = -this.dot(rows-q,1,q,q,this,1,q,j)/this.Mat[q][q];
E 3
I 3
	    double T = -this.dot(rows-q,1,q,q,this,1,q,j)/this.Mat[q][q];
E 3
	    this.axpy(rows-q,T,1,q,q,this,1,q,j);
	  }
	E[j] = this.Mat[q][j];
      }
      if(wantU && q<NCT) 
	for(int i=q;i<rows;i++) 
	  U.Mat[i][q] = this.Mat[i][q];
      
      /*##  
       ##  Compute the q-th row transformation and place the q-th
       ##   super-diagonal in E[q]  
       ##*/

      if(q < NRT) {
D 3
	E[q] = FUtil.nrm2(cols-qp,E,1,qp);
E 3
I 3
	E[q] = DUtil.nrm2(cols-qp,E,1,qp);
E 3
	if(E[q] != 0) {
	  if(E[qp] != 0) 
D 3
	    E[q] = FUtil.signOf(E[q],E[qp]);
	  FUtil.scal(cols-qp,1/E[q],E,1,qp);
E 3
I 3
	    E[q] = DUtil.signOf(E[q],E[qp]);
	  DUtil.scal(cols-qp,1/E[q],E,1,qp);
E 3
	  E[qp]+=1;
	}
	E[q] = -E[q];
	if(qp < rows && E[q] != 0) {
	  for(int i=qp;i<rows;i++) 
	    W[i] = 0;
	  for(int j=qp;j<cols;j++) 
	    this.axpy(rows-qp,E[j],1,qp,j,W,1,qp);
	  for(int j=qp;j<cols;j++) 
	    this.axpy(rows-qp,-E[j]/E[qp],W,1,qp,1,qp,j);
	}
	if(wantV) 
	  for(int i=qp;i<cols;i++) 
	    V.Mat[i][q] = E[i];
      }
    }
    int M = Math.min(rows+1,cols);
    if(NCT < cols) 
      S[NCT] = this.Mat[NCT][NCT];
    if(rows < M) 
      S[M-1] = 0;
    if(NRT+1 < M) 
      E[NRT] = this.Mat[NRT][M-1];
    E[M-1] = 0;

    if(wantU) 
      U.generateU(NCT,NCU,S);
    if(wantV) 
      V.generateV(NRT,E);

    int iter = 0;
    int MM = M;
    while(M>0) {
      if(iter >= MAXIT) 
	return M;
      else {
	int q = qgetter(M-2,S,E);
	if(q == M-2) {
	  q++;
	  if(S[q] < 0) {
	    S[q] = -S[q];
	    if(wantV) 
	      V.scal(cols,-1,1,0,q);
	  }
	  boolean notDone = true;
	  while(q < MM-1 && notDone) {
	    if(S[q] < S[q+1]) {
D 3
	      FUtil.swapElems(S,q,q+1);
E 3
I 3
	      DUtil.swapElems(S,q,q+1);
E 3

	      if(wantV && q < cols-1) 
		V.swap(cols,1,0,q,V,1,0,q+1);
	      if(wantU && q < rows-1) 
		U.swap(rows,1,0,q,U,1,0,q+1);

	      q++;
	    }
	    else
	      notDone = false;
	  }
	  iter = 0;
	  M--;
	}
	else {
	  int qs = this.findNextStep(q,M,S,E);
	  if(qs == q) {
	    q++;
D 3
	    FTrig Tg = this.fggetter(q,M,S,E);
E 3
I 3
	    DTrig Tg = this.fggetter(q,M,S,E);
E 3

	    for(int k=q;k<M-1;k++) {
D 3
	      FUtil.rotg(Tg);
E 3
I 3
	      DUtil.rotg(Tg);
E 3
	      if(k != q) 
		E[k-1] = Tg.getA();
	      Tg.setA(Tg.getCos()*S[k] + Tg.getSin()*E[k]);
	      E[k] = Tg.getCos()*E[k] - Tg.getSin()*S[k];
	      Tg.setB(Tg.getSin()*S[k+1]);
	      S[k+1] *= Tg.getCos();
	      if(wantV) 
		V.rot(cols,1,0,k,V,1,0,k+1,Tg);
D 3
	      FUtil.rotg(Tg);
E 3
I 3
	      DUtil.rotg(Tg);
E 3
	      S[k] = Tg.getA();
	      Tg.setA(Tg.getCos()*E[k] + Tg.getSin()*S[k+1]);
	      S[k+1] = -Tg.getSin()*E[k] + Tg.getCos()*S[k+1];
	      Tg.setB(Tg.getSin()*E[k+1]);
	      E[k+1] *= Tg.getCos();
	      if(wantU && k < rows-1) 
		U.rot(rows,1,0,k,U,1,0,k+1,Tg);
	    }
	    E[M-2] = Tg.getA();
	    iter++;
	  }
	  else if(qs == M-1) {
	    q++;
	    int MMOne = M-2;
D 3
	    FTrig Tg = new FTrig();
E 3
I 3
	    DTrig Tg = new DTrig();
E 3
	    Tg.setB(E[MMOne]);
	    E[MMOne] = 0;
	    for(int k=MMOne;k>=q;k--) {
	      Tg.setA(S[k]);
D 3
	      FUtil.rotg(Tg);
E 3
I 3
	      DUtil.rotg(Tg);
E 3
	      S[k] = Tg.getA();
	      if(k != q) {
		Tg.setB(-Tg.getSin()*E[k-1]);
		E[k-1] *= Tg.getCos();
	      }
	      if(wantV) 
		V.rot(cols,1,0,k,V,1,0,MMOne+1,Tg);
	    }
	  }
	  else {
	    q = qs;
D 3
	    FTrig Tg = new FTrig();
E 3
I 3
	    DTrig Tg = new DTrig();
E 3
	    Tg.setB(E[q]);
	    E[q] = 0;
	    q++;
	    for(int k=q;k<M;k++) {
	      Tg.setA(S[k]);
D 3
	      FUtil.rotg(Tg);
E 3
I 3
	      DUtil.rotg(Tg);
E 3
	      S[k] = Tg.getA();
	      Tg.setB(-Tg.getSin()*E[k]);
	      E[k] *= Tg.getCos();
	      if(wantU) 
		U.rot(rows,1,0,k,U,1,0,q-1,Tg);
	    }
	  }
	}
      }
    }
    return info;
  }
D 3
  private void generateU(int NCT, int NCU, float[] S) {
E 3
I 3
  private void generateU(int NCT, int NCU, double[] S) {
E 3
    for(int j=NCT;j<NCU;j++) {
      for(int i=0;i<cols;i++) {
	this.Mat[i][j] = 0;
      }
      this.Mat[j][j] = 1;
    }
    if(NCT > 0) {
      for(int q=NCT-1;q>=0;q--) {
	if(S[q] != 0) {
	  for(int j=q+1;j<NCU;j++) {
D 3
	    float T = -this.dot(cols-q,1,q,q,this,1,q,j)/this.Mat[q][q];
E 3
I 3
	    double T = -this.dot(cols-q,1,q,q,this,1,q,j)/this.Mat[q][q];
E 3
	    this.axpy(cols-q,T,1,q,q,this,1,q,j);
	  }
	  this.scal(cols-q,-1,1,q,q);
	  this.Mat[q][q]++;
	  for(int i=0;i<q;i++) 
	    this.Mat[i][q] = 0;
	}
	else {
	  for(int i=0;i<cols;i++) 
	    this.Mat[i][q] = 0;
	  this.Mat[q][q] = 1;
	}
      }
    }
  }
D 3
  private void generateV(int NRT, float[] E) {
E 3
I 3
  private void generateV(int NRT, double[] E) {
E 3
    for(int q=cols-1;q>=0;q--) {
      int qp = q+1;
      if((q < NRT) && (E[q] != 0)) {
	for(int j=qp;j<rows;j++) {
D 3
	  float T = -this.dot(rows-qp,1,qp,q,this,1,qp,j)/this.Mat[qp][q];
E 3
I 3
	  double T = -this.dot(rows-qp,1,qp,q,this,1,qp,j)/this.Mat[qp][q];
E 3
	  this.axpy(rows-qp,T,1,qp,q,this,1,qp,j);
	}	    
      }
      for(int i=0;i<rows;i++) 
	this.Mat[i][q] = 0;
      this.Mat[q][q] = 1;
    }
  }
D 3
  private int qgetter(int st, float[] S, float[] E) {
E 3
I 3
  private int qgetter(int st, double[] S, double[] E) {
E 3
    for(int q=st;q >= 0;q--) {
D 3
      float Test = Math.abs(S[q]) + Math.abs(S[q+1]);
      float ZTest = Test + Math.abs(E[q]);
E 3
I 3
      double Test = Math.abs(S[q]) + Math.abs(S[q+1]);
      double ZTest = Test + Math.abs(E[q]);
E 3
      if(ZTest == Test) {
	E[q] = 0;
	return q;
      }
    }
    return -1;
  }
D 3
  private int findNextStep(int q, int M, float[] S, float[] E) {
E 3
I 3
  private int findNextStep(int q, int M, double[] S, double[] E) {
E 3
    for(int qs=M-1;qs>q;qs--) {
D 3
      float Test = 0;
E 3
I 3
      double Test = 0;
E 3
      if(qs != M-1) 
	Test += Math.abs(E[qs]);
      if(qs != q+1) 
	Test += Math.abs(E[qs-1]);
D 3
      float Ztest = Test + Math.abs(S[qs]);
E 3
I 3
      double Ztest = Test + Math.abs(S[qs]);
E 3
      if(Ztest == Test) {
	S[qs] = 0;
	return qs;
      }
    }
    return q;
  }
D 3
  private FTrig fggetter(int q, int M, float[] S, float[] E) {
    FTrig Tg = new FTrig();
    float scale = FUtil.aMax(S[M-1],S[M-2],E[M-2],S[q],E[q]);
    float SM = S[M-1]/scale;
    float SMM = S[M-2]/scale;
    float EMM = E[M-2]/scale;
    float Sq = S[q]/scale;
    float Eq = E[q]/scale;
    float B = ((SMM + SM)*(SMM - SM) + (float)Math.pow(EMM,2))/2;
    float C = (float)Math.pow(SM*EMM,2);
    float shift = 0;
E 3
I 3
  private DTrig fggetter(int q, int M, double[] S, double[] E) {
    DTrig Tg = new DTrig();
    double scale = DUtil.aMax(S[M-1],S[M-2],E[M-2],S[q],E[q]);
    double SM = S[M-1]/scale;
    double SMM = S[M-2]/scale;
    double EMM = E[M-2]/scale;
    double Sq = S[q]/scale;
    double Eq = E[q]/scale;
    double B = ((SMM + SM)*(SMM - SM) + Math.pow(EMM,2))/2;
    double C = Math.pow(SM*EMM,2);
    double shift = 0;
E 3
    if(B != 0 || C != 0) {
D 3
      shift = (float)Math.sqrt(Math.pow(B,2) + C);
E 3
I 3
      shift = Math.sqrt(Math.pow(B,2) + C);
E 3
      if(B < 0) 
	shift = -shift;
      shift = C/(B+shift);
    }
    Tg.setA((Sq + SM)*(Sq - SM) - shift);
    Tg.setB(Sq*Eq);
  
    return Tg;
  }

  /*##
   ##  qrDecompose uses Householder transformations to compute the
D 3
   ##  QR factorization of an n by p FFull.  Column pivoting
E 3
I 3
   ##  QR factorization of an n by p DFull.  Column pivoting
E 3
   ##  based on the 2-norms of the reduced columns may be
   ##  performed at the user's option.
   ##
   ##  On Entry:
   ##
D 3
   ##    this    FFull - Mat[L][p], where L >= n            
   ##            FFull contains the FFull whose decomposition is to 
E 3
I 3
   ##    this    DFull - Mat[L][p], where L >= n            
   ##            DFull contains the DFull whose decomposition is to 
E 3
   ##            be computed.
   ##
   ##
   ##    n       int 
D 3
   ##            n is the number of rows of FFull.Mat to be used in
E 3
I 3
   ##            n is the number of rows of DFull.Mat to be used in
E 3
   ##            the calculation
   ##
   ##    p       int 
D 3
   ##            p is the number of columns of FFull.Mat to be used
E 3
I 3
   ##            p is the number of columns of DFull.Mat to be used
E 3
   ##            in the calculation
   ##
   ##    pivot   int[p]
   ##            pivot contains ints that control the selection
D 3
   ##            of the pivot columns.  The k-th column FFull.Mat[0][k]
E 3
I 3
   ##            of the pivot columns.  The k-th column DFull.Mat[0][k]
E 3
   ##            is placed in one of three classes according to the 
   ##            value of pivot[k]:
   ##
D 3
   ##               if pivot[k] > 0, then FFull.getColumn(k,0) is an
E 3
I 3
   ##               if pivot[k] > 0, then DFull.getColumn(k,0) is an
E 3
   ##                                  initial column.
   ##
D 3
   ##               if pivot[k] == 0, then FFull.getColumn(k,0) is a
E 3
I 3
   ##               if pivot[k] == 0, then DFull.getColumn(k,0) is a
E 3
   ##                                  free column.
   ##
D 3
   ##               if pivot[k] < 0, then FFull.getColumn(k,0) is a 
E 3
I 3
   ##               if pivot[k] < 0, then DFull.getColumn(k,0) is a 
E 3
   ##                                  final column.
   ##
   ##            Before the decomposition is computed, initial columns
D 3
   ##            are moved to the beginning of FFull.Mat and final
E 3
I 3
   ##            are moved to the beginning of DFull.Mat and final
E 3
   ##            columns to the end.  Both initial and final columns
   ##            are frozen in place during the computation and only 
   ##            free columns are moved.  At the k-th stage of the 
D 3
   ##            reduction, if FFull.getColumn(k,0) is occupied by a
E 3
I 3
   ##            reduction, if DFull.getColumn(k,0) is occupied by a
E 3
   ##            free column it is interchanged with the free column of
   ##            largest reduced norm.  pivot is not referenced if 
   ##            job == 0.
   ##
   ##
   ##  On Return
   ##
D 3
   ##    this    FFull.Mat contains in its upper triangle the upper
E 3
I 3
   ##    this    DFull.Mat contains in its upper triangle the upper
E 3
   ##            triangular matrix R of the QR factorization.
D 3
   ##            Below its diagonal FFull.Mat contains information 
E 3
I 3
   ##            Below its diagonal DFull.Mat contains information 
E 3
   ##            from which the orthogonal part of the decomposition
   ##            can be recovered.  Note that if pivoting has
   ##            been requested, the decomposition is not that
D 3
   ##            of the original FFull.Mat, but that of FFull.Mat
E 3
I 3
   ##            of the original DFull.Mat, but that oD DFull.Mat
E 3
   ##            with its columns permuted as described by pivot.
   ##
D 3
   ##    QRaux   float[p]
E 3
I 3
   ##    QRaux   double[p]
E 3
   ##            QRaux contains further information required to recover 
   ##            the orthogonal part of the decomposition.
   ##
   ##    pivot   pivot[k-1] contains the index of the column of the
   ##            original matrix that has been interchanged into 
   ##            the k-th column, if pivoting was requested.
   ##*/

D 3
  public void qrPDecompose(float[] QRaux) {
E 3
I 3
  public void qrPDecompose(double[] QRaux) {
E 3
    Pul P = new Pul(0,-1);
    this.qrPivot(P);
    this.qrDecom(P, QRaux);
  }
  private void qrPivot(Pul P) {
    this.swaperSki(P);

    P.pu = cols-1;
    for(int j=P.pu;j>=0;j--) {
      if(pivot[j] < 0) {
	pivot[j] = -pivot[j];
	if(j != P.pu) {
	  this.swap(rows,1,0,P.pu,this,1,0,j);
D 3
	  FUtil.swapElems(pivot,P.pu,j);
E 3
I 3
	  DUtil.swapElems(pivot,P.pu,j);
E 3
	}
	P.pu--;
      }
    }
  }
  void swaperSki(Pul P) {
    for(int j=0;j<cols;j++) {
      boolean swapj = pivot[j] > 0;
      if(pivot[j] < 0) 
	pivot[j] = -j-1;
      else 
	pivot[j] = j+1;

      if(swapj) 
	this.swap2(j,P);
    }
  }
  void swap2(int j, Pul P) {
    if(j != P.pl) 
      this.swap(rows,1,0,P.pl,this,1,0,j);
    pivot[j] = pivot[P.pl];
    pivot[P.pl] = j+1;
    P.pl++;
  }
   
D 3
  public void qrDecompose(float[] QRaux) {
E 3
I 3
  public void qrDecompose(double[] QRaux) {
E 3
    Pul P = new Pul(0,-1);
    this.qrDecom(P,QRaux);
  }
D 3
  private void qrDecom(Pul P, float[] QRaux) {
    float[] Work = new float[cols];
E 3
I 3
  private void qrDecom(Pul P, double[] QRaux) {
    double[] Work = new double[cols];
E 3

    for(int j=P.pl;j<=P.pu;j++) {
      QRaux[j] = this.nrm2(rows,1,0,j);
      Work[j] = QRaux[j];
    }
    int qup = Math.min(rows,cols);
    for(int q=0;q<qup;q++) {
      if(q >= P.pl && q<P.pu) {
D 3
	float maxnorm = 0;
E 3
I 3
	double maxnorm = 0;
E 3
	int maxj = q;
	for(int j=q;j<=P.pu;j++) {
	  if(QRaux[j] >= maxnorm) {
	    maxnorm = QRaux[j];
	    maxj = j;
	  }
	}
	if(maxj != q) {
	  this.swap(rows,1,0,q,this,1,0,maxj);
	  QRaux[maxj] = QRaux[q];
	  Work[maxj] = Work[q];
D 3
	  FUtil.swapElems(pivot,maxj,q);
E 3
I 3
	  DUtil.swapElems(pivot,maxj,q);
E 3
	}
      }
      QRaux[q] = 0;
      if(q < rows-1) {
D 3
	float normxq = this.nrm2(rows-q,1,q,q);
E 3
I 3
	double normxq = this.nrm2(rows-q,1,q,q);
E 3
	if(normxq != 0) {
	  if(this.Mat[q][q] != 0) 
D 3
	    normxq = FUtil.signOf(normxq,this.Mat[q][q]);
E 3
I 3
	    normxq = DUtil.signOf(normxq,this.Mat[q][q]);
E 3
	  this.scal(rows-q,1/normxq,1,q,q);
	  this.Mat[q][q]+=1;
	  for(int j=q+1;j<cols;j++) {
D 3
	    float T = -this.dot(rows-q,1,q,q,this,1,q,j)/this.Mat[q][q];
E 3
I 3
	    double T = -this.dot(rows-q,1,q,q,this,1,q,j)/this.Mat[q][q];
E 3
	    this.axpy(rows-q,T,1,q,q,this,1,q,j);
	    if(j >= P.pl && j <= P.pu) {
	      if(QRaux[j] != 0) {
D 3
		float TT = 1 - (float)Math.pow(Math.abs(this.Mat[q][j])/
E 3
I 3
		double TT = 1 - Math.pow(Math.abs(this.Mat[q][j])/
E 3
					       QRaux[j],2);
		TT = Math.max(TT,0);
		T = TT;
D 3
		TT = 1 + (float).5*TT*(float)Math.pow(QRaux[j]/Work[j],2);
E 3
I 3
		TT = 1 + .5*TT*Math.pow(QRaux[j]/Work[j],2);
E 3
		if(TT != 1) 
D 3
		  QRaux[j] *= (float)Math.sqrt(T);
E 3
I 3
		  QRaux[j] *= Math.sqrt(T);
E 3
		else {
		  QRaux[j] = this.nrm2(rows-q-1,1,q+1,j);
		  Work[j] = QRaux[j];
		}
	      }
	    }
	  }
	  QRaux[q] = this.Mat[q][q];
	  this.Mat[q][q] = -normxq;
	}
      }
    }
  }

  /*##
   ##  The following qr*** routines apply the output of qrDecompose to 
   ##  compute coordinate transformations, projections, and least squares
   ##  solutions.
   ##  for k < Min(n,p), let XK be the matrix
   ##
   ##        XK = (this.getColumn(pivot(0)-1,0),
   ##                 this.getColumn(pivot(1)-1,0),
   ##                 ... ,this.getColumn(pivot(k)-1,0));
   ##
   ##  formed from columns pivot[0], ... , pivot[k] of the original
D 3
   ##  n X p matrix FFull.Mat that was input to qrDecompose (if no
E 3
I 3
   ##  n X p matrix DFull.Mat that was input to qrDecompose (if no
E 3
   ##  pivoting was done, XK consists of the first k+1 columns of 
   ##  FFull.Mat in their original order).  qrDecompose produces a 
   ##  factored orthogonal matrix Q and an upper triang. matrix R s.t.
   ##
   ##          XK = Q * (R)
   ##                   (0)
   ##
   ##  this information is contained in coded form in FFull.Mat and QRaux
   ##
   ##  On Entry
   ##
D 3
   ##    this   FFull.Mat[n][p]
   ##           FFull.Mat contains the output of qrDecompose
E 3
I 3
   ##    this   DFull.Mat[n][p]
   ##           DFull.Mat contains the output of qrDecompose
E 3
   ##
   ##    n      int 
   ##           n is the number of rows of the matrix XK.  It must
   ##           have the same value as n in qrDecompose.
   ##
   ##    k      int 
   ##           k is the number of columns of the matrix XK.  k
   ##           must not be greater than min(n,p), where p is the 
   ##           same as in qrDecompose.
   ##
D 3
   ##    QRaux  float[p]
E 3
I 3
   ##    QRaux  double[p]
E 3
   ##           QRaux contains the auxiliary output from qrDecompose.
   ##
D 3
   ##    Y      float[n]
E 3
I 3
   ##    Y      double[n]
E 3
   ##           Y contains the vector that is to be manipulated
   ##           by qr***.
   ##
   ##  On Return from its respective function
   ##
   ##  qrQy:
D 3
   ##    Qy     float[n]
E 3
I 3
   ##    Qy     double[n]
E 3
   ##           Qy contains Q*Y
   ##
   ##  qrQty:
D 3
   ##    Qty    float[n]
E 3
I 3
   ##    Qty    double[n]
E 3
   ##           Qty contains Q.transpose()*Y
   ##
   ##  qrQB:
D 3
   ##    B      float[k]
E 3
I 3
   ##    B      double[k]
E 3
   ##           B contains the solution of the least squares problem
   ##
   ##                minimize norm2(Y - XK*B),
   ##
   ##           (Note that if pivoting was requested in qrDecompose, 
   ##           the j-th component of B will be associated with column
   ##           pivot[j-1]-1 of the original FFull.Mat that was input
   ##           into qrDecompose.)
   ##
   ##    info   int
   ##           info is zero unless R is exactly singular in the 
   ##           computation of B.  In this case, info is the index plus
   ##           one of the first zero diagonal element of R and B is 
   ##           left unaltered.
   ##
   ##  qrQRSD:
D 3
   ##    Rsd    float[n]
E 3
I 3
   ##    Rsd    double[n]
E 3
   ##           Rsd contains the least squares residual Y - XK*B,
   ##           Rsd is also the orthogonal projection of Y onto the
   ##           orthogonal complement of the column space of XK.
   ##
   ##  qrXB:
D 3
   ##    Xb     float[n]
E 3
I 3
   ##    Xb     double[n]
E 3
   ##           Xb contains the least squares approximation XK*B,
   ##           Xb is also the orthogonal projection of Y onto the 
D 3
   ##           column space of FFull.Mat.
E 3
I 3
   ##           column space of DFull.Mat.
E 3
   ##*/
  
D 3
  public void qrQy(float[] QRaux, float[] Y, float[] Qy) {
E 3
I 3
  public void qrQy(double[] QRaux, double[] Y, double[] Qy) {
E 3
    
    int k = Math.min(rows,cols);
    int ju = Math.min(k,rows-1) - 1;
    
    if(ju < 0) 
      Qy[0] = Y[0];
    else {
D 3
      FUtil.copy(rows,Y,1,0,Qy,1,0);
E 3
I 3
      DUtil.copy(rows,Y,1,0,Qy,1,0);
E 3
      for(int j=ju;j>=0;j--) 
	this.qrsolver(j,Qy,QRaux);
    }
  }
  
  /*  This is completely tested though not thoroughly  */
  
D 3
  public void qrQty(float[] QRaux, float[] Y,float[] Qty) {
E 3
I 3
  public void qrQty(double[] QRaux, double[] Y,double[] Qty) {
E 3
    
    int k = Math.min(rows,cols);

    int ju = Math.min(k,rows-1) - 1;
    
    if(ju < 0) 
      Qty[0] = Y[0];
    else {
D 3
      FUtil.copy(rows,Y,1,0,Qty,1,0);
E 3
I 3
      DUtil.copy(rows,Y,1,0,Qty,1,0);
E 3
      for(int j=0;j<=ju;j++) 
	this.qrsolver(j,Qty,QRaux);
    }
  }

  /*  Works great  */

D 3
  public int qrB(float[] QRaux, float[] Y,
		 float[] Qty, float[] B) {
E 3
I 3
  public int qrB(double[] QRaux, double[] Y,
		 double[] Qty, double[] B) {
E 3

    int k = Math.min(cols,rows);

    int ju = Math.min(k,rows-1) - 1;
    
    qrQty(QRaux,Y,Qty);

    if(ju < 0) {
      if(this.Mat[0][0] == 0) 
	return 1;
      else 
	B[0] = Y[0]/this.Mat[0][0];
    }
    else {
D 3
      FUtil.copy(k,Qty,1,0,B,1,0);
E 3
I 3
      DUtil.copy(k,Qty,1,0,B,1,0);
E 3
      for(int j=k-1;j>=0;j--) {
	if(this.Mat[j][j] == 0) 
	  return j+1;
	else {
	  B[j] /= this.Mat[j][j];
	  if(j > 0) 
	    this.axpy(j,-B[j],1,0,j,B,1,0);
	}
      }
    }
    return 0;
  }

  // XB is tested  // 
D 3
  public void qrXB(float[] QRaux, float[] Y,
		  float[] Qty, float[] Xb) {
E 3
I 3
  public void qrXB(double[] QRaux, double[] Y,
		  double[] Qty, double[] Xb) {
E 3
    
    int k = Math.min(cols,rows);

    int ju = Math.min(k,rows-1) - 1;
    
    qrQty(QRaux,Y,Qty);

    if(ju < 0) 
      Xb[0] = Y[0];
    else {
D 3
      FUtil.copy(k,Qty,1,0,Xb,1,0);
E 3
I 3
      DUtil.copy(k,Qty,1,0,Xb,1,0);
E 3
      for(int i=k;i<rows;i++) 
	Xb[i] = 0;
      for(int j=ju;j>=0;j--) 
	this.qrsolver(j,Xb,QRaux);
    }
  }
D 3
  public void qrRSD(float[] QRaux, float[] Y,
		    float[] Qty, float[] Rsd) {
E 3
I 3
  public void qrRSD(double[] QRaux, double[] Y,
		    double[] Qty, double[] Rsd) {
E 3

    int k = Math.min(cols,rows);
    int ju = Math.min(k,rows-1) - 1;
    
    qrQty(QRaux,Y,Qty);
    
    if(ju < 0) 
      Rsd[0] = 0;
    else {
      int kp = k+1;
      if(k < rows) 
D 3
	FUtil.copy(rows-k,Qty,1,k,Rsd,1,k);
E 3
I 3
	DUtil.copy(rows-k,Qty,1,k,Rsd,1,k);
E 3
      for(int i=0;i<k;i++) 
	Rsd[i] = 0;
      for(int j=ju;j>=0;j--) 
	this.qrsolver(j,Rsd,QRaux);
    }
  }
D 3
  private void qrsolver(int j, float[] R, float[] QRaux) {
E 3
I 3
  private void qrsolver(int j, double[] R, double[] QRaux) {
E 3
    if(QRaux[j] != 0) {
D 3
      float Temp = this.Mat[j][j];
E 3
I 3
      double Temp = this.Mat[j][j];
E 3
      this.Mat[j][j] = QRaux[j];
D 3
      float T = -this.dot(rows-j,1,j,j,R,1,j)/this.Mat[j][j];
E 3
I 3
      double T = -this.dot(rows-j,1,j,j,R,1,j)/this.Mat[j][j];
E 3
      this.axpy(rows-j,T,1,j,j,R,1,j);
      this.Mat[j][j] = Temp;
    }
  }

D 3
  public void chUpdate(float[] X,float[][] Z,  
		     float[] Y, float[] Rho, float[] C, float[] S) {
E 3
I 3
  public void chUpdate(double[] X,double[][] Z,  
		     double[] Y, double[] Rho, double[] C, double[] S) {
E 3
    
    // Update the matrix //

    for(int j=0;j<cols;j++) {
D 3
      float Xj = X[j];
E 3
I 3
      double Xj = X[j];
E 3
      
      for(int i=0;i<j;i++) {
D 3
	float T = C[i]*this.Mat[i][j] + S[i]*Xj;
E 3
I 3
	double T = C[i]*this.Mat[i][j] + S[i]*Xj;
E 3
	Xj = C[i]*Xj - S[i]*this.Mat[i][j];
	this.Mat[i][j] = T;
      }
D 3
      FTrig Tg = new FTrig(Xj,C[j],S[j]);
E 3
I 3
      DTrig Tg = new DTrig(Xj,C[j],S[j]);
E 3
      this.rotg(j,j,Tg);
      C[j] = Tg.getCos();
      S[j] = Tg.getSin();
    }
    for(int j=0;j<Z[0].length;j++) {
D 3
      float Zeta = Y[j];
E 3
I 3
      double Zeta = Y[j];
E 3
      for(int i=0;i<cols;i++) {
D 3
	float T = C[i]*Z[i][j] + S[i]*Zeta;
E 3
I 3
	double T = C[i]*Z[i][j] + S[i]*Zeta;
E 3
	Zeta = C[i]*Zeta - S[i]*Z[i][j];
	Z[i][j] = T;
      }
D 3
      float azeta = Math.abs(Zeta);
E 3
I 3
      double azeta = Math.abs(Zeta);
E 3
      if(azeta != 0 && Rho[j] >= 0) {
D 3
	float scale = azeta*Rho[j];
	Rho[j] = scale*(float)Math.sqrt(Math.pow(azeta/scale,2)+
E 3
I 3
	double scale = azeta*Rho[j];
	Rho[j] = scale*Math.sqrt(Math.pow(azeta/scale,2)+
E 3
					Math.pow(Rho[j]/scale,2));
      }
    }
  }
D 3
  public int chDowndate(float[] X,float[][] Z,
		      float[] Y,float[] Rho,float[] C,float[] S) {
E 3
I 3
  public int chDowndate(double[] X,double[][] Z,
		      double[] Y,double[] Rho,double[] C,double[] S) {
E 3
    
    int info = 0;
D 3
    float Zeta;
E 3
I 3
    double Zeta;
E 3

    S[0] = X[0]/this.Mat[0][0];
    for(int j=1;j<cols;j++) {
      S[j] = X[j] - this.dot(j,1,0,j,S,1,0);
      S[j] = S[j]/this.Mat[j][j];
    }
D 3
    float norm = FUtil.nrm2(cols,S,1,0);
E 3
I 3
    double norm = DUtil.nrm2(cols,S,1,0);
E 3
    if(norm >= 1) 
      info = -1;
    else {
D 3
      float alpha = (float)Math.sqrt(1 - (float)Math.pow(norm,2));
E 3
I 3
      double alpha = Math.sqrt(1 - Math.pow(norm,2));
E 3
      for(int i=cols-1;i>=0;i--) {
D 3
	float scale = alpha + Math.abs(S[i]);
	float A = alpha/scale;
	float B = S[i]/scale;
	norm = (float)Math.sqrt(Math.pow(A,2) + Math.pow(B,2));
E 3
I 3
	double scale = alpha + Math.abs(S[i]);
	double A = alpha/scale;
	double B = S[i]/scale;
	norm = Math.sqrt(Math.pow(A,2) + Math.pow(B,2));
E 3
	C[i] = A/norm;
	S[i] = B/norm;
	alpha = scale*norm;
      }
      for(int j=0;j<cols;j++) {
D 3
	float XX = 0;
E 3
I 3
	double XX = 0;
E 3
	for(int i=j;i>=0;i--) {
D 3
	  float T = C[i]*XX + S[i]*this.Mat[i][j];
E 3
I 3
	  double T = C[i]*XX + S[i]*this.Mat[i][j];
E 3
	  this.Mat[i][j] = C[i]*this.Mat[i][j] - S[i]*XX;
	  XX = T;
	}
      }
      for(int j=0;j<Z[0].length;j++) {
	Zeta = Y[j];
	for(int i=0;i<cols;i++) {
	  Z[i][j] = (Z[i][j] - S[i]*Zeta)/C[i];
	  Zeta = C[i]*Zeta - S[i]*Z[i][j];
	}
D 3
	float azeta = Math.abs(Zeta);
E 3
I 3
	double azeta = Math.abs(Zeta);
E 3
	if(azeta > Rho[j]) {
	  info = 1;
	  Rho[j] = -1;
	}
	else 
D 3
	  Rho[j] *= (float)Math.sqrt(1-(float)Math.pow(azeta/Rho[j],2));
E 3
I 3
	  Rho[j] *= Math.sqrt(1-Math.pow(azeta/Rho[j],2));
E 3
      }
    }
    return info;
  }

D 3
  public void chExchange(int k, int q, FFull Z,
		       float[] C, float[] S, int job) {
E 3
I 3
  public void chExchange(int k, int q, DFull Z,
		       double[] C, double[] S, int job) {
E 3
    
    /* k and l are java (0 based) indices */

    int km = k-1;
    int kp = k+1;
    int qmkp = q-k;
    int qm = q-1;
    
    if(job == 1) {
      for(int i=0;i<=q;i++) {
	int ii = q-i;
	S[i] = this.Mat[ii][q];
      }
      for(int j=qm;j>=k;j--) {
	for(int i=0;i<=j;i++) 
	  this.Mat[i][j+1] = this.Mat[i][j];
	this.Mat[j+1][j+1] = 0;
      }
      for(int i=0;i<k;i++) {
	int ii = q-i;
	this.Mat[i][k] = S[ii];
      }
D 3
      float T = S[0];
      FTrig Tg = new FTrig();
E 3
I 3
      double T = S[0];
      DTrig Tg = new DTrig();
E 3
      for(int i=0;i<qmkp;i++) {
	Tg.setA(S[i+1]);
	Tg.setB(T);
D 3
	FUtil.rotg(Tg);
E 3
I 3
	DUtil.rotg(Tg);
E 3
	S[i+1] = Tg.getA();
	T = S[i+1];
	C[i] = Tg.getCos();
	S[i] = Tg.getSin();
      }
      this.Mat[k][k] = T;
      for(int j=kp;j<cols;j++) {
	int iq = Math.max(0,q-j);
	for(int ii = iq;ii<qmkp;ii++) {
	  int i = qm-ii;
	  this.applyTrans(j,i,ii,C,S);
	}
      }
      for(int j=0;j<Z.cols;j++) 
	for(int ii=0;ii<qmkp;ii++) {
	  int i = qm - ii;
	  Z.applyTrans(j,i,ii,C,S);
	}
    }
    else {
      for(int i=0;i<=k;i++) {
	int ii = qmkp + i;
	S[ii] = this.Mat[i][k];
      }
      for(int j=k;j<q;j++) {
	for(int i=0;i<=j;i++) 
	  this.Mat[i][j] = this.Mat[i][j+1];
	S[j-k] = this.Mat[j+1][j+1];
      }
      for(int i=0;i<=k;i++) 
	this.Mat[i][q] = S[qmkp+1];

      for(int i=kp;i<=q;i++) 
	this.Mat[i][q] = 0;

      for(int j=k;j<cols;j++) {
	if(j != k) {
	  int iu = Math.min(j-1,qm);
	  for(int i=k;i<=iu;i++) {
	    int ii = i-k;
	    this.applyTrans(j,i,ii,C,S);
	  }
	}
	if(j < q) {
	  int jj = j-k;
D 3
	  FTrig Tg = new FTrig(S[jj],C[jj],S[jj]);
E 3
I 3
	  DTrig Tg = new DTrig(S[jj],C[jj],S[jj]);
E 3
	  this.rotg(j,j,Tg);
	  C[jj] = Tg.getCos();
	  S[jj] = Tg.getSin();
	}
      }
      for(int j=0;j<Z.cols;j++) 
	for(int i=k;i<q;i++) {
	  int ii = i-k;
	  Z.applyTrans(j,i,ii,C,S);
	}
    }
  } 	   
D 3
  private void applyTrans(int j, int i, int ii, float[] C, float[] S) {
    float T = C[ii]*this.Mat[i][j] + S[ii]*this.Mat[i+1][j];
E 3
I 3
  private void applyTrans(int j, int i, int ii, double[] C, double[] S) {
    double T = C[ii]*this.Mat[i][j] + S[ii]*this.Mat[i+1][j];
E 3
    this.Mat[i+1][j] = C[ii]*this.Mat[i+1][j] - S[ii]*this.Mat[i][j];
    this.Mat[i][j] = T;
  }
	
  /*## 
D 3
   ##  FFull.factor factors a single precision floating point matrix by 
E 3
I 3
   ##  DFull.factor factors a single precision doubleing point matrix by 
E 3
   ##  Gaussian elimination.  
   ##   
D 3
   ##  FFull.factor is usually called by FFull.condition, but it can be
E 3
I 3
   ##  DFull.factor is usually called by DFull.condition, but it can be
E 3
   ##  called directly with a saving in time if Rcond is not needed.
   ##
   ##  On Entry:
   ##
D 3
   ##     this      FFull.Mat[n][n]
   ##               FFull.Mat is the matrix to be factored
E 3
I 3
   ##     this      DFull.Mat[n][n]
   ##               DFull.Mat is the matrix to be factored
E 3
   ##
   ##     n         int
D 3
   ##               n is the order of FFull.Mat
E 3
I 3
   ##               n is the order of DFull.Mat
E 3
   ##
   ##  On Return:
   ##
   ##     this      An upper triangular matrix and multipliers used to
   ##               obtain it.  The factorization can be written
   ##               A = L*U where L is a product of permutation and 
   ##               unit lower triangular matrices and U is upper
   ##               triangular.
   ##
   ##     pivot    int[] 
   ##               pivot is a vector of pivot indices
   ##
   ##     info      int
   ##               The returned value where:
   ##               info = 0  normal value
   ##               info = k  if U(k-1,k-1) == 0, indicates solve & 
   ##                determ will divide by 0 if called
   ##*/
  
  public void factor() 
       throws SingularMatrixException
  {
    int info = 0;
D 3
    float T;
E 3
I 3
    double T;
E 3

    int nm = cols - 1;
    if(cols > 1) {
      
      for(int k=0;k < nm; k++) {
	int kp = k+1;
	
	/*##
	 ##  Find L the pivot index  
	 ##*/
	
	int L = this.i_amax(cols-k,1,k,k) + k;
	
	pivot[k] = L+1;
	
	/*##
	 ##  Zero pivot implies this column already triangularized  
	 ##*/

	if(this.Mat[L][k] != 0) {
	  /*##
	   ##  Interchange if necessary 
	   ##*/
	    
	  if(L != k) 
	    this.swapElem(L,k,k,k);
	  
	  /*##
	   ##  Compute multipliers 
	   ##*/
	  
D 3
	  T = (float)-1.0/this.Mat[k][k];
E 3
I 3
	  T = -1.0/this.Mat[k][k];
E 3
	  this.scal(nm-k,T,1,kp,k);
	    
	  /*##
	   ##  Row elimination with column indexing 
	   ##*/
	  
	  for(int j=kp;j<cols;j++) {
	    T = this.Mat[L][j];
	    if(L != k) 
	      this.swapElem(L,j,k,j);
	    this.axpy(nm-k,T,1,kp,k,this,1,kp,j);
	  }
	}
	else {
	  info = k+1;
	}
      }
    }
    pivot[cols-1] = cols;
    if(this.Mat[cols-1][cols-1] == 0) 
      info = cols;
    if(info != 0)
      throw new SingularMatrixException(info);
  }
  
  /*##
D 3
   ##  FFull.condition factors by Gaussian Elimination and estimates the
   ##  condition of FFull.Mat.
E 3
I 3
   ##  DFull.condition factors by Gaussian Elimination and estimates the
   ##  condition of DFull.Mat.
E 3
   ##
   ##  If Rcond is not needed, factor is slightly faster.
   ##  To solve  Mat*X = B , follow condition by solve.
   ##  To compute  Inverse(Mat)*C , follow condition by solve.
   ##  To compute  Determinant(Mat) , follow condition by determ.
   ##  To compute  Inverse(Mat) , follow condition by inverse
   ##
   ##  On Entry
   ##
D 3
   ##    Mat     FFull.Mat[n][n]
E 3
I 3
   ##    Mat     DFull.Mat[n][n]
E 3
   ##            The matrix to be factored.
   ##
   ##    n       int
D 3
   ##            The order of FFull.Mat.
E 3
I 3
   ##            The order of DFull.Mat.
E 3
   ##
   ##  On Return
   ##
   ##    Mat     An upper triangular matrix and the multipliers
   ##            used to obtain it.  The factorization can be written
   ##            Mat = L*U  where  L  is a product of permutation and unit 
   ##            lower triangular matrices and  U  is upper trinagular.
   ##
   ##    pivot   int[n]
   ##            An array of pivot indices.
   ##
D 3
   ##    R       FRcond(int info, float Rcond)
E 3
I 3
   ##    R       DRcond(int info, double Rcond)
E 3
   ##            info:  The value returned from factor
   ##            Rcond:  An estimate of the reciprocal condition of Mat.
   ##            For the system  Mat*X = B , relative perturbations
   ##            in  Mat  and  B  of size  EPSILON  may cause
   ##            relative perturbations in  X  of size  EPSILON/Rcond .
   ##            If  Rcond  is so small that the logical expression
   ##                       1 + Rcond == 1
   ##            is true, then  Mat  may be singular to working
   ##            precision.  In particular,  Rcond  is zero if
   ##            exact singularity is detected or the estimate 
   ##            underflows.
   ##
D 3
   ##    Z       float[n]
E 3
I 3
   ##    Z       double[n]
E 3
   ##            A work vector whose contents are usually unimportant.
   ##            If  Mat  is close to a singular matrix, then  Z  is 
   ##            an approximate Null vector in the sense that
   ##            norm(Mat*Z) = Rcond*norm(Mat)*norm(Z) .
   ##*/

  public LNumber condition() 
       throws WrongDataTypeException, SingularMatrixException
  {
D 3
    Vector Z = new FVector(cols);
E 3
I 3
    Vector Z = new DVector(cols);
E 3
    return this.condition(Z);
  }
  public LNumber condition(Vector Ze) 
       throws WrongDataTypeException, SingularMatrixException
  {
    
D 3
    float[] Z = Ze.getFloatArray();
E 3
I 3
    double[] Z = Ze.getDoubleArray();
E 3
    
    /*##
     ##  Compute 1-Norm of A 
     ##*/
    
D 3
    float anorm = this.oneNorm();
    float ynorm;
E 3
I 3
    double anorm = this.oneNorm();
    double ynorm;
E 3

    /*## 
     ##  Factor 
     ##*/

    try {
      this.factor();
    } finally {

      /*##  
	##  Rcond = 1/A.oneNorm() * est.norm(A.inverse()).  ##
	##  est.norm = norm(Z)/norm(Y) where A*Z = Y and    ##
	##  A.transpose()*Y = E.                            ##
	##  Components of E are chosen to cause max local   ##
	##  growth in W.  Vectors are frequently rescaled   ##
	##  to avoid overflow.                              ##
	##*/
      
      /*##
	##  Solve Trans(U)*W = E    
	##*/
      
      for(int j=0;j<cols;j++) 
	Z[j] = 0;
      
      this.solveTransUW(Z);
      
D 3
      float S = (float)1.0/FUtil.asum(cols,Z,1);
      FUtil.scal(cols,S,Z,1);
E 3
I 3
      double S = 1.0/DUtil.asum(cols,Z,1);
      DUtil.scal(cols,S,Z,1);
E 3
      
      /*##
	##  Solve Trans(L)*Y = W 
	##*/

      this.solveTransLY(Z);
      
      /*##
	##  Solve L*V = Y 
	##*/
      
      ynorm = this.solveLV(Z);
      
      /*##
	##  Solve U*Z = V 
	##*/
    
      ynorm = this.solveUZ(Z,ynorm);

      /*##
	##  Make Znorm == 1  
	##*/
    }
D 3
    LFloat R = new LFloat();
E 3
I 3
D 7
    LDouble R = new LDouble();
E 7
I 7
    LDouble R;
E 7
E 3
    
    if(anorm != 0) 
D 3
      R.setFloat(ynorm/anorm);
E 3
I 3
D 7
      R.setDouble(ynorm/anorm);
E 7
I 7
      R = new LDouble(ynorm/anorm);
    else
      R = new LDouble(anorm);
E 7
E 3
    
    return R;
  }
D 3
  void solveTransUW(float[] Z) {
E 3
I 3
  void solveTransUW(double[] Z) {
E 3

D 3
    float ek = 1;
E 3
I 3
    double ek = 1;
E 3

    for(int k=0;k<cols;k++) {
      
      if(Z[k] != 0) 
D 3
	ek = FUtil.signOf(ek,-Z[k]);
E 3
I 3
	ek = DUtil.signOf(ek,-Z[k]);
E 3
      
      if(Math.abs(ek-Z[k]) > Math.abs(this.Mat[k][k])) {
D 3
	float S = Math.abs(this.Mat[k][k])/Math.abs(ek-Z[k]);
	FUtil.scal(cols,S,Z,1);
E 3
I 3
	double S = Math.abs(this.Mat[k][k])/Math.abs(ek-Z[k]);
	DUtil.scal(cols,S,Z,1);
E 3
	ek *= S;
      }
D 3
      float wk = ek - Z[k];
      float wkm = -ek - Z[k];
      float S = Math.abs(wk);
      float SM = Math.abs(wkm);
E 3
I 3
      double wk = ek - Z[k];
      double wkm = -ek - Z[k];
      double S = Math.abs(wk);
      double SM = Math.abs(wkm);
E 3
      if(this.Mat[k][k] != 0) {
	wk /= this.Mat[k][k];
	wkm /= this.Mat[k][k];
      }      
      else {
	wk = 1;
	wkm = 1;
      }
      int kp = k + 1;
      if(kp < cols) {
	for(int j=kp;j<cols;j++) {
	  SM += Math.abs(Z[j] + wkm*this.Mat[k][j]);
	  Z[j] += wk*this.Mat[k][j];
	  S += Math.abs(Z[j]);
	}
	if(S < SM) {
D 3
	  float T = wkm - wk;
E 3
I 3
	  double T = wkm - wk;
E 3
	  wk = wkm;
	  for(int j=kp;j<cols;j++) {
	    Z[j] += T*this.Mat[k][j];
	  }
	}
      }  
      Z[k] = wk;
    }
  }
D 3
  private float solveLV(float[] Z) { 
E 3
I 3
  private double solveLV(double[] Z) { 
E 3

D 3
    float ynorm = 1;
E 3
I 3
    double ynorm = 1;
E 3
    
    for(int k=0;k<cols;k++) {
      int L = pivot[k] - 1;
D 3
      float T = Z[L];
      FUtil.swapElems(Z,L,k);
E 3
I 3
      double T = Z[L];
      DUtil.swapElems(Z,L,k);
E 3
      
      if(k < cols-1) 
	this.axpy(cols-k-1,T,1,k+1,k,Z,1,k+1);
      
      if(Math.abs(Z[k]) > 1) {
D 3
	float S = (float)1.0/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
E 3
I 3
	double S = 1.0/Math.abs(Z[k]);
	DUtil.scal(cols,S,Z,1);
E 3
	ynorm *= S;
      }
    }
D 3
    float S = (float)1.0/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
    double S = 1.0/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
E 3
    ynorm *= S;

    return ynorm;
  }
D 3
  private void solveTransLY(float[] Z) {
E 3
I 3
  private void solveTransLY(double[] Z) {
E 3
    for(int k=cols-1;k>=0;k--) {
      if(k < cols-1) {
	Z[k] += this.dot(cols-k-1,1,k+1,k,Z,1,k+1);
      }
      if(Math.abs(Z[k]) > 1) {
D 3
	float S = (float)1.0/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
E 3
I 3
	double S = 1.0/Math.abs(Z[k]);
	DUtil.scal(cols,S,Z,1);
E 3
      }
      int L = pivot[k] - 1;
D 3
      FUtil.swapElems(Z,L,k);
E 3
I 3
      DUtil.swapElems(Z,L,k);
E 3
    }
    
D 3
    float S = (float)1.0/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
    double S = 1.0/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
E 3
  }
D 3
  float solveUZ(float[] Z, float ynorm) {
E 3
I 3
  double solveUZ(double[] Z, double ynorm) {
E 3
    for(int k=cols-1;k>=0;k--) {
      if(Math.abs(Z[k]) > Math.abs(this.Mat[k][k])) {
D 3
	float S = Math.abs(this.Mat[k][k])/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
E 3
I 3
	double S = Math.abs(this.Mat[k][k])/Math.abs(Z[k]);
	DUtil.scal(cols,S,Z,1);
E 3
	ynorm *= S;
      } 
      if(this.Mat[k][k] != 0) 
	Z[k] = Z[k]/this.Mat[k][k];
      else 
	Z[k] = 1;

      this.axpy(k,-Z[k],1,0,k,Z,1,0);
    }
D 3
    float S = (float)1.0/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
    double S = 1.0/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
E 3
    ynorm *= S;

    return ynorm;
  }

  /*##
   ##  this.solve solves the single precision system
   ##  A * X = B  or  A.transpose() * X = B 
   ##  using the factors computed by this.condition or this.factor.
   ##
   ##  On Entry
   ##
D 3
   ##    this.Mat   float[n][n]
E 3
I 3
   ##    this.Mat   double[n][n]
E 3
   ##               The output from this.condition or this.factor.
   ##
   ##    n          int    
   ##               The order of this.Mat.      
   ##
   ##    pivot      int(n)    
   ##               The pivot vector from this.condition or this.factor.
   ##
D 3
   ##    B          float[n]
E 3
I 3
   ##    B          double[n]
E 3
   ##               The right hand side vector.
   ##
   ##    Job        int
   ##                = 0         To solve  A*X = B ,
   ##                = non-zero  To solve  A.transpose() * X = B
   ##
   ##  On Return
   ##
   ##     B         The solution vector  X.
   ##
   ##  Error condition
   ##
   ##     A division by zero will occur if the input factor contains a 
   ##     zero on the diagonal.  Technically this indicates singularity
   ##     but it is often caused by improper arguments or improper
   ##     setting of  n.  It will not occur if the subroutines are
   ##     called correctly and if this.condition has set 
D 3
   ##     LFloat.getFloat > 0  or this.factor threw an exception
E 3
I 3
   ##     LDouble.getDouble > 0  or this.factor threw an exception
E 3
   ##
D 3
   ##  To compute  A.inverse() * C  where  C  is a FMatrix
E 3
I 3
   ##  To compute  A.inverse() * C  where  C  is a DMatrix
E 3
   ##  with  p  columns
   ##
   ##        this.condition();
D 3
   ##        if (FRcond.Rcond > threshold) {  
E 3
I 3
   ##        if (DRcond.Rcond > threshold) {  
E 3
   ##          for(int j=0;j<p;j++) 
   ##             this.solve(n,pivot,C,j,0);
   ##        }
   ##*/

D 3
  public void solve(FFull B, int c, int Job) 
E 3
I 3
  public void solve(DFull B, int c, int Job) 
E 3
       throws WrongDataTypeException
  {
D 3
    Vector F = new FVector(B.getColumn(c,0));
E 3
I 3
    Vector F = new DVector(B.getColumn(c,0));
E 3
    this.solve(F, Job);
D 3
    B.setColumn(c,F.getFloatArray());
E 3
I 3
    B.setColumn(c,F.getDoubleArray());
E 3
  }
  public void solve(Vector B) 
       throws WrongDataTypeException
  {
    this.solve(B,0);
  }
  public void solve(Vector Be, int Job) 
       throws WrongDataTypeException
  {
D 3
    float[] B = Be.getFloatArray();
E 3
I 3
    double[] B = Be.getDoubleArray();
E 3

    int nm = cols - 1;
    if(Job == 0) {
      /*##
       ##  Job == 0 - solve A*X = B  
       ##*/
      /*##
       ##  First solve L*Y = B     
       ##*/

      for(int k=0; k<nm;k++) {
	int L = pivot[k] - 1;
D 3
	float T = B[L];
E 3
I 3
	double T = B[L];
E 3
	if(L != k) {
	  B[L] = B[k];
	  B[k] = T;
	}
	this.axpy(nm-k,T,1,k+1,k,B,1,k+1);
      }

      /*##
       ##  Now solve U*X = Y  
       ##*/

      this.solveUX(B);
    }
    else {

      /*##
       ##  Job = nonzero, solve  A.transpose() * X = B  
       ##*/
      /*##
       ##  First solve  U.transpose() * Y = B
       ##*/

      this.solveTransAX(B);

      /*##
       ##  Solve  L.transpose() * X = Y
       ##*/

      for(int k=cols-2;k>=0;k--) {
	B[k] += this.dot(nm-k,1,k+1,k,B,1,k+1);
	int L = pivot[k] - 1;
	if(L != k) 
D 3
	  FUtil.swapElems(B,L,k);
E 3
I 3
	  DUtil.swapElems(B,L,k);
E 3
      }
    }
    return;
  }
  
  /*##
   ##  Solve U*X = Y  
D 3
   ##  This function is used by FPoFull
E 3
I 3
   ##  This function is used by DPoFull
E 3
   ##*/
  
D 3
  void solveUX(float[] B) {
E 3
I 3
  void solveUX(double[] B) {
E 3
    for(int k=cols-1;k>=0;k--) {
      B[k] /= this.Mat[k][k];
      this.axpy(k,-B[k],1,0,k,B,1,0);
    }
  }

  /*##
   ##  Solve  U.transpose() * Y = B
D 3
   ##  This function is used by FPoFull
E 3
I 3
   ##  This function is used by DPoFull
E 3
   ##*/

D 3
  void solveTransAX (float[] B){
E 3
I 3
  void solveTransAX (double[] B){
E 3
    for(int k=0;k<cols;k++) {
D 3
      float T = this.dot(k,1,0,k,B,1,0);
E 3
I 3
      double T = this.dot(k,1,0,k,B,1,0);
E 3
      B[k] = (B[k] - T)/this.Mat[k][k];
    }
  }

  /*##
D 3
   ##  this.determ computes the determinant of a FFull using the
E 3
I 3
   ##  this.determ computes the determinant of a DFull using the
E 3
   ##  factors computed by this.condition or this.factor.
   ##
   ##  On Entry
   ##
D 3
   ##    this.Mat   float[n][n]
E 3
I 3
   ##    this.Mat   double[n][n]
E 3
   ##               The output from this.condition or this.factor.
   ##
   ##    n          int    
   ##               The order of  this.Mat.
   ##
   ##    pivot      int[n]  
   ##               The pivot vector from this.condition or this.factor.
   ##
   ##  On Return
   ##
D 3
   ##    Det        float[2]
   ##               Determinant of original FFull
E 3
I 3
   ##    Det        double[2]
   ##               Determinant of original DFull
E 3
   ##               Determinant = Det[0] * 10.0**Det[1]
   ##               with  1  <=  Math.abs(Det[0])  <  10
   ##               or  Det[0]  ==  0.
   ##*/

  public Vector determ() {

D 3
    float[] Det = new float[2];
E 3
I 3
    double[] Det = new double[2];
E 3
    
    /*##
     ##  Compute Determinant  
     ##*/
    
    Det[0] = 1;
    Det[1] = 0;

    for(int i=0;i<cols;i++) {
      if(pivot[i] != i+1)
	Det[0] = -Det[0];
      Det[0] *= this.Mat[i][i];
      if(Det[0] == 0) {
D 3
	FVector V = new FVector(Det);
E 3
I 3
	DVector V = new DVector(Det);
E 3
	return V;
      }      
      else 
D 3
	FUtil.detNorm(Det);
E 3
I 3
	DUtil.detNorm(Det);
E 3
    }
D 3
    FVector V2 = new FVector(Det);
E 3
I 3
    DVector V2 = new DVector(Det);
E 3
    return V2;
  }
  
  /*##
D 3
   ##  this.inverse computes the inverse of a FFull using the
E 3
I 3
   ##  this.inverse computes the inverse of a DFull using the
E 3
   ##  factors computed by this.condition or this.factor.
   ##
   ##  On Entry
   ##
D 3
   ##    this.Mat   float[n][n]
E 3
I 3
   ##    this.Mat   double[n][n]
E 3
   ##               The output from this.condition or this.factor.
   ##
   ##    n          int    
   ##               The order of  this.Mat.
   ##
   ##    pivot      int[n]  
   ##               The pivot vector from this.condition or this.factor.
   ##
   ##  On Return
   ##
D 3
   ##    this.Mat   Inverse of original FFull.Mat 
E 3
I 3
   ##    this.Mat   Inverse of original DFull.Mat 
E 3
   ##
   ##  Error condition
   ##
   ##     A division by zero will occur if the input factor contains
   ##     a zero on the diagonal.  It will not occur if the subroutines
   ##     are called correctly and if this.condition has set 
D 3
   ##     FRcond.Rcond > 0 or this.factor has set info == 0.
E 3
I 3
   ##     DRcond.Rcond > 0 or this.factor has set info == 0.
E 3
   ##*/

  public void inverse() {
    /*## 
     ##  Compute Inverse of U 
     ##*/

    this.invertU();
    
    /*##
     ##  Form inverse(U)*inverse(L)  
     ##*/

    if(cols > 1) 
      this.invUinvL();
  }
  void invertU () {
        
    for(int k=0;k<cols;k++) {
D 3
      this.Mat[k][k] = (float)1.0/this.Mat[k][k];
      float T = -this.Mat[k][k];
E 3
I 3
      this.Mat[k][k] = 1.0/this.Mat[k][k];
      double T = -this.Mat[k][k];
E 3
      this.scal(k,T,1,0,k);
      for(int j=k+1;j<cols;j++) {
	T = this.Mat[k][j];
	this.Mat[k][j] = 0;
	this.axpy(k+1,T,1,0,k,this,1,0,j);
      }
    }
  }
  private void invUinvL() {
    
D 3
    float[] Work = new float[cols];
E 3
I 3
    double[] Work = new double[cols];
E 3
    
    for(int k=cols-1;k>=0;k--) {
      int kp = k+1;
      for(int i=kp;i<cols;i++) {
	Work[i] = this.Mat[i][k];
	this.Mat[i][k] = 0;
      }
      for(int j=kp;j<cols;j++) {
D 3
	float T = Work[j];
E 3
I 3
	double T = Work[j];
E 3
	this.axpy(cols,T,1,0,j,this,1,0,k);
      }
      int L = pivot[k] - 1;
      if(L != k) 
	this.swap(cols,1,0,k,this,1,0,L);
    }
  }
}
E 1
